/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.utils;

import com.github.k1ritoz.vote2Sleep.Vote2Sleep;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.scheduler.BukkitTask;

public class UpdateChecker {
    private final Vote2Sleep plugin;
    private final String githubApiUrl;
    private BukkitTask updateCheckTask;
    private String cachedLatestVersion = null;
    private boolean hasNotifiedUpdate = false;
    private static final long CHECK_INTERVAL = 1728000L;

    public UpdateChecker(Vote2Sleep plugin, String githubApiUrl) {
        this.plugin = plugin;
        this.githubApiUrl = githubApiUrl;
    }

    public void startPeriodicChecking() {
        this.stopPeriodicChecking();
        this.updateCheckTask = this.plugin.getPlatformAdapter().runTaskTimer(() -> this.plugin.getPlatformAdapter().runTaskAsync(() -> this.checkForUpdatesInternal(false)), 20L, 1728000L);
        if (this.plugin.getConfigManager().isDebugMode()) {
            this.plugin.getLogger().info("Started periodic update checking (every 24 hours)");
        }
    }

    public void stopPeriodicChecking() {
        if (this.updateCheckTask != null && !this.updateCheckTask.isCancelled()) {
            this.updateCheckTask.cancel();
            this.updateCheckTask = null;
        }
    }

    public void checkForUpdates() {
        this.plugin.getPlatformAdapter().runTaskAsync(() -> this.checkForUpdatesInternal(true));
    }

    public void forceUpdateCheck() {
        this.plugin.getPlatformAdapter().runTaskAsync(() -> {
            this.hasNotifiedUpdate = false;
            this.cachedLatestVersion = null;
            this.checkForUpdatesInternal(true);
        });
    }

    private void checkForUpdatesInternal(boolean alwaysLog) {
        block8: {
            try {
                boolean shouldNotify;
                String currentVersion = this.plugin.getDescription().getVersion();
                String latestVersion = this.getLatestVersion();
                if (latestVersion == null) {
                    if (alwaysLog) {
                        this.plugin.getLogger().warning("Could not check for updates - GitHub API unavailable");
                    }
                    return;
                }
                this.cachedLatestVersion = latestVersion;
                if (!this.isNewerVersion(currentVersion, latestVersion)) {
                    if (alwaysLog) {
                        this.plugin.getLogger().info("You are running the latest version (" + currentVersion + ")");
                    }
                    this.hasNotifiedUpdate = false;
                    return;
                }
                boolean bl = shouldNotify = !this.hasNotifiedUpdate || alwaysLog;
                if (shouldNotify) {
                    this.plugin.getLogger().info("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                    this.plugin.getLogger().info("    UPDATE AVAILABLE!");
                    this.plugin.getLogger().info("    Current: " + currentVersion);
                    this.plugin.getLogger().info("    Latest:  " + latestVersion);
                    this.plugin.getLogger().info("    Download: https://github.com/k1ritoz/Vote2Sleep/releases/latest");
                    this.plugin.getLogger().info("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                    this.hasNotifiedUpdate = true;
                }
            }
            catch (Exception e) {
                if (alwaysLog) {
                    this.plugin.getLogger().warning("Failed to check for updates: " + e.getMessage());
                }
                if (!this.plugin.getConfigManager().isDebugMode()) break block8;
                this.plugin.getLogger().warning("Update check error details:");
                e.printStackTrace();
            }
        }
    }

    private String getLatestVersion() throws Exception {
        URL url = new URL(this.githubApiUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
        connection.setRequestProperty("User-Agent", "Vote2Sleep-UpdateChecker");
        connection.setConnectTimeout(8000);
        connection.setReadTimeout(8000);
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            throw new Exception("GitHub API returned response code: " + responseCode);
        }
        StringBuilder response = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        String jsonResponse = response.toString();
        Pattern pattern = Pattern.compile("\"tag_name\"\\s*:\\s*\"([^\"]+)\"");
        Matcher matcher = pattern.matcher(jsonResponse);
        if (matcher.find()) {
            String tagName = matcher.group(1);
            return tagName.startsWith("v") ? tagName.substring(1) : tagName;
        }
        return null;
    }

    private boolean isNewerVersion(String current, String latest) {
        try {
            current = current.split("-")[0];
            latest = latest.split("-")[0];
            String[] currentParts = current.split("\\.");
            String[] latestParts = latest.split("\\.");
            int maxLength = Math.max(currentParts.length, latestParts.length);
            for (int i = 0; i < maxLength; ++i) {
                int latestPart;
                int currentPart = i < currentParts.length ? this.parseVersionPart(currentParts[i]) : 0;
                int n = latestPart = i < latestParts.length ? this.parseVersionPart(latestParts[i]) : 0;
                if (latestPart > currentPart) {
                    return true;
                }
                if (latestPart >= currentPart) continue;
                return false;
            }
            return false;
        }
        catch (NumberFormatException e) {
            if (this.plugin.getConfigManager().isDebugMode()) {
                this.plugin.getLogger().warning("Could not parse version numbers for comparison: current=" + current + ", latest=" + latest);
            }
            return false;
        }
    }

    private int parseVersionPart(String versionPart) {
        String numericPart = versionPart.replaceAll("[^0-9]", "");
        return numericPart.isEmpty() ? 0 : Integer.parseInt(numericPart);
    }

    public String getCachedLatestVersion() {
        return this.cachedLatestVersion;
    }

    public boolean hasNotifiedUpdate() {
        return this.hasNotifiedUpdate;
    }
}

