/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.commands;

import com.github.k1ritoz.vote2Sleep.Vote2Sleep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class SleepCommand
implements CommandExecutor,
TabCompleter {
    private final Vote2Sleep plugin;

    public SleepCommand(Vote2Sleep plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            if (sender instanceof Player) {
                this.handleVoteCommand((CommandSender)((Player)sender));
            } else {
                this.sendHelpMessage(sender);
            }
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "vote": 
            case "v": {
                return this.handleVoteCommand(sender);
            }
            case "status": 
            case "s": {
                return this.handleStatusCommand(sender);
            }
            case "enable": {
                return this.handleEnableCommand(sender);
            }
            case "disable": {
                return this.handleDisableCommand(sender);
            }
            case "reload": {
                return this.handleReloadCommand(sender);
            }
            case "stats": {
                return this.handleStatsCommand(sender);
            }
            case "help": 
            case "?": {
                this.sendHelpMessage(sender);
                return true;
            }
            case "cancel": {
                return this.handleCancelCommand(sender);
            }
            case "force": {
                return this.handleForceCommand(sender);
            }
            case "config": {
                return this.handleConfigCommand(sender, args);
            }
            case "language": 
            case "lang": {
                return this.handleLanguageCommand(sender, args);
            }
        }
        this.sendHelpMessage(sender);
        return true;
    }

    private boolean handleVoteCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        this.plugin.getVoteManager().startSleepVote(player);
        return true;
    }

    private boolean handleLanguageCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("vote2sleep.admin")) {
            this.plugin.getMessageManager().sendMessage((Player)sender, "no-permission");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a77Current language: \u00a7e" + this.plugin.getMessageManager().getCurrentLanguage());
            sender.sendMessage("\u00a77Available languages: \u00a7aen\u00a77, \u00a7apt_br");
            sender.sendMessage("\u00a77Usage: \u00a7e/" + args[0] + " language <en|pt_br>");
            return true;
        }
        String newLanguage = args[1].toLowerCase();
        if (!newLanguage.equals("en") && !newLanguage.equals("pt_br")) {
            sender.sendMessage("\u00a7cInvalid language! Available: en, pt_br");
            return true;
        }
        if (this.plugin.getMessageManager().changeLanguage(newLanguage)) {
            sender.sendMessage("\u00a7aLanguage changed to: " + newLanguage);
            sender.sendMessage("\u00a77Note: This change is temporary. Update config.yml to make it permanent.");
        } else {
            sender.sendMessage("\u00a7cFailed to change language to: " + newLanguage);
        }
        return true;
    }

    private boolean handleStatusCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        World world = player.getWorld();
        if (!this.plugin.getConfigManager().isWorldEnabled(world)) {
            this.plugin.getMessageManager().sendMessage(player, "world-not-enabled");
            return true;
        }
        int currentVotes = this.plugin.getApi().getCurrentVotes(world);
        int requiredVotes = this.plugin.getApi().getRequiredVotes(world);
        boolean hasVoted = this.plugin.getApi().hasPlayerVoted(player);
        boolean canSleep = this.plugin.getApi().canSleep(world);
        double progress = this.plugin.getApi().getVoteProgress(world);
        player.sendMessage(this.plugin.getMessageManager().getMessage("status.header"));
        player.sendMessage(this.plugin.getMessageManager().getMessage("status.world", Map.of("world", world.getName())));
        player.sendMessage(this.plugin.getMessageManager().getMessage("status.current-votes", Map.of("current", String.valueOf(currentVotes), "required", String.valueOf(requiredVotes))));
        player.sendMessage(this.plugin.getMessageManager().getMessage("status.you-voted", Map.of("status", hasVoted ? this.plugin.getMessageManager().getMessage("status-yes") : this.plugin.getMessageManager().getMessage("status-no"))));
        player.sendMessage(this.plugin.getMessageManager().getMessage("status.can-sleep", Map.of("status", canSleep ? this.plugin.getMessageManager().getMessage("status-yes") : this.plugin.getMessageManager().getMessage("status-no"))));
        player.sendMessage(this.plugin.getMessageManager().getMessage("status.progress", Map.of("progress", String.valueOf(Math.round(progress * 100.0)))));
        return true;
    }

    private boolean handleEnableCommand(CommandSender sender) {
        if (!sender.hasPermission("vote2sleep.enable")) {
            this.plugin.getMessageManager().sendMessage((Player)sender, "no-permission");
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        World world = player.getWorld();
        if (this.plugin.getConfigManager().isWorldEnabled(world)) {
            this.plugin.getMessageManager().sendMessage(player, "already-enabled");
        } else {
            this.plugin.getConfigManager().enableWorld(world);
            this.plugin.getMessageManager().sendMessage(player, "world-enabled", Map.of("world", world.getName()));
        }
        return true;
    }

    private boolean handleDisableCommand(CommandSender sender) {
        if (!sender.hasPermission("vote2sleep.disable")) {
            this.plugin.getMessageManager().sendMessage((Player)sender, "no-permission");
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        World world = player.getWorld();
        if (!this.plugin.getConfigManager().isWorldEnabled(world)) {
            this.plugin.getMessageManager().sendMessage(player, "already-disabled");
        } else {
            this.plugin.getConfigManager().disableWorld(world);
            this.plugin.getVoteManager().clearVotes(world);
            this.plugin.getMessageManager().sendMessage(player, "world-disabled", Map.of("world", world.getName()));
        }
        return true;
    }

    private boolean handleReloadCommand(CommandSender sender) {
        if (!sender.hasPermission("vote2sleep.reload")) {
            this.plugin.getMessageManager().sendMessage((Player)sender, "no-permission");
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players!");
            return true;
        }
        this.plugin.getConfigManager().reload();
        this.plugin.getMessageManager().reload();
        this.plugin.getMessageManager().sendMessage((Player)sender, "reload-success");
        return true;
    }

    private boolean handleStatsCommand(CommandSender sender) {
        if (!sender.hasPermission("vote2sleep.stats")) {
            this.plugin.getMessageManager().sendMessage((Player)sender, "no-permission");
            return true;
        }
        sender.sendMessage(this.plugin.getMessageManager().getMessage("stats.header"));
        sender.sendMessage(this.plugin.getMessageManager().getMessage("stats.plugin-version", Map.of("version", this.plugin.getDescription().getVersion())));
        sender.sendMessage(this.plugin.getMessageManager().getMessage("stats.platform", Map.of("platform", this.plugin.getPlatformAdapter().getPlatformName())));
        sender.sendMessage(this.plugin.getMessageManager().getMessage("stats.enabled-worlds", Map.of("count", String.valueOf(this.plugin.getConfigManager().getEnabledWorlds().size()))));
        double[] tps = this.plugin.getPlatformAdapter().getTPS();
        sender.sendMessage(this.plugin.getMessageManager().getMessage("stats.server-tps", Map.of("tps", String.format("%.2f", tps[0]))));
        String dbStatus = this.plugin.getConfigManager().isDatabaseEnabled() ? this.plugin.getMessageManager().getMessage("status-yes") : this.plugin.getMessageManager().getMessage("status-no");
        sender.sendMessage(this.plugin.getMessageManager().getMessage("stats.database-status", Map.of("status", dbStatus)));
        return true;
    }

    private boolean handleCancelCommand(CommandSender sender) {
        if (!sender.hasPermission("vote2sleep.cancel")) {
            this.plugin.getMessageManager().sendMessage((Player)sender, "no-permission");
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        World world = player.getWorld();
        this.plugin.getVoteManager().clearVotes(world);
        this.plugin.getMessageManager().sendWorldMessage(world, "votes-cancelled-by-admin", Map.of("admin", player.getName()));
        return true;
    }

    private boolean handleForceCommand(CommandSender sender) {
        if (!sender.hasPermission("vote2sleep.force")) {
            this.plugin.getMessageManager().sendMessage((Player)sender, "no-permission");
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        World world = player.getWorld();
        if (!this.plugin.getConfigManager().isWorldEnabled(world)) {
            this.plugin.getMessageManager().sendMessage(player, "world-not-enabled");
            return true;
        }
        this.plugin.getVoteManager().forceSkip(world, player);
        return true;
    }

    private boolean handleConfigCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("vote2sleep.config")) {
            this.plugin.getMessageManager().sendMessage((Player)sender, "no-permission");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /" + args[0] + " config <setting> [value]");
            sender.sendMessage("\u00a77Available settings: vote-percentage, min-players, max-players");
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        World world = player.getWorld();
        String setting = args[1].toLowerCase();
        if (args.length == 2) {
            switch (setting) {
                case "vote-percentage": {
                    double percentage = this.plugin.getConfigManager().getVotePercentage(world);
                    sender.sendMessage("\u00a77Vote percentage for \u00a7e" + world.getName() + "\u00a77: \u00a7a" + percentage * 100.0 + "%");
                    break;
                }
                case "min-players": {
                    int min = this.plugin.getConfigManager().getMinimumPlayers();
                    sender.sendMessage("\u00a77Minimum players: \u00a7a" + min);
                    break;
                }
                case "max-players": {
                    int max = this.plugin.getConfigManager().getMaximumPlayers();
                    sender.sendMessage("\u00a77Maximum players: \u00a7a" + String.valueOf(max == -1 ? "unlimited" : Integer.valueOf(max)));
                    break;
                }
                default: {
                    sender.sendMessage("\u00a7cUnknown setting: " + setting);
                    break;
                }
            }
        } else {
            String value = args[2];
            switch (setting) {
                case "vote-percentage": {
                    try {
                        double percentage = Double.parseDouble(value);
                        if (percentage < 0.1 || percentage > 1.0) {
                            sender.sendMessage("\u00a7cVote percentage must be between 0.1 and 1.0");
                            return true;
                        }
                        this.plugin.getConfigManager().setVotePercentage(world, percentage);
                        sender.sendMessage("\u00a7aVote percentage for \u00a7e" + world.getName() + "\u00a7a set to \u00a7e" + percentage * 100.0 + "%");
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage("\u00a7cInvalid number: " + value);
                    }
                    break;
                }
                default: {
                    sender.sendMessage("\u00a7cSetting \u00a7e" + setting + "\u00a7c cannot be modified in-game");
                }
            }
        }
        return true;
    }

    private void sendHelpMessage(CommandSender sender) {
        sender.sendMessage(this.plugin.getMessageManager().getMessage("help.header"));
        sender.sendMessage(this.plugin.getMessageManager().getMessage("help.vote"));
        sender.sendMessage(this.plugin.getMessageManager().getMessage("help.status"));
        if (sender.hasPermission("vote2sleep.admin")) {
            sender.sendMessage(this.plugin.getMessageManager().getMessage("help.enable"));
            sender.sendMessage(this.plugin.getMessageManager().getMessage("help.disable"));
            sender.sendMessage(this.plugin.getMessageManager().getMessage("help.reload"));
        }
        if (sender.hasPermission("vote2sleep.stats")) {
            sender.sendMessage(this.plugin.getMessageManager().getMessage("help.stats"));
        }
        if (sender.hasPermission("vote2sleep.cancel")) {
            sender.sendMessage(this.plugin.getMessageManager().getMessage("help.cancel"));
        }
        if (sender.hasPermission("vote2sleep.force")) {
            sender.sendMessage(this.plugin.getMessageManager().getMessage("help.force"));
        }
        if (sender.hasPermission("vote2sleep.admin")) {
            sender.sendMessage("\u00a7e/sleep language <en|pt_br> \u00a77- Change language");
        }
        sender.sendMessage(this.plugin.getMessageManager().getMessage("help.help"));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subCommands = Arrays.asList("vote", "status", "help");
            if (sender.hasPermission("vote2sleep.admin")) {
                subCommands = new ArrayList<String>(subCommands);
                subCommands.addAll(Arrays.asList("enable", "disable", "reload"));
            }
            if (sender.hasPermission("vote2sleep.stats")) {
                subCommands = new ArrayList<String>(subCommands);
                subCommands.add("stats");
            }
            if (sender.hasPermission("vote2sleep.cancel")) {
                subCommands = new ArrayList<String>(subCommands);
                subCommands.add("cancel");
            }
            if (sender.hasPermission("vote2sleep.force")) {
                subCommands = new ArrayList<String>(subCommands);
                subCommands.add("force");
            }
            if (sender.hasPermission("vote2sleep.config")) {
                subCommands = new ArrayList<String>(subCommands);
                subCommands.add("config");
                subCommands.add("language");
            }
            return subCommands.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("config")) {
            return Arrays.asList("vote-percentage", "min-players", "max-players").stream().filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("language")) {
            return Arrays.asList("en", "pt_br").stream().filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return completions;
    }
}

