/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.data;

import com.github.k1ritoz.vote2Sleep.data.SleepVote;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.World;

public class WorldData {
    private final World world;
    private final Map<UUID, SleepVote> votes;
    private long lastSkipTime;

    public WorldData(World world) {
        this.world = world;
        this.votes = new ConcurrentHashMap<UUID, SleepVote>();
        this.lastSkipTime = 0L;
    }

    public void addVote(SleepVote vote) {
        this.votes.put(vote.getPlayerUUID(), vote);
    }

    public void removeVote(UUID playerUUID) {
        this.votes.remove(playerUUID);
    }

    public boolean hasPlayerVoted(UUID playerUUID) {
        return this.votes.containsKey(playerUUID);
    }

    public SleepVote getVote(UUID playerUUID) {
        return this.votes.get(playerUUID);
    }

    public Map<UUID, SleepVote> getVotes() {
        return new ConcurrentHashMap<UUID, SleepVote>(this.votes);
    }

    public void clearVotes() {
        this.votes.clear();
    }

    public World getWorld() {
        return this.world;
    }

    public long getLastSkipTime() {
        return this.lastSkipTime;
    }

    public void setLastSkipTime(long lastSkipTime) {
        this.lastSkipTime = lastSkipTime;
    }

    public int getVoteCount() {
        return this.votes.size();
    }

    public boolean isEmpty() {
        return this.votes.isEmpty();
    }
}

