/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.listeners;

import com.github.k1ritoz.vote2Sleep.Vote2Sleep;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;

public class PlayerBedListener
implements Listener {
    private final Vote2Sleep plugin;

    public PlayerBedListener(Vote2Sleep plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        try {
            if (this.plugin.getPlatformAdapter().getPlatformName().equals("Folia")) {
                this.plugin.getPlatformAdapter().runTaskLaterForPlayer(player, p -> {
                    if (p.isOnline() && p.isSleeping()) {
                        this.plugin.getVoteManager().startSleepVote((Player)p);
                    }
                }, 2L);
            } else {
                this.plugin.getPlatformAdapter().runTaskLaterForPlayer(player, p -> {
                    if (p.isOnline()) {
                        this.plugin.getVoteManager().startSleepVote((Player)p);
                    }
                }, 1L);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error scheduling sleep vote for player " + player.getName() + ": " + e.getMessage());
            try {
                this.plugin.getVoteManager().startSleepVote(player);
            }
            catch (Exception fallbackError) {
                this.plugin.getLogger().severe("Failed to start sleep vote even with fallback: " + fallbackError.getMessage());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerBedLeave(PlayerBedLeaveEvent event) {
        Player player = event.getPlayer();
        try {
            this.plugin.getVoteManager().removeSleepVote(player);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error removing sleep vote for player " + player.getName() + ": " + e.getMessage());
        }
    }
}

