/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.listeners;

import com.github.k1ritoz.vote2Sleep.Vote2Sleep;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;

public class WeatherChangeListener
implements Listener {
    private final Vote2Sleep plugin;

    public WeatherChangeListener(Vote2Sleep plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onWeatherChange(WeatherChangeEvent event) {
        World world = event.getWorld();
        if (!this.plugin.getConfigManager().isWorldEnabled(world)) {
            return;
        }
        if (!event.toWeatherState()) {
            this.handleWeatherClear(world);
        }
    }

    @EventHandler
    public void onThunderChange(ThunderChangeEvent event) {
        World world = event.getWorld();
        if (!this.plugin.getConfigManager().isWorldEnabled(world)) {
            return;
        }
        if (!event.toThunderState()) {
            this.handleWeatherClear(world);
        }
    }

    private void handleWeatherClear(World world) {
        boolean isNight;
        boolean bl = isNight = world.getTime() >= 12542L && world.getTime() <= 23459L;
        if (!isNight && !this.plugin.getConfigManager().isStormSkipAllowed()) {
            this.plugin.getVoteManager().clearVotes(world);
            this.plugin.getMessageManager().sendWorldMessage(world, "weather-cleared-votes-cancelled");
        }
    }
}

