/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.managers;

import com.github.k1ritoz.vote2Sleep.Vote2Sleep;
import com.github.k1ritoz.vote2Sleep.data.SleepVote;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import org.bukkit.World;

public class DatabaseManager {
    private final Vote2Sleep plugin;
    private Connection connection;
    private boolean enabled;

    public DatabaseManager(Vote2Sleep plugin) {
        this.plugin = plugin;
        try {
            this.enabled = plugin.getConfigManager() != null && plugin.getConfigManager().isDatabaseEnabled();
        }
        catch (Exception e) {
            plugin.getLogger().warning("Could not check database configuration, disabling database: " + e.getMessage());
            this.enabled = false;
        }
        if (this.enabled) {
            this.initializeDatabase();
        } else {
            plugin.getLogger().info("Database is disabled in configuration");
        }
    }

    private void initializeDatabase() {
        String dbType;
        try {
            dbType = this.plugin.getConfigManager().getDatabaseType();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to get database type from config: " + e.getMessage());
            this.enabled = false;
            return;
        }
        try {
            if ("SQLITE".equalsIgnoreCase(dbType)) {
                this.setupSQLite();
            } else if ("MYSQL".equalsIgnoreCase(dbType)) {
                this.setupMySQL();
            } else {
                this.plugin.getLogger().warning("Unknown database type: " + dbType + ", falling back to SQLite");
                this.setupSQLite();
            }
            this.createTables();
            this.plugin.getLogger().info("Database connection established (" + dbType + ")");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to initialize database: " + e.getMessage());
            this.enabled = false;
        }
    }

    private void setupSQLite() throws SQLException {
        File dataFolder = this.plugin.getDataFolder();
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        String url = "jdbc:sqlite:" + dataFolder.getAbsolutePath() + "/vote2sleep.db";
        this.connection = DriverManager.getConnection(url);
    }

    private void setupMySQL() throws SQLException {
        this.plugin.getLogger().info("MySQL support not yet implemented, falling back to SQLite");
        this.setupSQLite();
    }

    private void createTables() throws SQLException {
        String createSkipEventsTable = "    CREATE TABLE IF NOT EXISTS skip_events (\n        id INTEGER PRIMARY KEY AUTOINCREMENT,\n        world_name TEXT NOT NULL,\n        world_uuid TEXT NOT NULL,\n        skip_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP,\n        voter_count INTEGER NOT NULL,\n        skip_type TEXT NOT NULL\n    )\n";
        String createVotesTable = "    CREATE TABLE IF NOT EXISTS votes (\n        id INTEGER PRIMARY KEY AUTOINCREMENT,\n        skip_event_id INTEGER,\n        player_uuid TEXT NOT NULL,\n        player_name TEXT NOT NULL,\n        vote_time TIMESTAMP NOT NULL,\n        location_x REAL,\n        location_y REAL,\n        location_z REAL,\n        FOREIGN KEY (skip_event_id) REFERENCES skip_events (id)\n    )\n";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(createSkipEventsTable);
            stmt.execute(createVotesTable);
        }
    }

    public void saveSkipEvent(World world, List<SleepVote> votes) {
        if (!this.enabled || this.connection == null) {
            return;
        }
        try {
            int skipEventId;
            block24: {
                String insertSkipEvent = "    INSERT INTO skip_events (world_name, world_uuid, voter_count, skip_type)\n    VALUES (?, ?, ?, ?)\n";
                try (PreparedStatement stmt = this.connection.prepareStatement(insertSkipEvent, 1);){
                    stmt.setString(1, world.getName());
                    stmt.setString(2, world.getUID().toString());
                    stmt.setInt(3, votes.size());
                    stmt.setString(4, this.determineSkipType(world));
                    stmt.executeUpdate();
                    try (ResultSet keys = stmt.getGeneratedKeys();){
                        if (keys.next()) {
                            skipEventId = keys.getInt(1);
                            break block24;
                        }
                        this.plugin.getLogger().warning("Failed to get generated key for skip event");
                        return;
                    }
                }
            }
            String insertVote = "    INSERT INTO votes (skip_event_id, player_uuid, player_name, vote_time, location_x, location_y, location_z)\n    VALUES (?, ?, ?, ?, ?, ?, ?)\n";
            try (PreparedStatement stmt = this.connection.prepareStatement(insertVote);){
                for (SleepVote vote : votes) {
                    stmt.setInt(1, skipEventId);
                    stmt.setString(2, vote.getPlayerUUID().toString());
                    stmt.setString(3, vote.getPlayerName());
                    stmt.setTimestamp(4, Timestamp.valueOf(vote.getTimestamp()));
                    stmt.setDouble(5, vote.getLocation().getX());
                    stmt.setDouble(6, vote.getLocation().getY());
                    stmt.setDouble(7, vote.getLocation().getZ());
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            this.plugin.getLogger().info("Saved skip event with " + votes.size() + " votes to database");
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to save skip event to database: " + e.getMessage());
        }
    }

    private String determineSkipType(World world) {
        boolean isStormy;
        boolean isNight = world.getTime() >= 12542L && world.getTime() <= 23459L;
        boolean bl = isStormy = world.hasStorm() || world.isThundering();
        if (isNight && isStormy) {
            return "NIGHT_STORM";
        }
        if (isNight) {
            return "NIGHT";
        }
        if (isStormy) {
            return "STORM";
        }
        return "UNKNOWN";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.plugin.getLogger().info("Database connection closed");
            }
            catch (SQLException e) {
                this.plugin.getLogger().warning("Error closing database connection: " + e.getMessage());
            }
        }
    }
}

