/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.platform;

import com.github.k1ritoz.vote2Sleep.platform.BukkitAdapter;
import com.github.k1ritoz.vote2Sleep.platform.FoliaAdapter;
import com.github.k1ritoz.vote2Sleep.platform.PaperAdapter;
import com.github.k1ritoz.vote2Sleep.platform.PlatformAdapter;
import com.github.k1ritoz.vote2Sleep.platform.PurpurAdapter;
import com.github.k1ritoz.vote2Sleep.platform.SpongeAdapter;
import org.bukkit.Bukkit;

public class PlatformDetector {
    public static PlatformAdapter createAdapter() {
        if (PlatformDetector.isFoliaPresent()) {
            return new FoliaAdapter();
        }
        if (PlatformDetector.isPurpurPresent()) {
            return new PurpurAdapter();
        }
        if (PlatformDetector.isPaperPresent()) {
            return new PaperAdapter();
        }
        if (PlatformDetector.isSpongePresent()) {
            return new SpongeAdapter();
        }
        return new BukkitAdapter();
    }

    private static boolean isFoliaPresent() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            try {
                Bukkit.class.getMethod("getGlobalRegionScheduler", new Class[0]);
                Bukkit.class.getMethod("getRegionScheduler", new Class[0]);
                Bukkit.class.getMethod("getAsyncScheduler", new Class[0]);
                return true;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isPurpurPresent() {
        try {
            Class.forName("org.purpurmc.purpur.PurpurConfig");
            Class.forName("org.purpurmc.purpur.PurpurServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            String version = Bukkit.getVersion().toLowerCase();
            String name = Bukkit.getName().toLowerCase();
            return version.contains("purpur") || name.contains("purpur");
        }
    }

    private static boolean isPaperPresent() {
        try {
            Class.forName("io.papermc.paper.configuration.Configuration");
            return true;
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("com.destroystokyo.paper.PaperConfig");
                return true;
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }
    }

    private static boolean isSpongePresent() {
        try {
            Class.forName("org.spongepowered.api.Sponge");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

