/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.utils;

import com.github.k1ritoz.vote2Sleep.Vote2Sleep;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public class UpdateChecker {
    private final Vote2Sleep plugin;
    private final String githubApiUrl;

    public UpdateChecker(Vote2Sleep plugin, String githubApiUrl) {
        this.plugin = plugin;
        this.githubApiUrl = githubApiUrl;
    }

    public void checkForUpdates() {
        this.plugin.getPlatformAdapter().runTaskAsync(() -> {
            block4: {
                try {
                    String currentVersion = this.plugin.getDescription().getVersion();
                    String latestVersion = this.getLatestVersion();
                    if (latestVersion == null) {
                        this.plugin.getLogger().warning("Could not check for updates");
                        return;
                    }
                    if (!this.isNewerVersion(currentVersion, latestVersion)) {
                        this.plugin.getLogger().info("You are running the latest version!");
                        return;
                    }
                    this.plugin.getLogger().info("New version available: " + latestVersion);
                    this.plugin.getLogger().info("You are running: " + currentVersion);
                    this.plugin.getLogger().info("Download: https://github.com/k1ritoz/Vote2Sleep/releases/latest");
                    this.plugin.getPlatformAdapter().runTaskLater(() -> Bukkit.getOnlinePlayers().stream().filter(p -> p.hasPermission("vote2sleep.admin")).forEach(p -> {
                        p.sendMessage("\u00a78[\u00a7bVote2Sleep\u00a78] \u00a7eNew version available: \u00a7a" + latestVersion);
                        p.sendMessage("\u00a78[\u00a7bVote2Sleep\u00a78] \u00a77Download at GitHub Releases");
                    }), 20L);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to check for updates: " + e.getMessage());
                    if (!this.plugin.getConfigManager().isDebugMode()) break block4;
                    e.printStackTrace();
                }
            }
        });
    }

    private String getLatestVersion() throws Exception {
        URL url = new URL(this.githubApiUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
        connection.setRequestProperty("User-Agent", "Vote2Sleep-UpdateChecker");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            throw new Exception("GitHub API returned response code: " + responseCode);
        }
        StringBuilder response = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        String jsonResponse = response.toString();
        Pattern pattern = Pattern.compile("\"tag_name\"\\s*:\\s*\"([^\"]+)\"");
        Matcher matcher = pattern.matcher(jsonResponse);
        if (matcher.find()) {
            String tagName = matcher.group(1);
            return tagName.startsWith("v") ? tagName.substring(1) : tagName;
        }
        return null;
    }

    private boolean isNewerVersion(String current, String latest) {
        try {
            current = current.split("-")[0];
            latest = latest.split("-")[0];
            String[] currentParts = current.split("\\.");
            String[] latestParts = latest.split("\\.");
            int maxLength = Math.max(currentParts.length, latestParts.length);
            for (int i = 0; i < maxLength; ++i) {
                int latestPart;
                int currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
                int n = latestPart = i < latestParts.length ? Integer.parseInt(latestParts[i]) : 0;
                if (latestPart > currentPart) {
                    return true;
                }
                if (latestPart >= currentPart) continue;
                return false;
            }
            return false;
        }
        catch (NumberFormatException e) {
            this.plugin.getLogger().warning("Could not parse version numbers for comparison");
            return false;
        }
    }
}

