/*
 * Decompiled with CFR 0.152.
 */
package mc.gmricker.mod.event;

import mc.gmricker.mod.item.VoidTotemItem;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.Heightmap;

public class OnPlayerTickEvent {
    public static void onPlayerTick(ServerPlayer player) {
        if (!player.level().isClientSide() && player.getY() < -64.0 && player.isAlive() && OnPlayerTickEvent.tryUseVoidTotem(player)) {
            OnPlayerTickEvent.teleportToSafeLocation(player);
        }
    }

    private static boolean tryUseVoidTotem(ServerPlayer player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.getItemInHand(hand);
            if (!(stack.getItem() instanceof VoidTotemItem)) continue;
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            player.level().playSound(null, player.blockPosition(), SoundEvents.TOTEM_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 25));
            return true;
        }
        return false;
    }

    private static void teleportToSafeLocation(ServerPlayer player) {
        int z;
        ServerLevel level = (ServerLevel)player.level();
        int baseX = player.getBlockX();
        int baseZ = player.getBlockZ();
        int radius = 5;
        int x = baseX + level.random.nextInt(radius * 2 + 1) - radius;
        int y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z = baseZ + level.random.nextInt(radius * 2 + 1) - radius);
        if (y <= 0) {
            BlockPos spawn = level.getSharedSpawnPos();
            x = spawn.getX();
            y = spawn.getY();
            z = spawn.getZ();
        }
        player.teleportTo(level, (double)x + 0.5, (double)y + 1.0, (double)z + 0.5, player.getYRot(), player.getXRot());
    }
}

