/*
 * Decompiled with CFR 0.152.
 */
package mc.gmricker.mod.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MilkBottleItem
extends Item {
    public MilkBottleItem() {
        super(new Item.Properties().stacksTo(16).food(new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).alwaysEdible().build()));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"item.complementary.milk_bottle.desc"));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.isClientSide) {
                List<MobEffectInstance> harmEffects = player.getActiveEffects().stream().filter(e -> ((MobEffect)e.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL).toList();
                List<MobEffectInstance> neutralEffects = player.getActiveEffects().stream().filter(e -> ((MobEffect)e.getEffect().value()).getCategory() == MobEffectCategory.NEUTRAL).toList();
                if (!harmEffects.isEmpty()) {
                    MobEffectInstance effect = harmEffects.get(0);
                    player.removeEffect(effect.getEffect());
                } else if (!player.getActiveEffects().isEmpty()) {
                    MobEffectInstance effect = (MobEffectInstance)player.getActiveEffects().iterator().next();
                    player.removeEffect(effect.getEffect());
                }
            }
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
                if (stack.isEmpty()) {
                    return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                }
                player.getInventory().add(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            }
        }
        return stack;
    }
}

