/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.sbmgrowmeal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class GrowmealItem
extends Item {
    public static int tries = 1000;

    public GrowmealItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        BlockPos clickedPos = ctx.getClickedPos();
        BlockPos relativePos = clickedPos.relative(ctx.getClickedFace());
        if (this.cycleGrowth(level, clickedPos, ctx.getPlayer(), BoneMealItem::applyBonemeal)) {
            if (!level.isClientSide()) {
                ctx.getItemInHand().shrink(1);
                ctx.getPlayer().gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
                level.levelEvent(1505, clickedPos, 15);
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        BlockState clickedState = level.getBlockState(clickedPos);
        boolean isFaceSturdy = clickedState.isFaceSturdy((BlockGetter)level, clickedPos, ctx.getClickedFace());
        if (isFaceSturdy && this.cycleGrowth(level, relativePos, ctx.getClickedFace(), BoneMealItem::growWaterPlant)) {
            if (!level.isClientSide()) {
                ctx.getItemInHand().shrink(1);
                ctx.getPlayer().gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
                level.levelEvent(1505, relativePos, 15);
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        return InteractionResult.PASS;
    }

    protected <T> boolean cycleGrowth(Level level, BlockPos posToGrow, T arg, PlantGrower<T> grower) {
        boolean hasGrown = false;
        ItemStack stack = new ItemStack((ItemLike)Items.BONE_MEAL, 2);
        for (int i = 0; i < tries; ++i) {
            if (!grower.grow(stack, level, posToGrow, arg)) {
                if (!hasGrown) break;
                return true;
            }
            stack.grow(1);
            hasGrown = true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface PlantGrower<T> {
        public boolean grow(ItemStack var1, Level var2, BlockPos var3, T var4);
    }
}

