/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.stereowalker.survive.FoodUtils;
import com.stereowalker.survive.SurviveClientSegment;
import com.stereowalker.survive.api.needs.PlayerNeeds;
import com.stereowalker.survive.api.needs.Stamina;
import com.stereowalker.survive.api.needs.Temperature;
import com.stereowalker.survive.api.needs.Water;
import com.stereowalker.survive.compat.OriginsCompat;
import com.stereowalker.survive.compat.SItemProperties;
import com.stereowalker.survive.config.Config;
import com.stereowalker.survive.config.FoodConfig;
import com.stereowalker.survive.config.HygieneConfig;
import com.stereowalker.survive.config.ServerConfig;
import com.stereowalker.survive.config.StaminaConfig;
import com.stereowalker.survive.config.TemperatureConfig;
import com.stereowalker.survive.config.ThirstConfig;
import com.stereowalker.survive.config.WellbeingConfig;
import com.stereowalker.survive.core.cauldron.SCauldronInteraction;
import com.stereowalker.survive.core.particles.SParticleTypes;
import com.stereowalker.survive.core.registries.SurviveRegistries;
import com.stereowalker.survive.events.SleepEvents;
import com.stereowalker.survive.events.SurviveEvents;
import com.stereowalker.survive.events.TempEvents;
import com.stereowalker.survive.events.ThirstEvents;
import com.stereowalker.survive.hooks.ColdStorage;
import com.stereowalker.survive.json.ArmorJsonHolder;
import com.stereowalker.survive.json.BiomeJsonHolder;
import com.stereowalker.survive.json.BlockTemperatureJsonHolder;
import com.stereowalker.survive.json.EntityTemperatureJsonHolder;
import com.stereowalker.survive.json.FoodJsonHolder;
import com.stereowalker.survive.json.PotionJsonHolder;
import com.stereowalker.survive.json.property.BlockPropertyHandlerImpl;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.StaminaData;
import com.stereowalker.survive.network.protocol.game.ClientboundDataTransferPacket;
import com.stereowalker.survive.network.protocol.game.ClientboundDrinkSoundPacket;
import com.stereowalker.survive.network.protocol.game.ClientboundSurvivalStatsPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundArmorStaminaPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundInteractWithWaterPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundPlayerStatusBookPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundRelaxPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundStaminaExhaustionPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundThirstMovementPacket;
import com.stereowalker.survive.resource.ArmorDataManager;
import com.stereowalker.survive.resource.BiomeDataManager;
import com.stereowalker.survive.resource.BlockDataManager;
import com.stereowalker.survive.resource.EntityTemperatureDataManager;
import com.stereowalker.survive.resource.FluidDataManager;
import com.stereowalker.survive.resource.ItemConsummableDataManager;
import com.stereowalker.survive.resource.PotionDrinkDataManager;
import com.stereowalker.survive.server.commands.NeedsCommand;
import com.stereowalker.survive.tags.FluidSTags;
import com.stereowalker.survive.tags.ItemSTags;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import com.stereowalker.survive.world.inventory.SMenuType;
import com.stereowalker.survive.world.item.CanteenItem;
import com.stereowalker.survive.world.item.HygieneItems;
import com.stereowalker.survive.world.item.SArmorMaterials;
import com.stereowalker.survive.world.item.SCreativeModeTab;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.alchemy.SPotions;
import com.stereowalker.survive.world.item.component.SDataComponents;
import com.stereowalker.survive.world.item.crafting.SRecipeSerializer;
import com.stereowalker.survive.world.item.enchantment.StaminaEnchantments;
import com.stereowalker.survive.world.item.enchantment.TemperatureEnchantments;
import com.stereowalker.survive.world.level.CGameRules;
import com.stereowalker.survive.world.level.block.SBlocks;
import com.stereowalker.survive.world.level.block.entity.SBlockEntityType;
import com.stereowalker.survive.world.level.material.PurifiedWaterFluid;
import com.stereowalker.survive.world.level.material.SFluids;
import com.stereowalker.survive.world.seasons.Seasons;
import com.stereowalker.survive.world.spellcraft.SSpells;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeConditions;
import com.stereowalker.unionlib.api.collectors.BrewingRecipeCollector;
import com.stereowalker.unionlib.api.collectors.CommandCollector;
import com.stereowalker.unionlib.api.collectors.ConfigCollector;
import com.stereowalker.unionlib.api.collectors.DefaultAttributeModifier;
import com.stereowalker.unionlib.api.collectors.FluidPropertyCollector;
import com.stereowalker.unionlib.api.collectors.InsertCollector;
import com.stereowalker.unionlib.api.collectors.PackCollector;
import com.stereowalker.unionlib.api.collectors.PacketCollector;
import com.stereowalker.unionlib.api.collectors.ReloadListeners;
import com.stereowalker.unionlib.api.creativetabs.CreativeTabBuilder;
import com.stereowalker.unionlib.api.creativetabs.CreativeTabPopulator;
import com.stereowalker.unionlib.api.insert.InsertResultCanceller;
import com.stereowalker.unionlib.api.insert.InsertSetter;
import com.stereowalker.unionlib.api.registries.RegistryCollector;
import com.stereowalker.unionlib.config.ConfigObject;
import com.stereowalker.unionlib.insert.InsertHandler;
import com.stereowalker.unionlib.insert.Inserts;
import com.stereowalker.unionlib.insert.ServerInserts;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.PacketHolder;
import com.stereowalker.unionlib.mod.ServerSegment;
import com.stereowalker.unionlib.resource.ReloadListener;
import com.stereowalker.unionlib.util.LoaderHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.level.material.FluidProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="survive")
public class Survive
extends MinecraftMod
implements PacketHolder {
    public static final float DEFAULT_TEMP = 37.0f;
    public static final int PURIFIED_WATER_COLOR = -12463112;
    public static Map<Holder<Potion>, List<Fluid>> POTION_FLUID_MAP;
    public static final String MOD_ID = "survive";
    public static final Config CONFIG;
    public static final FoodConfig FOOD_CONFIG;
    public static final StaminaConfig STAMINA_CONFIG;
    public static final HygieneConfig HYGIENE_CONFIG;
    public static final TemperatureConfig TEMPERATURE_CONFIG;
    public static final ThirstConfig THIRST_CONFIG;
    public static final WellbeingConfig WELLBEING_CONFIG;
    public static final Codec<Long> NON_NEGATIVE_LONG;
    public static boolean isPrimalWinterLoaded;
    public static final ItemConsummableDataManager consummableReloader;
    public static final PotionDrinkDataManager potionReloader;
    public static final ArmorDataManager armorReloader;
    public static final BlockDataManager blockReloader;
    public static final BiomeDataManager biomeReloader;
    public static final EntityTemperatureDataManager entityReloader;
    public static final FluidDataManager fluidReloader;
    private static Survive instance;

    public static void sendPacket(WrittenBookContent tag) {
        new ServerboundPlayerStatusBookPacket(tag, !Survive.TEMPERATURE_CONFIG.displayTempInFahrenheit, I18n.get((String)"book.patient.sleep", (Object[])new Object[]{"%1$s"}), I18n.get((String)"book.patient.temperature", (Object[])new Object[]{"%1$s"})).send();
    }

    public static boolean isCombatLoaded() {
        return LoaderHelper.isModLoaded((String)"combat");
    }

    public static boolean isOriginsLoaded() {
        return LoaderHelper.isModLoaded((String)"origins");
    }

    public Survive() {
        super(MOD_ID, () -> new SurviveClientSegment(), () -> new ServerSegment());
        instance = this;
        this.eventBus().addListener(this::clientRegistries);
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getPotion() == SPotions.PURIFIED_WATER.holder()) {
                event.setFluid((Fluid)SFluids.PURIFIED_WATER);
                event.setFlowingFluid((Fluid)SFluids.FLOWING_PURIFIED_WATER);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getFluid().getType() instanceof PurifiedWaterFluid) {
                event.setPotion(SPotions.PURIFIED_WATER.holder());
            }
        });
        isPrimalWinterLoaded = LoaderHelper.isModLoaded((String)"primalwinter");
        try {
            PlayerNeeds.setImpl(new PlayerNeeds(this){

                @Override
                public Temperature getTemperature(LivingEntity entity) {
                    return ((IRealisticEntity)entity).temperatureData();
                }

                @Override
                public Stamina getStamina(LivingEntity entity) {
                    return ((IRealisticEntity)entity).staminaData();
                }

                @Override
                public Water getWater(LivingEntity entity) {
                    return ((IRealisticEntity)entity).waterData();
                }
            });
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
    }

    public void onModConstruct() {
        new FluidSTags();
        new ItemSTags();
        if (Survive.isCombatLoaded()) {
            SSpells.registerAll(this.eventBus());
        }
        if (Survive.isOriginsLoaded()) {
            OriginsCompat.initOriginsPatcher();
        }
        BlockPropertyHandlerImpl.init();
    }

    public void setupBrewingRecipes(BrewingRecipeCollector collector) {
        collector.addMix(Potions.AWKWARD, SItems.ICE_CUBE, SPotions.COLD_RESISTANCE);
        collector.addMix(SPotions.COLD_RESISTANCE, Items.REDSTONE, SPotions.LONG_COLD_RESISTANCE);
        collector.addMix(SPotions.COLD_RESISTANCE, Items.GLOWSTONE_DUST, SPotions.STRONG_COLD_RESISTANCE);
        collector.addMix(Potions.AWKWARD, SItems.MAGMA_PASTE, SPotions.HEAT_RESISTANCE);
        collector.addMix(SPotions.HEAT_RESISTANCE, Items.REDSTONE, SPotions.LONG_HEAT_RESISTANCE);
        collector.addMix(SPotions.HEAT_RESISTANCE, Items.GLOWSTONE_DUST, SPotions.STRONG_HEAT_RESISTANCE);
        collector.builder().addContainer(SItems.FILLED_CANTEEN);
        collector.builder().addContainer(SItems.FILLED_NETHERITE_CANTEEN);
    }

    public void setupPacks(PackCollector collector) {
        collector.addPack("datapacks/replace_vanilla", (Component)Component.literal((String)"Replace Vanilla"), PackType.SERVER_DATA);
    }

    public void setupFluids(FluidPropertyCollector collector) {
        collector.forFluid(FluidProperties.create((ResourceLocation)this.location("purified_water")).flowingTexture(this.location("block/purified_water_flow")).stillTexture(this.location("block/purified_water_still")).overlayTexture(this.location("block/purified_water_overlay")).tint((fl, getter, pos) -> BiomeColors.getAverageWaterColor((BlockAndTintGetter)getter, (BlockPos)pos) | 0xFE41D3F8).tint(-25081124).fallDistanceModifier(0.0f).canExtinguish(true).supportsBoats(true).toProperties(), new Supplier[]{() -> SFluids.FLOWING_PURIFIED_WATER, () -> SFluids.PURIFIED_WATER});
    }

    public void onModStartup() {
        SCauldronInteraction.bootStrap();
        CGameRules.init();
    }

    public void onModStartupInClient() {
    }

    public void setupConfigs(ConfigCollector collector) {
        collector.registerConfig(ServerConfig.class);
        collector.registerConfig((ConfigObject)FOOD_CONFIG);
        collector.registerConfig((ConfigObject)CONFIG);
        collector.registerConfig((ConfigObject)HYGIENE_CONFIG);
        collector.registerConfig((ConfigObject)TEMPERATURE_CONFIG);
        collector.registerConfig((ConfigObject)THIRST_CONFIG);
        collector.registerConfig((ConfigObject)WELLBEING_CONFIG);
        collector.registerConfig((ConfigObject)STAMINA_CONFIG);
    }

    public void setupCommands(CommandCollector collector) {
        NeedsCommand.register((CommandDispatcher<CommandSourceStack>)collector.dispatcher());
    }

    public void setupRegistries(RegistryCollector collector) {
        collector.addRegistryHolder(Registries.ATTRIBUTE, SAttributes.class);
        collector.addRegistryHolder(Registries.ARMOR_MATERIAL, SArmorMaterials.class);
        collector.addRegistryHolder(Registries.BLOCK, SBlocks.class);
        collector.addRegistryHolder(Registries.FLUID, SFluids.class);
        collector.addRegistryHolder(Registries.ITEM, SItems.class);
        collector.addRegistryHolder(Registries.ITEM, HygieneItems.class);
        collector.addRegistryHolder(Registries.MOB_EFFECT, SMobEffects.class);
        collector.addRegistryHolder(Registries.RECIPE_SERIALIZER, SRecipeSerializer.class);
        collector.addRegistryHolder(Registries.DATA_COMPONENT_TYPE, SDataComponents.class);
        collector.addRegistryHolder(Registries.ARMOR_MATERIAL, SArmorMaterials.class);
        collector.addRegistryHolder(Registries.POTION, SPotions.class);
        collector.addRegistryHolder(Registries.PARTICLE_TYPE, SParticleTypes.class);
        if (Survive.STAMINA_CONFIG.enabled) {
            collector.addRegistryHolder(Registries.ENCHANTMENT, StaminaEnchantments.class);
        }
        if (Survive.TEMPERATURE_CONFIG.enabled) {
            collector.addRegistryHolder(Registries.ENCHANTMENT, TemperatureEnchantments.class);
        }
        collector.addRegistryHolder(Registries.MENU, SMenuType.class);
        collector.addRegistry(SurviveRegistries.CONDITION, SurviveRegistries.Keys.CONDITION, true);
        collector.addRegistry(SurviveRegistries.SEASON, SurviveRegistries.Keys.SEASON, true);
        collector.addCustom(SurviveRegistries.Keys.CONDITION, TemperatureChangeConditions::registerAll);
        collector.addCustom(SurviveRegistries.Keys.SEASON, Seasons::registerAll);
        collector.addCustom(Registries.BLOCK_ENTITY_TYPE, SBlockEntityType::registerAll);
        collector.addCustom(Registries.MOB_EFFECT, override -> ((MobEffect)MobEffects.FIRE_RESISTANCE.value()).addAttributeModifier(SAttributes.HEAT_RESISTANCE.holder(), "795606d6-4ac6-4ae7-8311-63ccdb293eb4", 5.0, AttributeModifier.Operation.ADD_VALUE));
        collector.addCustom(Registries.POTION, override -> {
            POTION_FLUID_MAP = new ImmutableMap.Builder().put((Object)Potions.WATER, (Object)Lists.newArrayList((Object[])new Fluid[]{Fluids.FLOWING_WATER, Fluids.WATER})).put((Object)SPotions.PURIFIED_WATER.holder(), (Object)Lists.newArrayList((Object[])new Fluid[]{SFluids.FLOWING_PURIFIED_WATER, SFluids.PURIFIED_WATER})).build();
        });
    }

    public void registerInserts(InsertCollector collector) {
        collector.addInsert((InsertHandler)Inserts.LIVING_TICK, insert -> SurviveEvents.sendToClient(insert.living()));
        collector.addInsert((InsertHandler)Inserts.LIVING_TICK, insert -> SurviveEvents.updateEnvTemperature(insert.living()));
        collector.addInsert((InsertHandler)Inserts.PLAYER_RESTORE, insert -> SurviveEvents.restoreStats(insert.thisPlayer(), insert.thatPlayer(), insert.keepEverything()));
        collector.addInsert((InsertHandler)Inserts.LOGGED_OUT, insert -> SurviveEvents.desyncClient(insert.player()));
        collector.addInsert((InsertHandler)ServerInserts.SERVER_STARTING, insert -> TempEvents.serverStart(insert.server()));
        collector.addInsert((InsertHandler)ServerInserts.SERVER_STOPPING, insert -> TempEvents.serverStop(insert.server()));
        collector.addInsert((InsertHandler)Inserts.LEVEL_LOAD, insert -> SurviveEvents.addReload(insert.level()));
        collector.addInsert((InsertHandler)Inserts.LOOT_TABLE_LOAD, insert -> {
            String ANIMAL_LOOT = "entities/animal_fat";
            ArrayList LOOT_MODIFIERS = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)VersionHelper.toLoc((String)"entities/sheep"), (Object)Lists.newArrayList((Object[])new String[]{ANIMAL_LOOT})), Pair.of((Object)VersionHelper.toLoc((String)"entities/chicken"), (Object)Lists.newArrayList((Object[])new String[]{ANIMAL_LOOT})), Pair.of((Object)VersionHelper.toLoc((String)"entities/cow"), (Object)Lists.newArrayList((Object[])new String[]{ANIMAL_LOOT})), Pair.of((Object)VersionHelper.toLoc((String)"entities/pig"), (Object)Lists.newArrayList((Object[])new String[]{ANIMAL_LOOT}))});
            BiFunction<String, Integer, LootPoolEntryContainer.Builder> getInjectEntry = (name, weight) -> {
                ResourceKey table = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Survive.getInstance().location("inject/" + name));
                return NestedLootTable.lootTableReference((ResourceKey)table).setWeight(weight.intValue());
            };
            LOOT_MODIFIERS.forEach(pair -> {
                if (insert.name().equals(pair.getKey())) {
                    ((List)pair.getValue()).forEach(file -> {
                        Survive.getInstance().debug("Injecting \"" + file + "\" in " + String.valueOf(pair.getKey()));
                        LoaderHelper.addPoolToLootTable((LootTable)((LootTable)insert.table().get()), (LootPool)LootPool.lootPool().add((LootPoolEntryContainer.Builder)getInjectEntry.apply((String)file, 1)).setBonusRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).name("survive_inject").build());
                    });
                }
            });
        });
        collector.addInsert((InsertHandler)Inserts.MENU_OPEN, insert -> {
            if (insert.player() != null) {
                FoodUtils.giveLifespanToFood((NonNullList<ItemStack>)insert.menu().getItems(), insert.player().level().getGameTime());
            }
        });
        collector.addInsert((InsertHandler)Inserts.PLAYER_CAN_SLEEP, insert -> SleepEvents.allowSleep(insert.player(), insert.pos(), insert.vanillaProblem(), (InsertSetter<Player.BedSleepingProblem>)insert.problem()));
        collector.addInsert((InsertHandler)Inserts.PLAYER_CONTINUE_SLEEP, insert -> SleepEvents.allowSleep(insert.player(), insert.sleepingPos(), (InsertSetter<Boolean>)insert.mayContinueSleeping()));
        collector.addInsert((InsertHandler)Inserts.INTERACT_WITH_BLOCK, insert -> ThirstEvents.interactWithWaterSourceBlock(insert.player(), insert.level(), insert.hand(), insert.hitResult(), (InsertResultCanceller<InteractionResult>)insert.cancel()));
        collector.addInsert((InsertHandler)Inserts.INTERACT_WITH_ITEM, insert -> ThirstEvents.interactWithWaterSourceBlock(insert.player(), insert.level(), insert.hand(), (InsertResultCanceller<InteractionResultHolder<ItemStack>>)insert.cancel()));
        collector.addInsert((InsertHandler)Inserts.INTERACT_WITH_ITEM, insert -> StaminaData.clickItem(insert.player(), insert.level(), insert.hand(), (InsertResultCanceller<InteractionResultHolder<ItemStack>>)insert.cancel()));
        collector.addInsert((InsertHandler)Inserts.MENU_OPEN, insert -> {
            ChestMenu chest;
            Container patt1$temp;
            AbstractContainerMenu patt0$temp = insert.menu();
            if (patt0$temp instanceof ChestMenu && (patt1$temp = (chest = (ChestMenu)patt0$temp).getContainer()) instanceof ChestBlockEntity) {
                ChestBlockEntity block = (ChestBlockEntity)patt1$temp;
                Player patt2$temp = insert.player();
                if (patt2$temp instanceof ServerPlayer) {
                    ServerPlayer pl = (ServerPlayer)patt2$temp;
                    ColdStorage coldStorage = (ColdStorage)block;
                }
            }
        });
        collector.addInsert((InsertHandler)Inserts.LEVEL_WAKE_UP, insert -> SleepEvents.replenishEnergy(insert.level()));
    }

    public void modifyDefaultEntityAttributes(DefaultAttributeModifier modifier) {
        super.modifyDefaultEntityAttributes(modifier);
        modifier.addToEntity(EntityType.PLAYER, new Holder[]{SAttributes.COLD_RESISTANCE.holder(), SAttributes.HEAT_RESISTANCE.holder(), SAttributes.MAX_STAMINA.holder()});
    }

    public void registerPackets(PacketCollector collector) {
        collector.registerServerboundPacket(ServerboundArmorStaminaPacket.id, ServerboundArmorStaminaPacket.class, ServerboundArmorStaminaPacket::new);
        collector.registerServerboundPacket(ServerboundThirstMovementPacket.id, ServerboundThirstMovementPacket.class, ServerboundThirstMovementPacket::new);
        collector.registerServerboundPacket(ServerboundInteractWithWaterPacket.id, ServerboundInteractWithWaterPacket.class, ServerboundInteractWithWaterPacket::new);
        collector.registerServerboundPacket(ServerboundStaminaExhaustionPacket.id, ServerboundStaminaExhaustionPacket.class, ServerboundStaminaExhaustionPacket::new);
        collector.registerServerboundPacket(ServerboundRelaxPacket.id, ServerboundRelaxPacket.class, ServerboundRelaxPacket::new);
        collector.registerServerboundPacket(ServerboundPlayerStatusBookPacket.id, ServerboundPlayerStatusBookPacket.class, ServerboundPlayerStatusBookPacket::new);
        collector.registerClientboundPacket(ClientboundSurvivalStatsPacket.id, ClientboundSurvivalStatsPacket.class, ClientboundSurvivalStatsPacket::new);
        collector.registerClientboundPacket(ClientboundDrinkSoundPacket.id, ClientboundDrinkSoundPacket.class, ClientboundDrinkSoundPacket::new);
        collector.registerClientboundPacket(ClientboundDataTransferPacket.id, ClientboundDataTransferPacket.class, ClientboundDataTransferPacket::new);
    }

    public static void registerDrinkDataForItem(ResourceLocation location, FoodJsonHolder drinkData) {
        DataMaps.Server.consummableItem.put(location, drinkData);
    }

    public static void registerDrinkDataForPotion(ResourceLocation location, PotionJsonHolder consummableData) {
        DataMaps.Server.potionDrink.put(location, consummableData);
    }

    public static void registerArmorTemperatures(ResourceLocation location, ArmorJsonHolder armorData) {
        DataMaps.Server.armor.put(location, armorData);
    }

    public static void registerBlockTemperatures(ResourceLocation location, BlockTemperatureJsonHolder drinkData) {
        DataMaps.Server.blockTemperature.put(location, drinkData);
    }

    public static void registerEntityTemperatures(ResourceLocation location, EntityTemperatureJsonHolder drinkData) {
        DataMaps.Server.entityTemperature.put(location, drinkData);
    }

    public static void registerBiomeTemperatures(ResourceLocation location, BiomeJsonHolder biomeData) {
        DataMaps.Server.biome.put(location, biomeData);
    }

    public void debug(Object message) {
        if (Survive.CONFIG.debugMode) {
            this.getLogger().debug(message);
        }
    }

    public void clientRegistries(FMLClientSetupEvent event) {
        event.enqueueWork(() -> SItemProperties.registerAll());
    }

    public static ItemStack convertToPlayerStatusBook(ItemStack stack) {
        ItemStack result = new ItemStack((ItemLike)Items.WRITTEN_BOOK);
        result.applyComponents(stack.getComponents());
        SDataComponents.STATUS_OWNER_D.setData(result, (Object)UUID.fromString("00000000-0000-0000-0000-000000000000"));
        WrittenBookContent book = (WrittenBookContent)result.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (book != null) {
            WrittenBookContent b = new WrittenBookContent(book.title(), book.author(), 0, book.pages(), book.resolved());
            result.set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)b);
        }
        return result;
    }

    public void registerServerRelaodableResources(ReloadListeners reloadListener) {
        reloadListener.listenTo((ReloadListener)consummableReloader);
        reloadListener.listenTo((ReloadListener)potionReloader);
        reloadListener.listenTo((ReloadListener)armorReloader);
        reloadListener.listenTo((ReloadListener)blockReloader);
        reloadListener.listenTo((ReloadListener)biomeReloader);
        reloadListener.listenTo((ReloadListener)entityReloader);
        reloadListener.listenTo((ReloadListener)fluidReloader);
    }

    public void registerCreativeTabs(CreativeTabBuilder builder) {
        builder.addTab("main_tab", SCreativeModeTab.TAB_MAIN);
    }

    public void populateCreativeTabs(CreativeTabPopulator populator) {
        if (populator.getTab().getDisplayName().equals((Object)SCreativeModeTab.TAB_MAIN.getDisplayName()) && Survive.HYGIENE_CONFIG.enabled) {
            populator.addItems(new Item[]{HygieneItems.BATH_SPONGE});
            populator.addItems(new Item[]{HygieneItems.WHITE_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.ORANGE_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.MAGENTA_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.LIGHT_BLUE_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.YELLOW_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.LIME_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.PINK_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.GRAY_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.LIGHT_GRAY_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.CYAN_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.PURPLE_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.BLUE_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.BROWN_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.GREEN_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.RED_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.BLACK_WASHCLOTH});
            populator.addItems(new Item[]{HygieneItems.WOOD_ASH});
            populator.addItems(new Item[]{HygieneItems.POTASH_SOLUTION});
            populator.addItems(new Item[]{HygieneItems.POTASH});
            populator.addItems(new Item[]{HygieneItems.ANIMAL_FAT});
            populator.addItems(new Item[]{HygieneItems.SOAP_MIX});
            populator.addItems(new Item[]{HygieneItems.SOAP_BOTTLE});
        }
        if (populator.getTab().getDisplayName().equals((Object)SCreativeModeTab.TAB_MAIN.getDisplayName())) {
            populator.addItems(new Item[]{SItems.WOOL_HAT});
            populator.addItems(new Item[]{SItems.WOOL_JACKET});
            populator.addItems(new Item[]{SItems.WOOL_PANTS});
            populator.addItems(new Item[]{SItems.WOOL_BOOTS});
            populator.addItems(new Item[]{SItems.STIFFENED_HONEY_HELMET});
            populator.addItems(new Item[]{SItems.STIFFENED_HONEY_CHESTPLATE});
            populator.addItems(new Item[]{SItems.STIFFENED_HONEY_LEGGINGS});
            populator.addItems(new Item[]{SItems.STIFFENED_HONEY_BOOTS});
            populator.addItems(new Item[]{SItems.WATER_BOWL});
            populator.addItems(new Item[]{SItems.PURIFIED_WATER_BOWL});
            populator.addItems(new Item[]{SItems.ICE_CUBE});
            populator.addItems(new Item[]{SItems.THERMOMETER});
            populator.addItems(new Item[]{SItems.TEMPERATURE_REGULATOR});
            populator.addItems(new Item[]{SItems.LARGE_HEATING_PLATE});
            populator.addItems(new Item[]{SItems.LARGE_COOLING_PLATE});
            populator.addItems(new Item[]{SItems.MEDIUM_HEATING_PLATE});
            populator.addItems(new Item[]{SItems.MEDIUM_COOLING_PLATE});
            populator.addItems(new Item[]{SItems.SMALL_HEATING_PLATE});
            populator.addItems(new Item[]{SItems.SMALL_COOLING_PLATE});
            populator.addItems(new Item[]{SItems.CHARCOAL_FILTER});
            populator.addItems(new Item[]{SItems.USED_CHARCOAL_FILTER});
            populator.addItems(new Item[]{SItems.PURIFIED_WATER_BUCKET});
            populator.addItems(new Item[]{SItems.MAGMA_PASTE});
            populator.addItems(new Item[]{SItems.SEA_SALT});
            populator.addItems(new Item[]{SItems.SALT_BOX});
            populator.addItems(new Item[]{SItems.REALISTIC_CAMPFIRE});
            populator.addItems(new Item[]{SItems.CANTEEN});
            populator.getParams().holders().lookup(Registries.POTION).ifPresent(p_327138_ -> Survive.generatePotionEffectTypes(populator.getOutput(), (HolderLookup<Potion>)p_327138_, SItems.FILLED_CANTEEN, Survive.THIRST_CONFIG.canteen_fill_amount, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
            populator.addItems(new Item[]{SItems.NETHERITE_CANTEEN});
            populator.getParams().holders().lookup(Registries.POTION).ifPresent(p_327138_ -> Survive.generatePotionEffectTypes(populator.getOutput(), (HolderLookup<Potion>)p_327138_, SItems.FILLED_NETHERITE_CANTEEN, Survive.THIRST_CONFIG.nether_canteen_fill_amount, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
        }
    }

    private static void generatePotionEffectTypes(CreativeModeTab.Output pOutput, HolderLookup<Potion> pPotions, Item pItem, int max, CreativeModeTab.TabVisibility pTabVisibility) {
        pPotions.listElements().map(potion -> CanteenItem.addToCanteen(new ItemStack((ItemLike)pItem), max, (Holder<Potion>)potion)).forEach(p_270000_ -> pOutput.accept(p_270000_, pTabVisibility));
    }

    public static List<String> defaultDimensionMods() {
        ArrayList<String> dims = new ArrayList<String>();
        dims.add("minecraft:overworld,0.0");
        dims.add("minecraft:the_nether,0.0");
        dims.add("minecraft:the_end,0.0");
        return dims;
    }

    public static Survive getInstance() {
        return instance;
    }

    static {
        CONFIG = new Config();
        FOOD_CONFIG = new FoodConfig();
        STAMINA_CONFIG = new StaminaConfig();
        HYGIENE_CONFIG = new HygieneConfig();
        TEMPERATURE_CONFIG = new TemperatureConfig();
        THIRST_CONFIG = new ThirstConfig();
        WELLBEING_CONFIG = new WellbeingConfig();
        NON_NEGATIVE_LONG = Codec.LONG.validate(p_274889_ -> p_274889_.compareTo(0L) >= 0 && p_274889_.compareTo(Long.MAX_VALUE) <= 0 ? DataResult.success((Object)p_274889_) : DataResult.error(() -> "Value must be non-negative: " + p_274889_));
        consummableReloader = new ItemConsummableDataManager();
        potionReloader = new PotionDrinkDataManager();
        armorReloader = new ArmorDataManager();
        blockReloader = new BlockDataManager();
        biomeReloader = new BiomeDataManager();
        entityReloader = new EntityTemperatureDataManager();
        fluidReloader = new FluidDataManager();
    }
}

