/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.stereowalker.survive.FoodUtils;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.client.events.TooltipEvents;
import com.stereowalker.survive.client.gui.screens.inventory.SaltBoxScreen;
import com.stereowalker.survive.client.particle.HygieneParticle;
import com.stereowalker.survive.core.TempDisplayMode;
import com.stereowalker.survive.core.particles.SParticleTypes;
import com.stereowalker.survive.hooks.ColdMenu;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.IRoastedEntity;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import com.stereowalker.survive.world.inventory.SMenuType;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.TemperatureRegulatorPlateItem;
import com.stereowalker.survive.world.item.alchemy.SPotions;
import com.stereowalker.survive.world.item.component.SDataComponents;
import com.stereowalker.survive.world.level.block.DryingCauldronBlock;
import com.stereowalker.survive.world.level.block.PlatedTemperatureRegulatorBlock;
import com.stereowalker.survive.world.level.block.SBlocks;
import com.stereowalker.survive.world.level.material.SFluids;
import com.stereowalker.unionlib.api.collectors.ColorOverrideCollector;
import com.stereowalker.unionlib.api.collectors.InsertCollector;
import com.stereowalker.unionlib.api.collectors.MenuCollector;
import com.stereowalker.unionlib.api.collectors.OverlayCollector;
import com.stereowalker.unionlib.api.collectors.ParticleCollector;
import com.stereowalker.unionlib.api.collectors.RenderLayerCollector;
import com.stereowalker.unionlib.api.gui.GuiRenderer;
import com.stereowalker.unionlib.client.gui.screens.config.MinecraftModConfigsScreen;
import com.stereowalker.unionlib.config.ConfigObject;
import com.stereowalker.unionlib.insert.ClientInserts;
import com.stereowalker.unionlib.insert.InsertHandler;
import com.stereowalker.unionlib.mod.ClientSegment;
import com.stereowalker.unionlib.util.LoaderHelper;
import com.stereowalker.unionlib.util.ScreenHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.util.math.Color;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.mutable.MutableInt;

public class SurviveClientSegment
extends ClientSegment {
    public static final ResourceLocation GUI_ICONS = VersionHelper.toLoc((String)"survive", (String)"textures/gui/icons.png");
    public static float maxContainerCoolness;

    public ResourceLocation getModIcon() {
        return VersionHelper.toLoc((String)"survive", (String)"textures/icon.png");
    }

    public Screen getConfigScreen(Minecraft mc, Screen previousScreen) {
        return new MinecraftModConfigsScreen(previousScreen, (Component)Component.translatable((String)"gui.survive.config.title"), new ConfigObject[]{Survive.TEMPERATURE_CONFIG, Survive.HYGIENE_CONFIG, Survive.STAMINA_CONFIG, Survive.THIRST_CONFIG, Survive.WELLBEING_CONFIG, Survive.FOOD_CONFIG, Survive.CONFIG});
    }

    public void setupParticles(ParticleCollector collector) {
        collector.addFactory((ParticleType)SParticleTypes.STINK, HygieneParticle.StinkFactory::new);
        collector.addFactory((ParticleType)SParticleTypes.CLEAN, HygieneParticle.CleanFactory::new);
    }

    public void setupRenderLayers(RenderLayerCollector collector) {
        RenderType frendertype = RenderType.translucent();
        collector.setFluidRenderLayer(frendertype, new Fluid[]{SFluids.PURIFIED_WATER, SFluids.FLOWING_PURIFIED_WATER});
        RenderType cutout = RenderType.cutout();
        collector.setBlockRenderLayer(cutout, new Block[]{SBlocks.REALISTIC_CAMPFIRE});
    }

    public void setupColorOverrides(ColorOverrideCollector collector) {
        collector.overrideBlocks((state, displayReader, blockPos, tintIndex) -> -12463112, new Block[]{SBlocks.PURIFIED_WATER, SBlocks.PURIFIED_WATER_CAULDRON});
        collector.overrideBlocks((state, displayReader, blockPos, tintIndex) -> {
            if (state.getValue(DryingCauldronBlock.FLUID) == DryingCauldronBlock.FluidToDry.POTASH) {
                return Color.parse((String)"0x483c35").brighter((float)((Integer)state.getValue((Property)DryingCauldronBlock.BOILING)).intValue() * 0.12f).toIntRGB();
            }
            if (state.getValue(DryingCauldronBlock.FLUID) == DryingCauldronBlock.FluidToDry.SEA_SALT) {
                return Color.fromIntRGB((int)BiomeColors.getAverageWaterColor((BlockAndTintGetter)displayReader, (BlockPos)blockPos)).brighter((float)((Integer)state.getValue((Property)DryingCauldronBlock.BOILING)).intValue() * 0.12f).toIntRGB();
            }
            return new Color(1.0f, 0.0f, 0.0f).brighter((float)((Integer)state.getValue((Property)DryingCauldronBlock.BOILING)).intValue() * 0.12f).toIntRGB();
        }, new Block[]{SBlocks.DRYING_CAULDRON});
        collector.overrideBlocks((state, displayReader, blockPos, tintIndex) -> PlatedTemperatureRegulatorBlock.getColor(state).toIntRGB(), new Block[]{SBlocks.PLATED_TEMPERATURE_REGULATOR});
        collector.overrideItems((stack, tintIndex) -> {
            PotionContents contents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            return tintIndex > 0 ? -1 : (contents.is(SPotions.PURIFIED_WATER.holder()) ? -12463112 : FastColor.ARGB32.opaque((int)contents.getColor()));
        }, new Item[]{Items.POTION, Items.SPLASH_POTION, Items.LINGERING_POTION});
        collector.overrideItems((stack, tintIndex) -> TemperatureRegulatorPlateItem.getColor(stack).toIntARGB(), new Item[]{SItems.LARGE_HEATING_PLATE, SItems.LARGE_COOLING_PLATE, SItems.MEDIUM_HEATING_PLATE, SItems.MEDIUM_COOLING_PLATE, SItems.SMALL_HEATING_PLATE, SItems.SMALL_COOLING_PLATE});
    }

    public void registerInserts(InsertCollector collector) {
        collector.addInsert((InsertHandler)ClientInserts.SCREEN_RENDER_FINISH, insert -> {
            ColdMenu cold;
            float progress;
            AbstractContainerScreen cont;
            AbstractContainerMenu patt1$temp;
            Screen patt0$temp = insert.screen();
            if (patt0$temp instanceof AbstractContainerScreen && (patt1$temp = (cont = (AbstractContainerScreen)patt0$temp).getMenu()) instanceof ColdMenu && (progress = (float)(cold = (ColdMenu)patt1$temp).coldness() / (float)cold.maxColdness()) > 0.0f) {
                int i = (cont.width - cont.imageWidth) / 2 + 9;
                int j = (cont.height - cont.imageHeight) / 2;
                if (cont instanceof ContainerScreen) {
                    ContainerScreen c = (ContainerScreen)cont;
                    j += c.containerRows * 18;
                }
                insert.guiRenderer().blit(VersionHelper.toLoc((String)"survive:textures/gui/coldness.png"), i, (j += 96) + 17, 0, 0, 158, 22);
                int i1 = 142;
                int j1 = Mth.ceil((float)(progress * 142.0f));
                insert.guiRenderer().blit(VersionHelper.toLoc((String)"survive:textures/gui/coldness.png"), i + 8, j + 17 + 4, 0, 30, j1, 10);
            }
        });
        collector.addInsert((InsertHandler)ClientInserts.ITEM_TOOLTIP, insert -> {
            if (insert.player() != null) {
                boolean showWeight = false;
                boolean showTemp = false;
                if (Survive.STAMINA_CONFIG.enabled && Survive.STAMINA_CONFIG.enable_weights || Survive.TEMPERATURE_CONFIG.enabled) {
                    for (EquipmentSlot type : EquipmentSlot.values()) {
                        if (!LoaderHelper.canEquip((LivingEntity)insert.player(), (ItemStack)insert.itemStack(), (EquipmentSlot)type) || type.getType() != EquipmentSlot.Type.ARMOR) continue;
                        showWeight = Survive.STAMINA_CONFIG.enabled && Survive.STAMINA_CONFIG.enable_weights;
                        showTemp = Survive.TEMPERATURE_CONFIG.enabled;
                        break;
                    }
                }
                if (showWeight || showTemp) {
                    TooltipEvents.accessoryTooltip(insert.player(), insert.itemStack(), insert.tooltips(), showWeight, showTemp);
                }
                FoodUtils.applyFoodStatusToTooltip(insert.player(), insert.itemStack(), insert.tooltips());
                if (SDataComponents.BIOME_SOURCE_D.hasData(insert.itemStack()) && ((Holder.Reference)((HolderLookup.RegistryLookup)insert.player().level().registryAccess().lookup(Registries.BIOME).get()).get(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)((ResourceLocation)SDataComponents.BIOME_SOURCE_D.getData(insert.itemStack())))).get()).is(BiomeTags.IS_OCEAN)) {
                    insert.tooltips().add(Component.translatable((String)"Sea Water"));
                }
            }
        });
    }

    public void setupGuiOverlays(OverlayCollector collector) {
        MutableInt rightHeight = new MutableInt(49);
        collector.register("reset", OverlayCollector.Order.END, (gui, renderer, width, height) -> rightHeight.setValue(49));
        collector.register("thirst_level", OverlayCollector.Order.END, (gui, renderer, width, height) -> {
            boolean isMounted = gui.minecraft.player.getVehicle() instanceof LivingEntity;
            if (Survive.THIRST_CONFIG.enabled && !isMounted && !gui.minecraft.options.hideGui && gui.minecraft.gameMode.canHurtPlayer()) {
                int left = width / 2 + 91;
                int top = height - rightHeight.intValue();
                SurviveClientSegment.renderThirst(gui, renderer, left, top, true);
                rightHeight.add(10);
            }
        });
        collector.register("stamina_level", OverlayCollector.Order.END, (gui, renderer, width, height) -> {
            boolean isMounted = gui.minecraft.player.getVehicle() instanceof LivingEntity;
            if (Survive.STAMINA_CONFIG.enabled && !isMounted && !gui.minecraft.options.hideGui && gui.minecraft.gameMode.canHurtPlayer()) {
                int left = width / 2 + 91;
                int top = height - rightHeight.intValue();
                SurviveClientSegment.renderEnergyBars(gui, renderer, rightHeight, left, top, true);
            }
        });
        collector.register("tired", OverlayCollector.Order.END, (gui, renderer, width, height) -> {
            if (Survive.CONFIG.tired_overlay && gui.minecraft.player.hasEffect(SMobEffects.TIREDNESS.holder())) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableDepthTest();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                SurviveClientSegment.renderTiredOverlay(gui, renderer);
            }
        });
        collector.register("heat_stroke", OverlayCollector.Order.END, (gui, renderer, width, height) -> {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            SurviveClientSegment.renderHeatStroke(gui, renderer);
        });
        collector.register("temperature", OverlayCollector.Order.END, (gui, renderer, width, height) -> {
            if (!gui.minecraft.options.hideGui && Survive.TEMPERATURE_CONFIG.enabled && !Survive.TEMPERATURE_CONFIG.tempDisplayMode.equals((Object)TempDisplayMode.HOTBAR)) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableDepthTest();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                SurviveClientSegment.renderTemperature(gui, ScreenHelper.ScreenOffset.TOP, gui.getCameraPlayer(), renderer, true);
            }
        });
        collector.register("nutrition", OverlayCollector.Order.END, (gui, renderer, width, height) -> {
            Player patt0$temp = gui.getCameraPlayer();
            if (patt0$temp instanceof IRealisticEntity) {
                IRealisticEntity real = (IRealisticEntity)patt0$temp;
                if (Survive.CONFIG.nutrition_enabled && (VersionHelper.VanillaComponents.FOOD.hasData(gui.getCameraPlayer().getMainHandItem()) || VersionHelper.VanillaComponents.FOOD.hasData(gui.getCameraPlayer().getOffhandItem()) || Survive.CONFIG.always_render_nut)) {
                    ScreenHelper.ScreenOffset position = Survive.CONFIG.nut_offset;
                    int x = ScreenHelper.getXOffset((ScreenHelper.ScreenOffset)position, (Minecraft)gui.minecraft) + Survive.CONFIG.nut_xLoc;
                    int y = ScreenHelper.getYOffset((ScreenHelper.ScreenOffset)position, (Minecraft)gui.minecraft) + Survive.CONFIG.nut_yLoc;
                    if (Survive.CONFIG.show_raw_nut_vals) {
                        renderer.drawString("Carbs = " + real.nutritionData().carbs().level(), x, y, ChatFormatting.GRAY.getColor().intValue(), false);
                        renderer.drawString("Protein = " + real.nutritionData().protein().level(), x, y + 10, ChatFormatting.GRAY.getColor().intValue(), false);
                        renderer.drawString("Fats = " + real.nutritionData().fat().level(), x, y + 20, ChatFormatting.GRAY.getColor().intValue(), false);
                    } else {
                        renderer.blit(GUI_ICONS, x + 7, y + 2, 194, 22, 62, 5);
                        renderer.blit(GUI_ICONS, x + 8, y + 3, 195, 28, Mth.floor((float)((float)real.nutritionData().carbs().level() / 50.0f)), 3);
                        renderer.blit(GUI_ICONS, x + 0, y + 0, 246, 11, 9, 9);
                        renderer.blit(GUI_ICONS, x + 7, y + 12, 194, 32, 62, 5);
                        renderer.blit(GUI_ICONS, x + 8, y + 13, 195, 38, Mth.floor((float)((float)real.nutritionData().protein().level() / 50.0f)), 3);
                        renderer.blit(GUI_ICONS, x + 0, y + 10, 226, 1, 9, 9);
                        renderer.blit(GUI_ICONS, x + 7, y + 22, 194, 42, 62, 5);
                        renderer.blit(GUI_ICONS, x + 8, y + 23, 195, 48, Mth.floor((float)((float)real.nutritionData().fat().level() / 50.0f)), 3);
                        renderer.blit(GUI_ICONS, x + 0, y + 20, 236, 11, 9, 9);
                    }
                }
            }
        });
    }

    public static void renderTemperature(Gui gui, ScreenHelper.ScreenOffset position, Player playerentity, GuiRenderer renderer, boolean forgeOverlay) {
        int x = ScreenHelper.getXOffset((ScreenHelper.ScreenOffset)position, (Minecraft)gui.minecraft) + Survive.TEMPERATURE_CONFIG.tempXLoc;
        int y = ScreenHelper.getYOffset((ScreenHelper.ScreenOffset)position, (Minecraft)gui.minecraft) + Survive.TEMPERATURE_CONFIG.tempYLoc;
        Minecraft.getInstance().getProfiler().push("temperature");
        double displayTemp = ((IRealisticEntity)playerentity).temperatureData().getDisplayTemperature();
        String s = ((IRealisticEntity)playerentity).temperatureData().getCelcius() + " \u00b0C";
        if (Minecraft.getInstance().gameMode.hasExperience()) {
            if (Survive.TEMPERATURE_CONFIG.tempDisplayMode.equals((Object)TempDisplayMode.HORIZONTAL_BAR)) {
                if (Survive.TEMPERATURE_CONFIG.tempEffects && displayTemp >= 1.0) {
                    renderer.blit(GUI_ICONS, x - 3, y - 3, 0, 79, 138, 11);
                } else if (Survive.TEMPERATURE_CONFIG.tempEffects && displayTemp <= -1.0) {
                    renderer.blit(GUI_ICONS, x - 3, y - 3, 0, 90, 138, 11);
                } else {
                    renderer.blit(GUI_ICONS, x, y, 3, 64, 132, 5);
                    renderer.blit(GUI_ICONS, x, y, 3, 69, 132, 5);
                }
                renderer.blit(GUI_ICONS, x + Mth.floor((double)(displayTemp * 44.0)) + 63 + (displayTemp > 0.0 ? 1 : 0), y, 1, 74, 4, 5);
            } else if (Survive.TEMPERATURE_CONFIG.tempDisplayMode.equals((Object)TempDisplayMode.VERTICAL_BAR)) {
                if (Survive.TEMPERATURE_CONFIG.tempEffects && displayTemp >= 1.0) {
                    renderer.blit(GUI_ICONS, x - 3, y - 3, 11, 101, 11, 138);
                } else if (Survive.TEMPERATURE_CONFIG.tempEffects && displayTemp <= -1.0) {
                    renderer.blit(GUI_ICONS, x - 3, y - 3, 0, 101, 11, 138);
                } else {
                    renderer.blit(GUI_ICONS, x, y, 32, 104, 5, 132);
                    renderer.blit(GUI_ICONS, x, y, 27, 104, 5, 132);
                }
                renderer.blit(GUI_ICONS, x, y - Mth.floor((double)(displayTemp * 44.0)) + 63 - (displayTemp > 0.0 ? 1 : 0), 22, 104, 5, 5);
            } else if (Survive.TEMPERATURE_CONFIG.tempDisplayMode.equals((Object)TempDisplayMode.NUMBERS)) {
                if (Survive.TEMPERATURE_CONFIG.displayTempInFahrenheit) {
                    s = ((IRealisticEntity)playerentity).temperatureData().getFahrenheit() + " \u00b0F";
                }
                if (displayTemp >= 1.0) {
                    renderer.drawString(s, x, y, ChatFormatting.GOLD.getColor().intValue(), false);
                } else if (displayTemp <= -1.0) {
                    renderer.drawString(s, x, y, ChatFormatting.BLUE.getColor().intValue(), false);
                } else {
                    renderer.drawString(s, x, y, ChatFormatting.GRAY.getColor().intValue(), false);
                }
            }
        }
        Minecraft.getInstance().getProfiler().pop();
    }

    public static void renderHeatStroke(Gui gui, GuiRenderer renderer) {
        if (((IRoastedEntity)gui.minecraft.player).getTicksRoasted() > 0) {
            gui.renderTextureOverlay(renderer.guiGraphics(), Survive.getInstance().location("textures/misc/burning_overlay.png"), ((IRoastedEntity)gui.minecraft.player).getPercentRoasted());
        }
    }

    public static void renderTiredOverlay(Gui gui, GuiRenderer graphics) {
        Minecraft.getInstance().getProfiler().push("tired");
        int amplifier = Minecraft.getInstance().player.getEffect(SMobEffects.TIREDNESS.holder()).getAmplifier() + 1;
        amplifier /= Survive.CONFIG.tiredTimeStacks / 5;
        amplifier = Mth.clamp((int)amplifier, (int)0, (int)4);
        gui.renderTextureOverlay(graphics.guiGraphics(), Survive.getInstance().location("textures/misc/sleep_overlay_" + amplifier + ".png"), 0.5f);
        Minecraft.getInstance().getProfiler().pop();
    }

    public static void renderThirst(Gui gui, GuiRenderer graphics, int j1, int k1, boolean forgeOverlay) {
        Player player = (Player)gui.minecraft.getCameraEntity();
        IRealisticEntity realisticPlayer = (IRealisticEntity)player;
        int waterL = realisticPlayer.waterData().getWaterLevel();
        gui.minecraft.getProfiler().push("thirst");
        for (int k6 = 0; k6 < 10; ++k6) {
            int i7 = k1;
            int k7 = 16;
            int i8 = 0;
            if (player.hasEffect(SMobEffects.THIRST.holder())) {
                k7 += 36;
                i8 = 13;
            }
            if (realisticPlayer.waterData().getHydrationLevel() <= 0.0f && gui.tickCount % (waterL * 3 + 1) == 0) {
                i7 = k1 + (gui.random.nextInt(3) - 1);
            }
            int k8 = j1 - k6 * 8 - 9;
            graphics.blit(GUI_ICONS, k8, i7, 16 + i8 * 9, 54, 9, 9);
            if (k6 * 2 + 1 < waterL) {
                graphics.blit(GUI_ICONS, k8, i7, k7 + 36, 54, 9, 9);
            }
            if (k6 * 2 + 1 != waterL) continue;
            graphics.blit(GUI_ICONS, k8, i7, k7 + 45, 54, 9, 9);
        }
        gui.minecraft.getProfiler().pop();
    }

    public static void renderEnergyBars(Gui gui, GuiRenderer graphics, MutableInt moveUp, int j1, int k1, boolean forgeOverlay) {
        int k7;
        int i7;
        int k6;
        int i;
        Random rand = new Random();
        Player player = (Player)gui.minecraft.getCameraEntity();
        IRealisticEntity real = (IRealisticEntity)player;
        float maxStamina = (float)player.getAttributeValue(SAttributes.MAX_STAMINA.holder());
        int l = real.staminaData().getLTS();
        if (real.staminaData().isDeadTired()) {
            l = real.staminaData().getReserveLevel();
        }
        Minecraft.getInstance().getProfiler().push("energy");
        if (!forgeOverlay) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_ICONS);
        }
        int[] i9 = new int[30];
        for (i = 0; i < 30; ++i) {
            i9[i] = k1 + (rand.nextInt(3) - 1);
        }
        for (i = 0; i < Mth.ceil((float)(maxStamina / 20.0f)); ++i) {
            for (k6 = 0; k6 < 10; ++k6) {
                i7 = k1;
                k7 = 16;
                int i8 = 0;
                if (real.staminaData().isDeadTired()) {
                    k7 += 36;
                    i8 = 13;
                }
                if ((float)real.staminaData().getLTS() <= 10.0f && gui.getGuiTicks() % (l * 3 + 1) == 0) {
                    i7 = i9[i];
                }
                int k8 = j1 - k6 * 8 - 9;
                if (k6 * 2 + 1 + 20 * i < Mth.floor((float)maxStamina) + 1) {
                    graphics.blit(GUI_ICONS, k8, i7, 16 + i8 * 9, 36, 9, 9);
                }
                if (k6 * 2 + 1 + 20 * i < l) {
                    graphics.blit(GUI_ICONS, k8, i7, k7 + 36, 36, 9, 9);
                }
                if (k6 * 2 + 1 + 20 * i != l) continue;
                graphics.blit(GUI_ICONS, k8, i7, k7 + 45, 36, 9, 9);
            }
            moveUp.add(10);
        }
        if (real.staminaData().isExerting() || real.staminaData().isShortOfBreath()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            l = real.staminaData().isShortOfBreath() ? real.staminaData().getSTSRecovery() : real.staminaData().getBurstStamina();
            for (i = 0; i < Mth.ceil((float)(maxStamina / 20.0f)); ++i) {
                for (k6 = 0; k6 < 10; ++k6) {
                    i7 = k1;
                    k7 = 16;
                    if (real.staminaData().isShortOfBreath()) {
                        k7 += 36;
                    }
                    if ((float)real.staminaData().getLTS() <= 10.0f && gui.getGuiTicks() % (l * 3 + 1) == 0) {
                        i7 = i9[i];
                    }
                    int k8 = j1 - k6 * 8 - 9;
                    if (k6 * 2 + 1 + 20 * i < l) {
                        graphics.blit(GUI_ICONS, k8, i7, k7 + 36, 27, 9, 9);
                    }
                    if (k6 * 2 + 1 + 20 * i != l) continue;
                    graphics.blit(GUI_ICONS, k8, i7, k7 + 45, 27, 9, 9);
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        Minecraft.getInstance().getProfiler().pop();
    }

    public void setupMenus(MenuCollector collector) {
        collector.addMenu(SMenuType.SALT_BOX, SaltBoxScreen::new);
    }
}

