/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class HygieneParticle
extends TextureSheetParticle {
    private final double stinkPosX;
    private final double stinkPosY;
    private final double stinkPosZ;

    protected HygieneParticle(ClientLevel world, double x, double y, double z, double xd, double yd, double zd, boolean colorParticle) {
        super(world, x, y, z);
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.x = x;
        this.y = y;
        this.z = z;
        this.stinkPosX = this.x;
        this.stinkPosY = this.y;
        this.stinkPosZ = this.z;
        this.quadSize = 0.1f * (this.random.nextFloat() * 0.2f + 0.5f);
        float f = this.random.nextFloat() * 0.6f + 0.4f;
        if (colorParticle) {
            this.rCol = f * 0.9f;
            this.gCol = f * 0.3f;
            this.bCol = f;
        }
        this.lifetime = (int)(Math.random() * 5.0) + 20;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void move(double x, double y, double z) {
        this.setBoundingBox(this.getBoundingBox().move(x, y, z));
        this.setLocationFromBoundingbox();
    }

    public float getQuadSize(float scaleFactor) {
        float f = ((float)this.age + scaleFactor) / (float)this.lifetime;
        f = 1.0f - f;
        f *= f;
        f = 1.0f - f;
        return this.quadSize * f;
    }

    public int getLightColor(float partialTick) {
        int i = super.getLightColor(partialTick);
        float f = (float)this.age / (float)this.lifetime;
        f *= f;
        f *= f;
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((k += (int)(f * 15.0f * 16.0f)) > 240) {
            k = 240;
        }
        return j | k << 16;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            float f = (float)this.age / (float)this.lifetime;
            float f1 = -f + f * f * 2.0f;
            float f2 = 1.0f - f1;
            this.x = this.stinkPosX + this.xd * (double)f2;
            this.y = this.stinkPosY + this.yd * (double)f2 + (double)(1.0f - f);
            this.z = this.stinkPosZ + this.zd * (double)f2;
        }
    }

    public static class StinkFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public StinkFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            HygieneParticle portalparticle = new HygieneParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, true);
            portalparticle.pickSprite(this.spriteSet);
            return portalparticle;
        }
    }

    public static class CleanFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public CleanFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            HygieneParticle portalparticle = new HygieneParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, false);
            portalparticle.pickSprite(this.spriteSet);
            return portalparticle;
        }
    }
}

