/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.core.cauldron;

import com.stereowalker.survive.world.item.CanteenItem;
import com.stereowalker.survive.world.item.HygieneItems;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.alchemy.SPotions;
import com.stereowalker.survive.world.item.component.SDataComponents;
import com.stereowalker.survive.world.level.block.SBlocks;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public interface SCauldronInteraction
extends CauldronInteraction {
    public static final CauldronInteraction.InteractionMap DRYING = CauldronInteraction.newInteractionMap((String)"potash");
    public static final CauldronInteraction.InteractionMap PURIFIED_WATER = CauldronInteraction.newInteractionMap((String)"purified_water");
    public static final CauldronInteraction FILL_PURIFIED_WATER = (p_175683_, p_175684_, p_175685_, p_175686_, p_175687_, p_175688_) -> CauldronInteraction.emptyBucket((Level)p_175684_, (BlockPos)p_175685_, (Player)p_175686_, (InteractionHand)p_175687_, (ItemStack)p_175688_, (BlockState)((BlockState)SBlocks.PURIFIED_WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3))), (SoundEvent)SoundEvents.BUCKET_EMPTY);

    public static void addSurviveDefaultInteractions(Map<Item, CauldronInteraction> p_175648_) {
        p_175648_.put(SItems.PURIFIED_WATER_BUCKET, FILL_PURIFIED_WATER);
    }

    public static void bootStrap() {
        CauldronInteraction.addDefaultInteractions((Map)DRYING.map());
        CauldronInteraction.addDefaultInteractions((Map)PURIFIED_WATER.map());
        SCauldronInteraction.addSurviveDefaultInteractions(DRYING.map());
        SCauldronInteraction.addSurviveDefaultInteractions(PURIFIED_WATER.map());
        SCauldronInteraction.addSurviveDefaultInteractions(EMPTY.map());
        SCauldronInteraction.addSurviveDefaultInteractions(LAVA.map());
        SCauldronInteraction.addSurviveDefaultInteractions(POWDER_SNOW.map());
        SCauldronInteraction.addSurviveDefaultInteractions(WATER.map());
        PURIFIED_WATER.map().put(Items.BUCKET, (p_175725_, p_175726_, p_175727_, p_175728_, p_175729_, p_175730_) -> CauldronInteraction.fillBucket((BlockState)p_175725_, (Level)p_175726_, (BlockPos)p_175727_, (Player)p_175728_, (InteractionHand)p_175729_, (ItemStack)p_175730_, (ItemStack)new ItemStack((ItemLike)SItems.PURIFIED_WATER_BUCKET), p_175660_ -> (Integer)p_175660_.getValue((Property)LayeredCauldronBlock.LEVEL) == 3, (SoundEvent)SoundEvents.BUCKET_FILL));
        SCauldronInteraction.fillEmptyCauldron(HygieneItems.POTASH_SOLUTION, new ItemStack((ItemLike)Items.GLASS_BOTTLE), SBlocks.DRYING_CAULDRON.defaultBlockState(), SoundEvents.BOTTLE_EMPTY);
        SCauldronInteraction.addToCauldron(DRYING.map(), HygieneItems.POTASH_SOLUTION, new ItemStack((ItemLike)Items.GLASS_BOTTLE), SoundEvents.BOTTLE_EMPTY);
        SCauldronInteraction.takeFromCauldron(DRYING.map(), Items.GLASS_BOTTLE, new ItemStack((ItemLike)HygieneItems.POTASH_SOLUTION), SoundEvents.BOTTLE_FILL);
        SCauldronInteraction.takeFromCauldron(WATER.map(), Items.BOWL, new ItemStack((ItemLike)SItems.WATER_BOWL), SoundEvents.BOTTLE_FILL);
        SCauldronInteraction.addToCauldron(WATER.map(), SItems.WATER_BOWL, new ItemStack((ItemLike)Items.BOWL), SoundEvents.BOTTLE_EMPTY);
        SCauldronInteraction.fillEmptyCauldron(SItems.WATER_BOWL, new ItemStack((ItemLike)Items.BOWL), Blocks.WATER_CAULDRON.defaultBlockState(), SoundEvents.BOTTLE_EMPTY);
        SCauldronInteraction.takeFromCauldron(PURIFIED_WATER.map(), Items.BOWL, new ItemStack((ItemLike)SItems.PURIFIED_WATER_BOWL), SoundEvents.BOTTLE_FILL);
        SCauldronInteraction.addToCauldron(PURIFIED_WATER.map(), SItems.PURIFIED_WATER_BOWL, new ItemStack((ItemLike)Items.BOWL), SoundEvents.BOTTLE_EMPTY);
        SCauldronInteraction.fillEmptyCauldron(SItems.PURIFIED_WATER_BOWL, new ItemStack((ItemLike)Items.BOWL), SBlocks.PURIFIED_WATER_CAULDRON.defaultBlockState(), SoundEvents.BOTTLE_EMPTY);
        SCauldronInteraction.takeFromCauldron(PURIFIED_WATER.map(), Items.GLASS_BOTTLE, PotionContents.createItemStack((Item)Items.POTION, (Holder)SPotions.PURIFIED_WATER.holder()), SoundEvents.BOTTLE_FILL);
        PURIFIED_WATER.map().put(Items.POTION, (p_175704_, p_175705_, p_175706_, p_175707_, p_175708_, p_175709_) -> {
            PotionContents potioncontents = (PotionContents)p_175709_.get(DataComponents.POTION_CONTENTS);
            if ((Integer)p_175704_.getValue((Property)LayeredCauldronBlock.LEVEL) != 3 && potioncontents.is(SPotions.PURIFIED_WATER.holder())) {
                if (!p_175705_.isClientSide) {
                    p_175707_.setItemInHand(p_175708_, ItemUtils.createFilledResult((ItemStack)p_175709_, (Player)p_175707_, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
                    p_175707_.awardStat(Stats.USE_CAULDRON);
                    p_175707_.awardStat(Stats.ITEM_USED.get((Object)p_175709_.getItem()));
                    p_175705_.setBlockAndUpdate(p_175706_, (BlockState)p_175704_.cycle((Property)LayeredCauldronBlock.LEVEL));
                    p_175705_.playSound((Player)null, p_175706_, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                    p_175705_.gameEvent((Entity)null, (Holder)GameEvent.FLUID_PLACE, p_175706_);
                }
                return ItemInteractionResult.sidedSuccess((boolean)p_175705_.isClientSide);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        });
        EMPTY.map().put(Items.POTION, (blockstate, level, pos, player, interactionHand, p_175737_) -> {
            PotionContents potioncontents = (PotionContents)p_175737_.get(DataComponents.POTION_CONTENTS);
            if (potioncontents == null || !potioncontents.is(Potions.WATER) || !potioncontents.is(SPotions.PURIFIED_WATER.holder())) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (!level.isClientSide) {
                Item item = p_175737_.getItem();
                player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)p_175737_, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                if (potioncontents.is(Potions.WATER)) {
                    level.setBlockAndUpdate(pos, Blocks.WATER_CAULDRON.defaultBlockState());
                } else {
                    level.setBlockAndUpdate(pos, SBlocks.PURIFIED_WATER_CAULDRON.defaultBlockState());
                }
                level.playSound((Player)null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent((Entity)null, (Holder)GameEvent.FLUID_PLACE, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        });
        WATER.map().put(SItems.CANTEEN, (blockstate, level, pos, player, interactionHand, p_175723_) -> {
            if (!level.isClientSide) {
                Item item = p_175723_.getItem();
                player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)p_175723_, (Player)player, (ItemStack)CanteenItem.addToCanteen(new ItemStack((ItemLike)SItems.FILLED_CANTEEN), (int)((Integer)blockstate.getValue((Property)LayeredCauldronBlock.LEVEL)), (Holder<Potion>)Potions.WATER)));
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                level.setBlockAndUpdate(pos, Blocks.CAULDRON.defaultBlockState());
                level.playSound((Player)null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent((Entity)null, (Holder)GameEvent.FLUID_PICKUP, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        });
        PURIFIED_WATER.map().put(SItems.CANTEEN, (blockstate, level, pos, player, interactionHand, p_175723_) -> {
            if (!level.isClientSide) {
                PotionContents potioncontents = (PotionContents)p_175723_.get(DataComponents.POTION_CONTENTS);
                Item item = p_175723_.getItem();
                player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)p_175723_, (Player)player, (ItemStack)CanteenItem.addToCanteen(new ItemStack((ItemLike)SItems.FILLED_CANTEEN), (int)((Integer)blockstate.getValue((Property)LayeredCauldronBlock.LEVEL)), (Holder<Potion>)SPotions.PURIFIED_WATER.holder())));
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                level.setBlockAndUpdate(pos, Blocks.CAULDRON.defaultBlockState());
                level.playSound((Player)null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent((Entity)null, (Holder)GameEvent.FLUID_PICKUP, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        });
        EMPTY.map().put(SItems.FILLED_CANTEEN, (blockstate, level, pos, player, interactionHand, p_175737_) -> {
            PotionContents potioncontents = (PotionContents)p_175737_.get(DataComponents.POTION_CONTENTS);
            if (potioncontents == null || !potioncontents.is(Potions.WATER) || !potioncontents.is(SPotions.PURIFIED_WATER.holder())) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (!level.isClientSide) {
                CanteenItem item = (CanteenItem)p_175737_.getItem();
                int drinksLeft = (Integer)SDataComponents.DRINKS_LEFT_D.getData(p_175737_);
                if (drinksLeft > 3) {
                    player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)p_175737_, (Player)player, (ItemStack)CanteenItem.addToCanteen(p_175737_.copy(), drinksLeft - 3, potioncontents)));
                } else {
                    player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)p_175737_, (Player)player, (ItemStack)new ItemStack((ItemLike)SItems.CANTEEN)));
                }
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                if (potioncontents.is(Potions.WATER)) {
                    level.setBlockAndUpdate(pos, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(Math.min(drinksLeft, 3))));
                } else {
                    level.setBlockAndUpdate(pos, (BlockState)SBlocks.PURIFIED_WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(Math.min(drinksLeft, 3))));
                }
                level.playSound((Player)null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent((Entity)null, (Holder)GameEvent.FLUID_PLACE, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        });
    }

    public static void takeFromCauldron(Map<Item, CauldronInteraction> interaction, Item requiredItem, ItemStack output, SoundEvent fillSound) {
        interaction.put(requiredItem, (blockstate, level, pos, player, interactionHand, p_175723_) -> {
            if (!level.isClientSide) {
                Item item = p_175723_.getItem();
                player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)p_175723_, (Player)player, (ItemStack)output.copy()));
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                LayeredCauldronBlock.lowerFillLevel((BlockState)blockstate, (Level)level, (BlockPos)pos);
                level.playSound((Player)null, pos, fillSound, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent((Entity)null, (Holder)GameEvent.FLUID_PICKUP, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        });
    }

    public static void addToCauldron(Map<Item, CauldronInteraction> interaction, Item requiredItem, ItemStack output, SoundEvent emptySound) {
        interaction.put(requiredItem, (blockstate, level, pos, player, interactionHand, p_175709_) -> {
            if ((Integer)blockstate.getValue((Property)LayeredCauldronBlock.LEVEL) != 3) {
                if (!level.isClientSide) {
                    player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)p_175709_, (Player)player, (ItemStack)output.copy()));
                    player.awardStat(Stats.USE_CAULDRON);
                    player.awardStat(Stats.ITEM_USED.get((Object)p_175709_.getItem()));
                    level.setBlockAndUpdate(pos, (BlockState)blockstate.cycle((Property)LayeredCauldronBlock.LEVEL));
                    level.playSound((Player)null, pos, emptySound, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.gameEvent((Entity)null, (Holder)GameEvent.FLUID_PLACE, pos);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        });
    }

    public static void fillEmptyCauldron(Item requiredItem, ItemStack output, BlockState resultingCauldron, SoundEvent emptySound) {
        EMPTY.map().put(requiredItem, (blockstate, level, pos, player, interactionHand, p_175737_) -> {
            if (!level.isClientSide) {
                Item item = p_175737_.getItem();
                player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)p_175737_, (Player)player, (ItemStack)output.copy()));
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                level.setBlockAndUpdate(pos, resultingCauldron);
                level.playSound((Player)null, pos, emptySound, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent((Entity)null, (Holder)GameEvent.FLUID_PLACE, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        });
    }
}

