/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.events;

import com.stereowalker.survive.json.BiomeJsonHolder;
import com.stereowalker.survive.json.FluidJsonHolder;
import com.stereowalker.survive.network.protocol.game.ServerboundInteractWithWaterPacket;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.unionlib.api.insert.InsertResultCanceller;
import com.stereowalker.unionlib.util.RegistryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ThirstEvents {
    public static void interactWithWaterSourceBlock(Player player, Level level, InteractionHand hand, BlockHitResult result, InsertResultCanceller<InteractionResult> cancel) {
        ItemStack stack = player.getItemInHand(hand);
        BlockPos pos = result.getBlockPos();
        BlockHitResult raytraceresult = ThirstEvents.getPlayerPOVHitResult(level, player, ClipContext.Fluid.SOURCE_ONLY);
        BlockPos sourcepos = raytraceresult.getBlockPos();
        BlockState state = level.getBlockState(result.getBlockPos());
        Fluid fluid = level.getFluidState(sourcepos).getType();
        BlockState stateUnder = level.getBlockState(pos.below());
        if (level.isClientSide && ServerboundInteractWithWaterPacket.isValidStack(stack)) {
            int i;
            if (DataMaps.Client.fluid.containsKey((Object)RegistryHelper.fluids().getKey((Object)fluid))) {
                BiomeJsonHolder biomeData;
                FluidJsonHolder fluidHolder = (FluidJsonHolder)DataMaps.Client.fluid.get((Object)RegistryHelper.fluids().getKey((Object)fluid));
                float thirstChance = fluidHolder.getThirstChance();
                if (DataMaps.Client.biome.containsKey((Object)((ResourceKey)level.getBiome(sourcepos).unwrapKey().get()).location()) && (biomeData = (BiomeJsonHolder)DataMaps.Client.biome.get((Object)((ResourceKey)level.getBiome(sourcepos).unwrapKey().get()).location())).getThirstChance() >= 0.0f) {
                    thirstChance = biomeData.getThirstChance();
                }
                cancel.cancel((Object)InteractionResult.SUCCESS);
                new ServerboundInteractWithWaterPacket(sourcepos, thirstChance, fluidHolder.getThirstAmount(), fluidHolder.getHydrationAmount(), hand).send();
            }
            if (state.getBlock() == Blocks.WATER_CAULDRON && (i = ((Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL)).intValue()) > 0) {
                cancel.cancel((Object)InteractionResult.SUCCESS);
                if (stateUnder.getBlock() == Blocks.CAMPFIRE && ((Boolean)stateUnder.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
                    new ServerboundInteractWithWaterPacket(pos, 0.0f, 4.0, hand).send();
                } else {
                    new ServerboundInteractWithWaterPacket(pos, 0.5f, 4.0, hand).send();
                }
            }
        }
    }

    public static void interactWithWaterSourceBlock(Player player, Level level, InteractionHand hand, InsertResultCanceller<InteractionResultHolder<ItemStack>> cancel) {
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult raytraceresult = ThirstEvents.getPlayerPOVHitResult(level, player, ClipContext.Fluid.SOURCE_ONLY);
        BlockPos sourcepos = raytraceresult.getBlockPos();
        Fluid fluid = level.getFluidState(sourcepos).getType();
        BlockPos blockpos = raytraceresult.getBlockPos();
        if (level.isClientSide && ServerboundInteractWithWaterPacket.isValidStack(stack) && DataMaps.Client.fluid.containsKey((Object)RegistryHelper.fluids().getKey((Object)fluid))) {
            BiomeJsonHolder biomeData;
            FluidJsonHolder fluidHolder = (FluidJsonHolder)DataMaps.Client.fluid.get((Object)RegistryHelper.fluids().getKey((Object)fluid));
            float thirstChance = fluidHolder.getThirstChance();
            if (DataMaps.Client.biome.containsKey((Object)((ResourceKey)level.getBiome(blockpos).unwrapKey().get()).location()) && (biomeData = (BiomeJsonHolder)DataMaps.Client.biome.get((Object)((ResourceKey)level.getBiome(blockpos).unwrapKey().get()).location())).getThirstChance() >= 0.0f) {
                thirstChance = biomeData.getThirstChance();
            }
            cancel.cancel((Object)InteractionResultHolder.success((Object)stack));
            new ServerboundInteractWithWaterPacket(blockpos, thirstChance, fluidHolder.getThirstAmount(), fluidHolder.getHydrationAmount(), hand).send();
        }
    }

    protected static BlockHitResult getPlayerPOVHitResult(Level pLevel, Player pPlayer, ClipContext.Fluid pFluidMode) {
        Vec3 vec3 = pPlayer.getEyePosition();
        Vec3 vec31 = vec3.add(pPlayer.calculateViewVector(pPlayer.getXRot(), pPlayer.getYRot()).scale(pPlayer.blockInteractionRange()));
        return pLevel.clip(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, pFluidMode, (Entity)pPlayer));
    }
}

