/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.mixins;

import com.stereowalker.survive.config.ServerConfig;
import com.stereowalker.survive.world.level.block.SBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CampfireBlock.class})
public abstract class CampfireBlockMixin
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    protected CampfireBlockMixin(BlockBehaviour.Properties p_49224_) {
        super(p_49224_);
    }

    @Inject(method={"onRemove"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBlockEntity(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/entity/BlockEntity;")})
    public void onUnpurifyWater(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving, CallbackInfo info) {
        if (!pLevel.isClientSide && ServerConfig.purifiedCauldronRevert && pLevel.getBlockState(pPos.above()).getBlock() == SBlocks.PURIFIED_WATER_CAULDRON) {
            BlockState old = pLevel.getBlockState(pPos.above());
            pLevel.setBlockAndUpdate(pPos.above(), (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)((Integer)old.getValue((Property)LayeredCauldronBlock.LEVEL))));
        }
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pLevel.isClientSide && pLevel.getBlockState(pPos.above()).getBlock() == Blocks.WATER_CAULDRON) {
            BlockState old = pLevel.getBlockState(pPos.above());
            pLevel.setBlockAndUpdate(pPos.above(), (BlockState)SBlocks.PURIFIED_WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)((Integer)old.getValue((Property)LayeredCauldronBlock.LEVEL))));
        }
        super.onPlace(pState, pLevel, pPos, pOldState, pIsMoving);
    }
}

