/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.google.common.collect.ImmutableList;
import com.stereowalker.survive.json.BiomeJsonHolder;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class TemperatureUtil {
    private static final PerlinSimplexNoise TEMPERATURE_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(1234L)), (List)ImmutableList.of((Object)0));

    public static double firstHeat(Player player) {
        return 37.0 + player.getAttributeValue(SAttributes.HEAT_RESISTANCE.holder()) * 1.0;
    }

    public static double secondHeat(Player player) {
        return 37.0 + (player.getAttributeValue(SAttributes.HEAT_RESISTANCE.holder()) * 1.0 + 0.3333333333333333);
    }

    public static double maxHeat(Player player) {
        return 37.0 + (player.getAttributeValue(SAttributes.HEAT_RESISTANCE.holder()) * 1.0 + 0.4444444444444444);
    }

    public static double firstCold(Player player) {
        return 37.0 - player.getAttributeValue(SAttributes.COLD_RESISTANCE.holder()) * 1.0;
    }

    public static double secondCold(Player player) {
        return 37.0 - (player.getAttributeValue(SAttributes.COLD_RESISTANCE.holder()) * 1.0 + 0.3333333333333333);
    }

    public static double maxCold(Player player) {
        return 37.0 - (player.getAttributeValue(SAttributes.COLD_RESISTANCE.holder()) * 1.0 + 0.4444444444444444);
    }

    public static float getTemperature(Holder<Biome> biome, BlockPos pos) {
        float f = (float)(TEMPERATURE_NOISE.getValue((double)((float)pos.getX() / 8.0f), (double)((float)pos.getZ() / 8.0f), false) * 4.0);
        float modifier = 1.0f;
        float t = ((Biome)biome.value()).getBaseTemperature();
        if (biome.unwrapKey().isPresent() && DataMaps.Server.biome.containsKey(((ResourceKey)biome.unwrapKey().get()).location())) {
            BiomeJsonHolder temperatureData = DataMaps.Server.biome.get(((ResourceKey)biome.unwrapKey().get()).location());
            t = (temperatureData.getTemperature() + 2.0f) / 2.0f;
            if ((float)pos.getY() > 64.0f) {
                modifier = ((Float)temperatureData.getAltitudeLevelModifier().getFirst()).floatValue();
            } else if ((float)pos.getY() < 64.0f) {
                modifier = ((Float)temperatureData.getAltitudeLevelModifier().getSecond()).floatValue();
            }
        }
        return t - modifier * ((f + (float)pos.getY() - 64.0f) * 0.05f / 3.75f);
    }
}

