/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.needs.Water;
import com.stereowalker.survive.config.ServerConfig;
import com.stereowalker.survive.damagesource.SDamageSources;
import com.stereowalker.survive.damagesource.SDamageTypes;
import com.stereowalker.survive.json.BiomeJsonHolder;
import com.stereowalker.survive.needs.CustomFoodData;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.SurviveData;
import com.stereowalker.survive.needs.TemperatureUtil;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.survive.world.item.component.SDataComponents;
import com.stereowalker.unionlib.util.RegistryHelper;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.GameRules;

public class WaterData
extends SurviveData
implements Water {
    private int tempDropTicks = 0;
    private int waterLevel = 20;
    private float waterHydrationLevel = 4.0f;
    private float waterExhaustionLevel;
    private int waterTimer;
    private int prevWaterLevel = 20;
    private int uncleanConsumption = 0;
    private int uncleanStacks = 0;

    public void drink(int waterLevelIn, float waterHydrationModifier, int uncleanStack, boolean isUnclean) {
        int capacity = 20;
        if (ServerConfig.stomachCapacity == CustomFoodData.StomachCapacity.DOUBLED) {
            capacity = 40;
        } else if (ServerConfig.stomachCapacity == CustomFoodData.StomachCapacity.LIMITED && this.waterLevel < 20) {
            capacity = 40;
        } else if (ServerConfig.stomachCapacity == CustomFoodData.StomachCapacity.LIMITED && this.waterLevel >= 20) {
            capacity = this.waterLevel;
        }
        this.waterLevel = Math.min(waterLevelIn + this.waterLevel, capacity);
        if (this.waterHydrationLevel >= waterHydrationModifier) {
            this.waterHydrationLevel = waterHydrationModifier;
        } else if (this.waterHydrationLevel < waterHydrationModifier) {
            this.waterHydrationLevel = Mth.clamp((float)(this.waterHydrationLevel + waterHydrationModifier * Survive.THIRST_CONFIG.hydration_restoration), (float)1.0f, (float)waterHydrationModifier);
        }
        if (isUnclean) {
            this.uncleanStacks += uncleanStack;
            ++this.uncleanConsumption;
        }
    }

    public void drink(float thirstConsumption, int uncleanStack, boolean isUnclean) {
        this.waterExhaustionLevel += thirstConsumption;
        if (isUnclean) {
            this.uncleanStacks += uncleanStack;
            ++this.uncleanConsumption;
        }
    }

    public void drink(Item pItem, ItemStack pStack, LivingEntity entity) {
        if (entity != null && entity instanceof ServerPlayer) {
            ResourceLocation biomeSource;
            ServerPlayer player = (ServerPlayer)entity;
            PotionContents potion = (PotionContents)pStack.get(DataComponents.POTION_CONTENTS);
            float biomef = -1.0f;
            int stacks = 0;
            if (SDataComponents.BIOME_SOURCE_D.hasData(pStack) && DataMaps.Server.biome.containsKey(biomeSource = (ResourceLocation)SDataComponents.BIOME_SOURCE_D.getData(pStack))) {
                BiomeJsonHolder biomeData = DataMaps.Server.biome.get(biomeSource);
                biomef = biomeData.getThirstChance();
                stacks = biomeData.getUnwellIntensity();
            }
            if (potion != null && DataMaps.Server.potionDrink.containsKey(RegistryHelper.potions().getKey((Object)((Potion)((Holder)potion.potion().get()).value())))) {
                drinkData = DataMaps.Server.potionDrink.get(RegistryHelper.potions().getKey((Object)((Potion)((Holder)potion.potion().get()).value())));
                if (drinkData.getThirstConsumption() > 0.0f) {
                    this.drink(drinkData.getThirstConsumption(), stacks, WaterData.applyThirst(entity, biomef != -1.0f ? biomef : drinkData.getThirstChance()));
                } else {
                    this.drink(drinkData.getThirstAmount(), drinkData.getHydrationAmount(), stacks, WaterData.applyThirst(entity, biomef != -1.0f ? biomef : drinkData.getThirstChance()));
                }
                if (drinkData.isHeated()) {
                    entity.addEffect(new MobEffectInstance(SMobEffects.HEATED.holder(), 600));
                }
                if (drinkData.isChilled()) {
                    entity.addEffect(new MobEffectInstance(SMobEffects.CHILLED.holder(), 600));
                }
                if (drinkData.isEnergizing()) {
                    entity.addEffect(new MobEffectInstance(SMobEffects.ENERGIZED.holder(), 6000));
                }
            } else if (DataMaps.Server.consummableItem.containsKey(RegistryHelper.items().getKey((Object)pItem))) {
                drinkData = DataMaps.Server.consummableItem.get(RegistryHelper.items().getKey((Object)pItem));
                if (drinkData.getThirstConsumption() > 0.0f) {
                    this.drink(drinkData.getThirstConsumption(), stacks, WaterData.applyThirst(entity, biomef != -1.0f ? biomef : drinkData.getThirstChance()));
                } else {
                    this.drink(drinkData.getThirstAmount(), drinkData.getHydrationAmount(), stacks, WaterData.applyThirst(entity, biomef != -1.0f ? biomef : drinkData.getThirstChance()));
                }
                if (drinkData.isHeated()) {
                    entity.addEffect(new MobEffectInstance(SMobEffects.HEATED.holder(), 600));
                }
                if (drinkData.isChilled()) {
                    entity.addEffect(new MobEffectInstance(SMobEffects.CHILLED.holder(), 600));
                }
                if (drinkData.isEnergizing()) {
                    entity.addEffect(new MobEffectInstance(SMobEffects.ENERGIZED.holder(), 6000));
                }
            }
        }
    }

    @Override
    public void tick(Player player) {
        this.waterHydrationLevel = Mth.clamp((float)this.waterHydrationLevel, (float)1.0f, (float)4.0f);
        if (Survive.THIRST_CONFIG.idle_thirst_tick_rate > -1 && player.tickCount % Survive.THIRST_CONFIG.idle_thirst_tick_rate == Survive.THIRST_CONFIG.idle_thirst_tick_rate - 1) {
            this.addExhaustion(player, Survive.THIRST_CONFIG.idle_thirst_exhaustion);
        }
        Difficulty difficulty = player.level().getDifficulty();
        this.prevWaterLevel = this.waterLevel;
        if (ServerConfig.stomachCapacity != CustomFoodData.StomachCapacity.VANILLA) {
            int amplifier = -1;
            int duration = 210;
            if (this.waterLevel > 36) {
                amplifier = 4;
            } else if (this.waterLevel > 32) {
                amplifier = 3;
            } else if (this.waterLevel > 28) {
                amplifier = 2;
            } else if (this.waterLevel > 24) {
                amplifier = 1;
            } else if (this.waterLevel > 20) {
                amplifier = 0;
            }
            MobEffectInstance upsetStomach = player.getEffect(SMobEffects.UPSET_STOMACH.holder());
            if (!(player.isSpectator() || player.isCreative() || amplifier <= 0 || upsetStomach != null && upsetStomach.getDuration() > 210 && upsetStomach.getAmplifier() >= amplifier)) {
                player.addEffect(new MobEffectInstance(SMobEffects.UPSET_STOMACH.holder(), duration, amplifier));
            }
        }
        if (this.waterExhaustionLevel > this.waterHydrationLevel) {
            this.waterExhaustionLevel -= this.waterHydrationLevel;
            if (this.waterHydrationLevel > 2.8f) {
                this.waterHydrationLevel = Math.max(this.waterHydrationLevel - 0.1f, 2.8f);
            }
            if (difficulty != Difficulty.PEACEFUL) {
                this.waterLevel = Math.max(this.waterLevel - 1, 0);
            }
        }
        boolean flag = player.level().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION);
        if (this.waterLevel >= 40) {
            ++this.waterTimer;
            if (this.waterTimer >= 10) {
                if (player.getHealth() > 10.0f || difficulty == Difficulty.HARD || player.getHealth() > 1.0f && difficulty == Difficulty.NORMAL) {
                    player.hurt(SDamageSources.source(player.level().registryAccess(), SDamageTypes.OVERHYDRATE), 1.0f);
                }
                this.waterTimer = 0;
            }
        } else if (flag && this.waterLevel >= 16 && this.tempDropTicks < 10 && ((IRealisticEntity)player).temperatureData().getTemperatureLevel() > (37.0 + TemperatureUtil.firstHeat(player)) / 2.0) {
            ++this.waterTimer;
            if (this.waterTimer >= 80) {
                ++this.tempDropTicks;
                this.addExhaustion(6.0f);
                this.waterTimer = 0;
            }
        } else if (this.waterLevel <= 0) {
            ++this.waterTimer;
            if (this.waterTimer >= 80) {
                if (player.getHealth() > 10.0f || difficulty == Difficulty.HARD || player.getHealth() > 1.0f && difficulty == Difficulty.NORMAL) {
                    player.hurt(SDamageSources.source(player.level().registryAccess(), SDamageTypes.DEHYDRATE), 1.0f);
                }
                this.waterTimer = 0;
            }
        } else {
            this.waterTimer = 0;
        }
        if (Survive.WELLBEING_CONFIG.enabled && this.uncleanConsumption >= 3) {
            ((IRealisticEntity)player).wellbeingData().setTimer(2400, 6000, Mth.ceil((float)((float)this.uncleanStacks / (float)this.uncleanConsumption)), "drinking unpurified water");
            this.uncleanConsumption = 0;
        }
    }

    public void applyTempDrop(Player player) {
        --this.tempDropTicks;
    }

    public boolean shouldTempDrop() {
        return this.tempDropTicks > 0;
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.contains("waterLevel", 99)) {
            this.tempDropTicks = compound.getInt("tempDropTicks");
            this.waterLevel = compound.getInt("waterLevel");
            this.waterTimer = compound.getInt("waterTickTimer");
            this.waterHydrationLevel = compound.getFloat("waterHydrationLevel");
            this.waterExhaustionLevel = compound.getFloat("waterExhaustionLevel");
            this.uncleanConsumption = compound.getInt("uncleanComsumption");
            this.uncleanStacks = compound.getInt("uncleanStacks");
        }
    }

    @Override
    public void write(CompoundTag compound, boolean reducedData) {
        compound.putInt("tempDropTicks", this.tempDropTicks);
        compound.putInt("waterLevel", this.waterLevel);
        compound.putInt("waterTickTimer", this.waterTimer);
        compound.putFloat("waterHydrationLevel", this.waterHydrationLevel);
        compound.putFloat("waterExhaustionLevel", this.waterExhaustionLevel);
        compound.putInt("uncleanComsumption", this.uncleanConsumption);
        compound.putInt("uncleanStacks", this.uncleanStacks);
    }

    @Override
    public int getWaterLevel() {
        return this.waterLevel;
    }

    public boolean needWater() {
        switch (ServerConfig.stomachCapacity) {
            case VANILLA: {
                return this.waterLevel < 20;
            }
            case LIMITED: {
                return this.waterLevel < 20;
            }
            case DOUBLED: {
                return this.waterLevel < 40;
            }
        }
        return this.waterLevel < 20;
    }

    private void addExhaustion(float exhaustion) {
        this.waterExhaustionLevel = Math.min(this.waterExhaustionLevel + exhaustion, 40.0f);
    }

    public void addExhaustion(Player player, float exhaustion) {
        if (!player.getAbilities().invulnerable && !player.level().isClientSide) {
            this.addExhaustion(exhaustion);
        }
    }

    public float getHydrationLevel() {
        return this.waterHydrationLevel;
    }

    public void setWaterLevel(int waterLevelIn) {
        this.waterLevel = waterLevelIn;
    }

    public void setWaterHydrationLevel(float waterHydrationLevelIn) {
        this.waterHydrationLevel = waterHydrationLevelIn;
    }

    @Override
    public void save(LivingEntity player) {
    }

    @Override
    public boolean shouldTick() {
        return Survive.THIRST_CONFIG.enabled;
    }

    public static boolean applyThirst(LivingEntity entity, float probabiltiy) {
        Random rand;
        if (probabiltiy > 0.0f && (rand = new Random()).nextFloat() < probabiltiy) {
            entity.addEffect(new MobEffectInstance(SMobEffects.THIRST.holder(), 600));
            return true;
        }
        return false;
    }
}

