/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.network.protocol.game;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.core.WeightHandler;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.unionlib.network.protocol.game.ServerboundUnionPacket;
import com.stereowalker.unionlib.util.VersionHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class ServerboundArmorStaminaPacket
extends ServerboundUnionPacket {
    public static ResourceLocation id = VersionHelper.toLoc((String)"survive", (String)"serverbound_interact_with_water");

    public ServerboundArmorStaminaPacket() {
        super(Survive.getInstance().channel);
    }

    public ServerboundArmorStaminaPacket(RegistryFriendlyByteBuf packetBuffer) {
        super(packetBuffer, Survive.getInstance().channel);
    }

    public void encode(FriendlyByteBuf packetBuffer) {
    }

    public boolean handleOnServer(ServerPlayer sender) {
        if (Survive.STAMINA_CONFIG.enabled) {
            float moveMul = WeightHandler.getTotalArmorWeight((LivingEntity)sender) / Survive.STAMINA_CONFIG.max_weight * 0.1f;
            if (WeightHandler.getTotalArmorWeight((LivingEntity)sender) / Survive.STAMINA_CONFIG.max_weight > 1.0f) {
                moveMul += WeightHandler.getTotalArmorWeight((LivingEntity)sender) / Survive.STAMINA_CONFIG.max_weight - 1.0f;
            }
            if (moveMul > 0.0f) {
                ((IRealisticEntity)sender).addStaminaExhaustion(moveMul * 2.0f, "Armor weight", false);
            }
        }
        return true;
    }

    public ResourceLocation id() {
        return id;
    }
}

