/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.WaterData;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;

public class NeedsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"needs").requires(p_137384_ -> p_137384_.hasPermission(2))).then(Commands.literal((String)"restore").then(Commands.argument((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"cleansing").executes(e -> NeedsCommand.restore((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.CLEANSING, EntityArgument.getPlayers((CommandContext)e, (String)"targets"))))).then(Commands.literal((String)"hunger").executes(e -> NeedsCommand.restore((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.HUNGER, EntityArgument.getPlayers((CommandContext)e, (String)"targets"))))).then(Commands.literal((String)"hydration").executes(e -> NeedsCommand.restore((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.HYDRATION, EntityArgument.getPlayers((CommandContext)e, (String)"targets"))))).then(Commands.literal((String)"saturation").executes(e -> NeedsCommand.restore((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.SATURATION, EntityArgument.getPlayers((CommandContext)e, (String)"targets"))))).then(Commands.literal((String)"sleep").executes(e -> NeedsCommand.restore((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.SLEEP, EntityArgument.getPlayers((CommandContext)e, (String)"targets"))))).then(Commands.literal((String)"stamina").executes(e -> NeedsCommand.restore((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.STAMINA, EntityArgument.getPlayers((CommandContext)e, (String)"targets"))))).then(Commands.literal((String)"thirst").executes(e -> NeedsCommand.restore((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.THIRST, EntityArgument.getPlayers((CommandContext)e, (String)"targets")))))))).then(Commands.literal((String)"deplete").then(Commands.argument((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"cleansing").executes(e -> NeedsCommand.deplete((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.CLEANSING, EntityArgument.getPlayers((CommandContext)e, (String)"targets"))))).then(Commands.literal((String)"hunger").executes(e -> NeedsCommand.deplete((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.HUNGER, EntityArgument.getPlayers((CommandContext)e, (String)"targets"))))).then(Commands.literal((String)"hydration").executes(e -> NeedsCommand.deplete((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.HYDRATION, EntityArgument.getPlayers((CommandContext)e, (String)"targets"))))).then(Commands.literal((String)"saturation").executes(e -> NeedsCommand.deplete((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.SATURATION, EntityArgument.getPlayers((CommandContext)e, (String)"targets"))))).then(Commands.literal((String)"sleep").executes(e -> NeedsCommand.deplete((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.SLEEP, EntityArgument.getPlayers((CommandContext)e, (String)"targets"))))).then(Commands.literal((String)"stamina").executes(e -> NeedsCommand.deplete((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.STAMINA, EntityArgument.getPlayers((CommandContext)e, (String)"targets"))))).then(Commands.literal((String)"thirst").executes(e -> NeedsCommand.deplete((CommandSourceStack)e.getSource(), FloatArgumentType.getFloat((CommandContext)e, (String)"amount"), NeedType.THIRST, EntityArgument.getPlayers((CommandContext)e, (String)"targets")))))))).then(Commands.literal((String)"query").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"cleansing").executes(e -> NeedsCommand.query((CommandSourceStack)e.getSource(), NeedType.CLEANSING, EntityArgument.getPlayer((CommandContext)e, (String)"targets"))))).then(Commands.literal((String)"hunger").executes(e -> NeedsCommand.query((CommandSourceStack)e.getSource(), NeedType.HUNGER, EntityArgument.getPlayer((CommandContext)e, (String)"targets"))))).then(Commands.literal((String)"hydration").executes(e -> NeedsCommand.query((CommandSourceStack)e.getSource(), NeedType.HYDRATION, EntityArgument.getPlayer((CommandContext)e, (String)"targets"))))).then(Commands.literal((String)"saturation").executes(e -> NeedsCommand.query((CommandSourceStack)e.getSource(), NeedType.SATURATION, EntityArgument.getPlayer((CommandContext)e, (String)"targets"))))).then(Commands.literal((String)"sleep").executes(e -> NeedsCommand.query((CommandSourceStack)e.getSource(), NeedType.SLEEP, EntityArgument.getPlayer((CommandContext)e, (String)"targets"))))).then(Commands.literal((String)"stamina").executes(e -> NeedsCommand.query((CommandSourceStack)e.getSource(), NeedType.STAMINA, EntityArgument.getPlayer((CommandContext)e, (String)"targets"))))).then(Commands.literal((String)"thirst").executes(e -> NeedsCommand.query((CommandSourceStack)e.getSource(), NeedType.THIRST, EntityArgument.getPlayer((CommandContext)e, (String)"targets")))))));
    }

    private static int restore(CommandSourceStack source, float amount, NeedType type, Collection<ServerPlayer> pTargets) throws CommandSyntaxException {
        for (ServerPlayer player : pTargets) {
            IRealisticEntity realisticPlayer = (IRealisticEntity)player;
            WaterData waterData = realisticPlayer.waterData();
            switch (type.ordinal()) {
                case 0: {
                    realisticPlayer.staminaData().relax(Mth.floor((float)amount), player.getAttributeValue(SAttributes.MAX_STAMINA.holder()));
                    break;
                }
                case 1: {
                    player.getFoodData().setFoodLevel(Mth.floor((float)amount));
                    break;
                }
                case 2: {
                    player.getFoodData().setSaturation(amount);
                    break;
                }
                case 3: {
                    realisticPlayer.hygieneData().clean(Mth.floor((float)amount), true);
                    break;
                }
                case 4: {
                    realisticPlayer.sleepData().addAwakeTime(player, -Mth.floor((float)amount));
                    break;
                }
                case 5: {
                    waterData.drink(Mth.floor((float)amount), waterData.getHydrationLevel(), 0, false);
                    break;
                }
                case 6: {
                    waterData.drink(0, waterData.getHydrationLevel() + amount, 0, false);
                }
            }
        }
        if (pTargets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)("commands.needs.restore." + type.getSerializedName() + ".success.single"), (Object[])new Object[]{Float.valueOf(amount), ((ServerPlayer)pTargets.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)("commands.needs.restore." + type.getSerializedName() + ".success.multiple"), (Object[])new Object[]{Float.valueOf(amount), pTargets.size()}), true);
        }
        return pTargets.size();
    }

    private static int deplete(CommandSourceStack source, float amount, NeedType type, Collection<ServerPlayer> pTargets) throws CommandSyntaxException {
        for (ServerPlayer player : pTargets) {
            IRealisticEntity realisticPlayer = (IRealisticEntity)player;
            WaterData waterData = realisticPlayer.waterData();
            switch (type.ordinal()) {
                case 0: {
                    realisticPlayer.staminaData().setEnergyLevel(realisticPlayer.staminaData().getLTS() - Mth.floor((float)amount));
                    break;
                }
                case 1: {
                    player.getFoodData().setFoodLevel(player.getFoodData().getFoodLevel() - Mth.floor((float)amount));
                    break;
                }
                case 2: {
                    player.getFoodData().setSaturation(player.getFoodData().getSaturationLevel() - amount);
                    break;
                }
                case 3: {
                    realisticPlayer.hygieneData().dirty(Mth.floor((float)amount));
                    break;
                }
                case 4: {
                    realisticPlayer.sleepData().addAwakeTime(player, Mth.floor((float)amount));
                    break;
                }
                case 5: {
                    waterData.setWaterLevel(waterData.getWaterLevel() - Mth.floor((float)amount));
                    break;
                }
                case 6: {
                    waterData.setWaterHydrationLevel(waterData.getHydrationLevel() - amount);
                }
            }
        }
        if (pTargets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)("commands.needs.deplete." + type.getSerializedName() + ".success.single"), (Object[])new Object[]{Float.valueOf(amount), ((ServerPlayer)pTargets.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)("commands.needs.deplete." + type.getSerializedName() + ".success.multiple"), (Object[])new Object[]{Float.valueOf(amount), pTargets.size()}), true);
        }
        return pTargets.size();
    }

    private static int query(CommandSourceStack source, NeedType type, ServerPlayer pTarget) throws CommandSyntaxException {
        IRealisticEntity realisticPlayer = (IRealisticEntity)pTarget;
        float result = 0.0f;
        switch (type.ordinal()) {
            case 0: {
                result = realisticPlayer.staminaData().getLTS();
                break;
            }
            case 1: {
                result = pTarget.getFoodData().getFoodLevel();
                break;
            }
            case 2: {
                result = pTarget.getFoodData().getSaturationLevel();
                break;
            }
            case 3: {
                result = realisticPlayer.hygieneData().getUncleanLevel();
                break;
            }
            case 4: {
                result = realisticPlayer.sleepData().getAwakeTimer();
                break;
            }
            case 5: {
                result = realisticPlayer.waterData().getWaterLevel();
                break;
            }
            case 6: {
                result = realisticPlayer.waterData().getHydrationLevel();
            }
        }
        float r = result;
        source.sendSuccess(() -> Component.translatable((String)("commands.needs.query." + type.getSerializedName()), (Object[])new Object[]{pTarget.getDisplayName(), Float.valueOf(r)}), true);
        return Mth.floor((float)result);
    }

    static enum NeedType implements StringRepresentable
    {
        STAMINA("stamina"),
        HUNGER("hunger"),
        SATURATION("saturation"),
        CLEANSING("cleansing"),
        SLEEP("sleep"),
        THIRST("thirst"),
        HYDRATION("hydration");

        String name;

        private NeedType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

