/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.effect;

import com.stereowalker.survive.damagesource.SDamageSources;
import com.stereowalker.survive.damagesource.SDamageTypes;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.world.effect.UnwellMobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class HyperthermiaMobEffect
extends UnwellMobEffect {
    public HyperthermiaMobEffect(MobEffectCategory effectType, int liquidColorIn) {
        super(effectType, liquidColorIn);
    }

    public boolean applyEffectTick(LivingEntity living, int amplifier) {
        if (living instanceof Player) {
            if (living.getHealth() > living.getMaxHealth() / 3.5f) {
                living.hurt(SDamageSources.source(living.level().registryAccess(), SDamageTypes.HYPERTHERMIA), 0.8f);
            }
            if ((double)((IRealisticEntity)living).staminaData().getLTS() > (double)((IRealisticEntity)living).staminaData().getLTS() * 0.3) {
                ((IRealisticEntity)living).addStaminaExhaustion(1.0f * (float)(amplifier + 1), "Hyperthermia effect", false);
            }
        }
        return true;
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int k = 160 >> amplifier;
        if (k > 0) {
            return duration % k == 0;
        }
        return true;
    }
}

