/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.level.block;

import com.stereowalker.survive.core.cauldron.SCauldronInteraction;
import com.stereowalker.survive.damagesource.SDamageSources;
import com.stereowalker.survive.damagesource.SDamageTypes;
import com.stereowalker.survive.world.level.block.SaltBoxBlock;
import com.stereowalker.survive.world.level.block.entity.DryingCauldronBlockEntity;
import com.stereowalker.survive.world.level.block.entity.SBlockEntityType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class DryingCauldronBlock
extends LayeredCauldronBlock
implements EntityBlock {
    public static final IntegerProperty BOILING = IntegerProperty.create((String)"boiling", (int)0, (int)10);
    public static final EnumProperty<FluidToDry> FLUID = EnumProperty.create((String)"fluid", FluidToDry.class);

    public DryingCauldronBlock(BlockBehaviour.Properties properties) {
        super(Biome.Precipitation.NONE, SCauldronInteraction.DRYING, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(1))).setValue((Property)BOILING, (Comparable)Integer.valueOf(0))).setValue(FLUID, (Comparable)((Object)FluidToDry.SEA_SALT)));
    }

    protected void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        int boiling = (Integer)pState.getValue((Property)BOILING);
        if (boiling > 0 && this.isEntityInsideContent(pState, pPos, pEntity)) {
            pEntity.hurt(SDamageSources.source(pLevel.registryAccess(), SDamageTypes.BOIL), (float)boiling / 5.0f);
        }
        super.entityInside(pState, pLevel, pPos, pEntity);
    }

    protected int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        return (Integer)pState.getValue((Property)LEVEL);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LEVEL, FLUID, BOILING});
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (!pLevel.isClientSide && DryingCauldronBlockEntity.setResult(pLevel, pStack, pPos, pPlayer, pHand)) {
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.isClientSide ? null : SaltBoxBlock.createTickerHelperExposed(pBlockEntityType, SBlockEntityType.DRYING_CAULDRON, (level, pos, state, blockentity) -> blockentity.tick((ServerLevel)pLevel, state));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DryingCauldronBlockEntity(pos, state);
    }

    public void animateTick(BlockState pState, Level level, BlockPos pPos, RandomSource random) {
        int boil = (Integer)pState.getValue((Property)BOILING);
        double x = (double)pPos.getX() + 0.5;
        double y = (double)pPos.getY() + this.getContentHeight(pState);
        double z = (double)pPos.getZ() + 0.5;
        if (boil <= 0 || random.nextDouble() < 0.1) {
            // empty if block
        }
        if (random.nextDouble() < 0.5) {
            for (int i = 0; i < boil; ++i) {
                double xOff = random.nextDouble() * (double)0.9f - (double)0.45f;
                double zOff = random.nextDouble() * (double)0.9f - (double)0.45f;
                if (boil % 2 == 0) {
                    level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, x + xOff, y, z + zOff, 0.0, 0.0, 0.0);
                    continue;
                }
                level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, x + xOff, y, z + zOff, 0.0, random.nextDouble() * (double)0.1f, 0.0);
            }
        }
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public static enum FluidToDry implements StringRepresentable
    {
        SEA_SALT,
        POTASH;


        public String getSerializedName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "sea_salt";
                case 1 -> "potash";
            };
        }
    }
}

