/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.level.block;

import com.stereowalker.survive.world.level.block.entity.RealisticCampfireBlockEntity;
import com.stereowalker.survive.world.level.block.entity.SBlockEntityType;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RealisticCampfireBlock
extends CampfireBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final IntegerProperty HEAT = IntegerProperty.create((String)"heat", (int)0, (int)4);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape VIRTUAL_FENCE_POST = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final int SMOKE_DISTANCE = 5;

    public RealisticCampfireBlock(boolean p_51236_, int p_51237_, BlockBehaviour.Properties p_51238_) {
        super(p_51236_, p_51237_, p_51238_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)HEAT, (Comparable)Integer.valueOf(0))).setValue((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof RealisticCampfireBlockEntity) {
            RealisticCampfireBlockEntity campfireblockentity = (RealisticCampfireBlockEntity)blockEntity;
            ItemStack itemstack = pPlayer.getItemInHand(pHand);
            Optional<RecipeHolder<CampfireCookingRecipe>> optional = campfireblockentity.getCookableRecipe(itemstack);
            if (optional.isPresent()) {
                if (!pLevel.isClientSide && campfireblockentity.placeFood((Entity)pPlayer, itemstack, ((CampfireCookingRecipe)optional.get().value()).getCookingTime())) {
                    pPlayer.awardStat(Stats.INTERACT_WITH_CAMPFIRE);
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.CONSUME;
            }
            if (AbstractFurnaceBlockEntity.isFuel((ItemStack)pStack)) {
                if (!pLevel.isClientSide && campfireblockentity.placeFuel((LivingEntity)pPlayer, itemstack)) {
                    pPlayer.awardStat(Stats.INTERACT_WITH_CAMPFIRE);
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.CONSUME;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if ((Integer)pState.getValue((Property)HEAT) > 0 && pEntity instanceof LivingEntity) {
            pEntity.hurt(pLevel.damageSources().inFire(), (float)((Integer)pState.getValue((Property)HEAT)).intValue() * 0.25f);
        }
        super.entityInside(pState, pLevel, pPos, pEntity);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos blockpos;
        Level levelaccessor = pContext.getLevel();
        boolean flag = levelaccessor.getFluidState(blockpos = pContext.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).setValue((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(this.isSmokeSource(levelaccessor.getBlockState(blockpos.below()))))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)HEAT, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection());
    }

    protected BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return pFacing == Direction.DOWN ? (BlockState)pState.setValue((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(this.isSmokeSource(pFacingState))) : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    private boolean isSmokeSource(BlockState pState) {
        return pState.is(Blocks.HAY_BLOCK);
    }

    public static void dowse(@Nullable Entity pEntity, LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        BlockEntity blockentity;
        if (pLevel.isClientSide()) {
            for (int i = 0; i < 20; ++i) {
                RealisticCampfireBlock.makeParticles((Level)pLevel, pPos, (Boolean)pState.getValue((Property)SIGNAL_FIRE), true);
            }
        }
        if ((blockentity = pLevel.getBlockEntity(pPos)) instanceof RealisticCampfireBlockEntity) {
            ((RealisticCampfireBlockEntity)blockentity).dowse();
        }
        pLevel.gameEvent(pEntity, (Holder)GameEvent.BLOCK_CHANGE, pPos);
    }

    public boolean placeLiquid(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        if (!((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && pFluidState.getType() == Fluids.WATER) {
            boolean flag;
            boolean bl = flag = (Integer)pState.getValue((Property)HEAT) > 0;
            if (flag) {
                if (!pLevel.isClientSide()) {
                    pLevel.playSound(null, pPos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                RealisticCampfireBlock.dowse(null, pLevel, pPos, pState);
            }
            pLevel.setBlock(pPos, (BlockState)((BlockState)((BlockState)pState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)HEAT, (Comparable)Integer.valueOf(0)), 3);
            pLevel.scheduleTick(pPos, pFluidState.getType(), pFluidState.getType().getTickDelay((LevelReader)pLevel));
            return true;
        }
        return false;
    }

    protected void onProjectileHit(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        BlockPos blockpos = pHit.getBlockPos();
        if (!pLevel.isClientSide && pProjectile.isOnFire() && pProjectile.mayInteract(pLevel, blockpos) && !((Boolean)pState.getValue((Property)LIT)).booleanValue() && !((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.setBlock(blockpos, (BlockState)pState.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 11);
        }
    }

    public static void makeParticles(Level pLevel, BlockPos pPos, boolean pIsSignalFire, boolean pSpawnExtraSmoke) {
        RandomSource randomsource = pLevel.getRandom();
        SimpleParticleType simpleparticletype = pIsSignalFire ? ParticleTypes.CAMPFIRE_SIGNAL_SMOKE : ParticleTypes.CAMPFIRE_COSY_SMOKE;
        pLevel.addAlwaysVisibleParticle((ParticleOptions)simpleparticletype, true, (double)pPos.getX() + 0.5 + randomsource.nextDouble() / 3.0 * (double)(randomsource.nextBoolean() ? 1 : -1), (double)pPos.getY() + randomsource.nextDouble() + randomsource.nextDouble(), (double)pPos.getZ() + 0.5 + randomsource.nextDouble() / 3.0 * (double)(randomsource.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (pSpawnExtraSmoke) {
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pPos.getX() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), (double)pPos.getY() + 0.4, (double)pPos.getZ() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LIT, SIGNAL_FIRE, WATERLOGGED, FACING, HEAT});
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new RealisticCampfireBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide) {
            return (Integer)pState.getValue((Property)HEAT) > 0 ? RealisticCampfireBlock.createTickerHelper(pBlockEntityType, SBlockEntityType.REALISIC_CAMPFIRE, RealisticCampfireBlockEntity::particleTick) : null;
        }
        return (Integer)pState.getValue((Property)HEAT) > 0 ? RealisticCampfireBlock.createTickerHelper(pBlockEntityType, SBlockEntityType.REALISIC_CAMPFIRE, RealisticCampfireBlockEntity::cookTick) : RealisticCampfireBlock.createTickerHelper(pBlockEntityType, SBlockEntityType.REALISIC_CAMPFIRE, RealisticCampfireBlockEntity::cooldownTick);
    }
}

