/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.temperature.conditions;

import com.google.gson.JsonObject;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeCondition;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;

public class UnderwaterCondition
extends TemperatureChangeCondition<Instance> {
    @Override
    public Instance createInstance(JsonObject object) {
        float temperatureIn = 0.0f;
        int depthIn = 0;
        String operationIn = "";
        if (object.has("temperature") && object.get("temperature").isJsonPrimitive()) {
            temperatureIn = object.get("temperature").getAsFloat();
        }
        if (object.has("depth") && object.get("depth").isJsonPrimitive()) {
            depthIn = object.get("depth").getAsInt();
        }
        if (object.has("operation") && object.get("operation").isJsonPrimitive()) {
            operationIn = object.get("operation").getAsString();
        }
        return new Instance(temperatureIn, depthIn, operationIn);
    }

    @Override
    public Instance createInstance(CompoundTag nbt) {
        float temperatureIn = nbt.getFloat("temperature");
        int depthIn = nbt.getInt("depth");
        String operationIn = nbt.getString("operation");
        return new Instance(temperatureIn, depthIn, operationIn);
    }

    static class Instance
    extends TemperatureChangeInstance {
        private int depth;
        private String operation;

        public Instance(float temperatureIn, int depthIn, String operationIn) {
            super(temperatureIn);
            this.depth = depthIn;
            this.operation = operationIn;
        }

        @Override
        public boolean shouldChangeTemperature(Player player) {
            boolean flag = true;
            int i = 0;
            while (flag) {
                if (player.level().getFluidState(player.blockPosition().above(i)).is(FluidTags.WATER)) {
                    ++i;
                    continue;
                }
                flag = false;
            }
            if (player.isInWater()) {
                if (this.depth > 0) {
                    if (this.operation.equals("y_=")) {
                        return player.getY() == (double)this.depth;
                    }
                    if (this.operation.equals("y_>=")) {
                        return player.getY() >= (double)this.depth;
                    }
                    if (this.operation.equals("y_<=")) {
                        return player.getY() <= (double)this.depth;
                    }
                    if (this.operation.equals("y_>")) {
                        return player.getY() > (double)this.depth;
                    }
                    if (this.operation.equals("y_<")) {
                        return player.getY() < (double)this.depth;
                    }
                    if (this.operation.equals("water_=")) {
                        return i == this.depth;
                    }
                    if (this.operation.equals("water_>=")) {
                        return i >= this.depth;
                    }
                    if (this.operation.equals("water_<=")) {
                        return i <= this.depth;
                    }
                    if (this.operation.equals("water_>")) {
                        return i > this.depth;
                    }
                    if (this.operation.equals("water_<")) {
                        return i < this.depth;
                    }
                    return i <= this.depth;
                }
                return true;
            }
            return false;
        }

        @Override
        public CompoundTag serialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.putFloat("temperature", this.getTemperature());
            nbt.putInt("depth", this.depth);
            nbt.putString("operation", this.operation);
            return nbt;
        }

        @Override
        public Component getAdditionalContext() {
            return Component.translatable((String)"temperature_context.underwater");
        }
    }
}

