/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.json.FoodJsonHolder;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.item.component.SDataComponents;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class FoodUtils {
    public static void giveLifespanToFood(class_2371<class_1799> items, long gametime) {
        if (Survive.FOOD_CONFIG.enabled) {
            items.forEach(stack -> {
                long lifespan;
                if (VersionHelper.VanillaComponents.FOOD.hasData(stack) && !SDataComponents.FOOD_STATUS_D.hasData(stack) && DataMaps.Server.consummableItem.containsKey(RegistryHelper.items().method_10221((Object)stack.method_7909())) && (lifespan = (long)DataMaps.Server.consummableItem.get(RegistryHelper.items().method_10221((Object)stack.method_7909())).lifespan()) > 0L) {
                    long shaveAMinuteOff = gametime - gametime % 1200L;
                    SDataComponents.FOOD_STATUS_D.setData(stack, (Object)new FoodStatus(shaveAMinuteOff, lifespan, 0.0));
                }
            });
        } else {
            items.forEach(stack -> {
                if (SDataComponents.FOOD_STATUS_D.hasData(stack)) {
                    SDataComponents.FOOD_STATUS_D.removeData(stack);
                }
            });
        }
    }

    public static void giveLifespanToFood(class_1799 stack, long gametime) {
        if (Survive.FOOD_CONFIG.enabled) {
            long lifespan;
            if (VersionHelper.VanillaComponents.FOOD.hasData(stack) && !SDataComponents.FOOD_STATUS_D.hasData(stack) && DataMaps.Server.consummableItem.containsKey(RegistryHelper.items().method_10221((Object)stack.method_7909())) && (lifespan = (long)DataMaps.Server.consummableItem.get(RegistryHelper.items().method_10221((Object)stack.method_7909())).lifespan()) > 0L) {
                long shaveAMinuteOff = gametime - gametime % 1200L;
                SDataComponents.FOOD_STATUS_D.setData(stack, (Object)new FoodStatus(shaveAMinuteOff, lifespan, 0.0));
            }
        } else if (SDataComponents.FOOD_STATUS_D.hasData(stack)) {
            SDataComponents.FOOD_STATUS_D.removeData(stack);
        }
    }

    public static void applyFoodStatusToTooltip(class_1657 player, class_1799 stack, List<class_2561> tip) {
        if (VersionHelper.VanillaComponents.FOOD.hasData(stack)) {
            if (Survive.FOOD_CONFIG.enabled) {
                State state = FoodUtils.foodStatus(stack, player.method_37908());
                if (state == State.Fresh) {
                    tip.add((class_2561)class_2561.method_43470((String)"Fresh").method_10862(class_2583.field_24360.method_36139(0x88FF88)));
                } else if (state == State.Good) {
                    tip.add((class_2561)class_2561.method_43470((String)"Good").method_10862(class_2583.field_24360.method_36139(65280)));
                } else if (state == State.Spoiling) {
                    tip.add((class_2561)class_2561.method_43470((String)"Spoiling").method_10862(class_2583.field_24360.method_36139(0xAAFF00)));
                } else if (state == State.Spoiled) {
                    tip.add((class_2561)class_2561.method_43470((String)"Spoiled").method_10862(class_2583.field_24360.method_36139(0x88AA00)));
                } else {
                    tip.add((class_2561)class_2561.method_43470((String)"Okay").method_10862(class_2583.field_24360.method_36139(0xFFFF00)));
                }
            }
            if (SDataComponents.FOOD_STATUS_D.hasData(stack)) {
                FoodStatus fd = (FoodStatus)SDataComponents.FOOD_STATUS_D.getData(stack);
                if (fd.saltDose > 500.0) {
                    tip.add((class_2561)class_2561.method_43470((String)"Deathly Salted").method_10862(class_2583.field_24360));
                } else if (fd.saltDose > 250.0) {
                    tip.add((class_2561)class_2561.method_43470((String)"Heavily Salted").method_10862(class_2583.field_24360));
                } else if (fd.saltDose > 125.0) {
                    tip.add((class_2561)class_2561.method_43470((String)"Salted").method_10862(class_2583.field_24360));
                } else if (fd.saltDose > 10.0) {
                    tip.add((class_2561)class_2561.method_43470((String)"Lightly Salted").method_10862(class_2583.field_24360));
                }
            }
        }
    }

    public static State foodStatus(class_1799 stack, class_1937 level) {
        if (SDataComponents.FOOD_STATUS_D.hasData(stack) && (level.field_9236 ? DataMaps.Client.consummableItem : DataMaps.Server.consummableItem).containsKey(RegistryHelper.items().method_10221((Object)stack.method_7909())) && Survive.FOOD_CONFIG.enabled) {
            FoodJsonHolder food = (FoodJsonHolder)(level.field_9236 ? DataMaps.Client.consummableItem : DataMaps.Server.consummableItem).get(RegistryHelper.items().method_10221((Object)stack.method_7909()));
            long timeTill = ((FoodStatus)SDataComponents.FOOD_STATUS_D.getData(stack)).expireTime() - level.method_8510();
            long timeSince = (long)food.lifespan() - timeTill;
            if (timeTill < 0L) {
                return State.Spoiled;
            }
            if (timeTill <= (long)(food.ticksFresh() * 2)) {
                return State.Spoiling;
            }
            if (timeSince <= (long)food.ticksFresh()) {
                return State.Fresh;
            }
            if (timeSince <= (long)(food.ticksFresh() * 3)) {
                return State.Good;
            }
        }
        return State.Okay;
    }

    public record FoodStatus(long creationTime, double lifespan, double saltDose) {
        public static final Codec<FoodStatus> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.LONG.fieldOf("creation_time").forGetter(FoodStatus::creationTime), (App)Codec.DOUBLE.fieldOf("lifespan").forGetter(FoodStatus::lifespan), (App)Codec.DOUBLE.fieldOf("salt_dose").forGetter(FoodStatus::saltDose)).apply((Applicative)builder, FoodStatus::new));
        public static final class_9139<class_9129, FoodStatus> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_48551, FoodStatus::creationTime, (class_9139)class_9135.field_48553, FoodStatus::lifespan, (class_9139)class_9135.field_48553, FoodStatus::saltDose, FoodStatus::new);

        public long expireTime() {
            return this.creationTime + (long)Math.floor(this.lifespan);
        }

        public FoodStatus extendTime(float extension) {
            return new FoodStatus(this.creationTime, this.lifespan + (double)extension, this.saltDose);
        }

        public FoodStatus increaseSalt(float extension) {
            return new FoodStatus(this.creationTime, this.lifespan, this.saltDose + (double)extension);
        }
    }

    public static enum State {
        Fresh,
        Good,
        Okay,
        Spoiling,
        Spoiled;

    }

    public static enum Saltiness {
        None,
        Light,
        Average,
        Heavy,
        Extreme;

    }
}

