/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.stereowalker.survive.FoodUtils;
import com.stereowalker.survive.SurviveClientSegment;
import com.stereowalker.survive.api.needs.PlayerNeeds;
import com.stereowalker.survive.api.needs.Stamina;
import com.stereowalker.survive.api.needs.Temperature;
import com.stereowalker.survive.api.needs.Water;
import com.stereowalker.survive.compat.OriginsCompat;
import com.stereowalker.survive.config.Config;
import com.stereowalker.survive.config.FoodConfig;
import com.stereowalker.survive.config.HygieneConfig;
import com.stereowalker.survive.config.ServerConfig;
import com.stereowalker.survive.config.StaminaConfig;
import com.stereowalker.survive.config.TemperatureConfig;
import com.stereowalker.survive.config.ThirstConfig;
import com.stereowalker.survive.config.WellbeingConfig;
import com.stereowalker.survive.core.cauldron.SCauldronInteraction;
import com.stereowalker.survive.core.particles.SParticleTypes;
import com.stereowalker.survive.core.registries.SurviveRegistries;
import com.stereowalker.survive.events.SleepEvents;
import com.stereowalker.survive.events.SurviveEvents;
import com.stereowalker.survive.events.TempEvents;
import com.stereowalker.survive.events.ThirstEvents;
import com.stereowalker.survive.hooks.ColdStorage;
import com.stereowalker.survive.json.ArmorJsonHolder;
import com.stereowalker.survive.json.BiomeJsonHolder;
import com.stereowalker.survive.json.BlockTemperatureJsonHolder;
import com.stereowalker.survive.json.EntityTemperatureJsonHolder;
import com.stereowalker.survive.json.FoodJsonHolder;
import com.stereowalker.survive.json.PotionJsonHolder;
import com.stereowalker.survive.json.property.BlockPropertyHandlerImpl;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.StaminaData;
import com.stereowalker.survive.network.protocol.game.ClientboundDataTransferPacket;
import com.stereowalker.survive.network.protocol.game.ClientboundDrinkSoundPacket;
import com.stereowalker.survive.network.protocol.game.ClientboundSurvivalStatsPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundArmorStaminaPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundInteractWithWaterPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundPlayerStatusBookPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundRelaxPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundStaminaExhaustionPacket;
import com.stereowalker.survive.network.protocol.game.ServerboundThirstMovementPacket;
import com.stereowalker.survive.resource.ArmorDataManager;
import com.stereowalker.survive.resource.BiomeDataManager;
import com.stereowalker.survive.resource.BlockDataManager;
import com.stereowalker.survive.resource.EntityTemperatureDataManager;
import com.stereowalker.survive.resource.FluidDataManager;
import com.stereowalker.survive.resource.ItemConsummableDataManager;
import com.stereowalker.survive.resource.PotionDrinkDataManager;
import com.stereowalker.survive.server.commands.NeedsCommand;
import com.stereowalker.survive.tags.FluidSTags;
import com.stereowalker.survive.tags.ItemSTags;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.effect.SMobEffects;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import com.stereowalker.survive.world.inventory.SMenuType;
import com.stereowalker.survive.world.item.CanteenItem;
import com.stereowalker.survive.world.item.HygieneItems;
import com.stereowalker.survive.world.item.SArmorMaterials;
import com.stereowalker.survive.world.item.SCreativeModeTab;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.alchemy.SPotions;
import com.stereowalker.survive.world.item.component.SDataComponents;
import com.stereowalker.survive.world.item.crafting.SRecipeSerializer;
import com.stereowalker.survive.world.item.enchantment.SEnchantmentEffectComponents;
import com.stereowalker.survive.world.level.CGameRules;
import com.stereowalker.survive.world.level.block.SBlocks;
import com.stereowalker.survive.world.level.block.entity.SBlockEntityType;
import com.stereowalker.survive.world.level.material.SFluids;
import com.stereowalker.survive.world.level.storage.loot.predicates.SLootItemConditions;
import com.stereowalker.survive.world.seasons.Seasons;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeConditions;
import com.stereowalker.unionlib.api.collectors.BrewingRecipeCollector;
import com.stereowalker.unionlib.api.collectors.CommandCollector;
import com.stereowalker.unionlib.api.collectors.ConfigCollector;
import com.stereowalker.unionlib.api.collectors.DefaultAttributeModifier;
import com.stereowalker.unionlib.api.collectors.FluidPropertyCollector;
import com.stereowalker.unionlib.api.collectors.InsertCollector;
import com.stereowalker.unionlib.api.collectors.PackCollector;
import com.stereowalker.unionlib.api.collectors.PacketCollector;
import com.stereowalker.unionlib.api.collectors.ReloadListeners;
import com.stereowalker.unionlib.api.creativetabs.CreativeTabBuilder;
import com.stereowalker.unionlib.api.creativetabs.CreativeTabPopulator;
import com.stereowalker.unionlib.api.insert.InsertResultCanceller;
import com.stereowalker.unionlib.api.insert.InsertSetter;
import com.stereowalker.unionlib.api.registries.RegistryCollector;
import com.stereowalker.unionlib.config.ConfigObject;
import com.stereowalker.unionlib.insert.InsertHandler;
import com.stereowalker.unionlib.insert.Inserts;
import com.stereowalker.unionlib.insert.ServerInserts;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.PacketHolder;
import com.stereowalker.unionlib.mod.ServerSegment;
import com.stereowalker.unionlib.resource.ReloadListener;
import com.stereowalker.unionlib.util.LoaderHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.level.material.FluidProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_1163;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2595;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_79;
import net.minecraft.class_7924;
import net.minecraft.class_83;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import org.apache.commons.lang3.tuple.Pair;

public class Survive
extends MinecraftMod
implements PacketHolder {
    public static final float DEFAULT_TEMP = 37.0f;
    public static final int PURIFIED_WATER_COLOR = -12463112;
    public static Map<class_6880<class_1842>, List<class_3611>> POTION_FLUID_MAP;
    public static final String MOD_ID = "survive";
    public static final Config CONFIG;
    public static final FoodConfig FOOD_CONFIG;
    public static final StaminaConfig STAMINA_CONFIG;
    public static final HygieneConfig HYGIENE_CONFIG;
    public static final TemperatureConfig TEMPERATURE_CONFIG;
    public static final ThirstConfig THIRST_CONFIG;
    public static final WellbeingConfig WELLBEING_CONFIG;
    public static final Codec<Long> NON_NEGATIVE_LONG;
    public static boolean isPrimalWinterLoaded;
    public static final ItemConsummableDataManager consummableReloader;
    public static final PotionDrinkDataManager potionReloader;
    public static final ArmorDataManager armorReloader;
    public static final BlockDataManager blockReloader;
    public static final BiomeDataManager biomeReloader;
    public static final EntityTemperatureDataManager entityReloader;
    public static final FluidDataManager fluidReloader;
    private static Survive instance;

    public static void sendPacket(class_9302 tag) {
        new ServerboundPlayerStatusBookPacket(tag, !Survive.TEMPERATURE_CONFIG.displayTempInFahrenheit, class_1074.method_4662((String)"book.patient.sleep", (Object[])new Object[]{"%1$s"}), class_1074.method_4662((String)"book.patient.temperature", (Object[])new Object[]{"%1$s"})).send();
    }

    public static boolean isCombatLoaded() {
        return LoaderHelper.isModLoaded((String)"combat");
    }

    public static boolean isOriginsLoaded() {
        return LoaderHelper.isModLoaded((String)"origins");
    }

    public Survive() {
        super(MOD_ID, () -> new SurviveClientSegment(), () -> new ServerSegment());
        instance = this;
        isPrimalWinterLoaded = LoaderHelper.isModLoaded((String)"primalwinter");
        try {
            PlayerNeeds.setImpl(new PlayerNeeds(this){

                @Override
                public Temperature getTemperature(class_1309 entity) {
                    return ((IRealisticEntity)entity).temperatureData();
                }

                @Override
                public Stamina getStamina(class_1309 entity) {
                    return ((IRealisticEntity)entity).staminaData();
                }

                @Override
                public Water getWater(class_1309 entity) {
                    return ((IRealisticEntity)entity).waterData();
                }
            });
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
    }

    public void onModConstruct() {
        new FluidSTags();
        new ItemSTags();
        if (Survive.isOriginsLoaded()) {
            OriginsCompat.initOriginsPatcher();
        }
        BlockPropertyHandlerImpl.init();
    }

    public void setupBrewingRecipes(BrewingRecipeCollector collector) {
        collector.addMix(class_1847.field_8999, SItems.ICE_CUBE, SPotions.COLD_RESISTANCE);
        collector.addMix(SPotions.COLD_RESISTANCE, class_1802.field_8725, SPotions.LONG_COLD_RESISTANCE);
        collector.addMix(SPotions.COLD_RESISTANCE, class_1802.field_8601, SPotions.STRONG_COLD_RESISTANCE);
        collector.addMix(class_1847.field_8999, SItems.MAGMA_PASTE, SPotions.HEAT_RESISTANCE);
        collector.addMix(SPotions.HEAT_RESISTANCE, class_1802.field_8725, SPotions.LONG_HEAT_RESISTANCE);
        collector.addMix(SPotions.HEAT_RESISTANCE, class_1802.field_8601, SPotions.STRONG_HEAT_RESISTANCE);
        collector.builder().method_59702(SItems.FILLED_CANTEEN);
        collector.builder().method_59702(SItems.FILLED_NETHERITE_CANTEEN);
    }

    public void setupPacks(PackCollector collector) {
        collector.addPack("datapacks/replace_vanilla", (class_2561)class_2561.method_43470((String)"Replace Vanilla"), class_3264.field_14190);
    }

    public void setupFluids(FluidPropertyCollector collector) {
        collector.forFluid(FluidProperties.create((class_2960)this.location("purified_water")).flowingTexture(this.location("block/purified_water_flow")).stillTexture(this.location("block/purified_water_still")).overlayTexture(this.location("block/purified_water_overlay")).tint((fl, getter, pos) -> class_1163.method_4961((class_1920)getter, (class_2338)pos) | 0xFE41D3F8).tint(-25081124).fallDistanceModifier(0.0f).canExtinguish(true).supportsBoats(true).toProperties(), new Supplier[]{() -> SFluids.FLOWING_PURIFIED_WATER, () -> SFluids.PURIFIED_WATER});
    }

    public void onModStartup() {
        SCauldronInteraction.bootStrap();
        CGameRules.init();
    }

    public void onModStartupInClient() {
    }

    public void setupConfigs(ConfigCollector collector) {
        collector.registerConfig(ServerConfig.class);
        collector.registerConfig((ConfigObject)FOOD_CONFIG);
        collector.registerConfig((ConfigObject)CONFIG);
        collector.registerConfig((ConfigObject)HYGIENE_CONFIG);
        collector.registerConfig((ConfigObject)TEMPERATURE_CONFIG);
        collector.registerConfig((ConfigObject)THIRST_CONFIG);
        collector.registerConfig((ConfigObject)WELLBEING_CONFIG);
        collector.registerConfig((ConfigObject)STAMINA_CONFIG);
    }

    public void setupCommands(CommandCollector collector) {
        NeedsCommand.register((CommandDispatcher<class_2168>)collector.dispatcher());
    }

    public void setupRegistries(RegistryCollector collector) {
        collector.addRegistryHolder(class_7924.field_41251, SAttributes.class);
        collector.addRegistryHolder(class_7924.field_48977, SArmorMaterials.class);
        collector.addRegistryHolder(class_7924.field_41254, SBlocks.class);
        collector.addRegistryHolder(class_7924.field_41270, SFluids.class);
        collector.addRegistryHolder(class_7924.field_41197, SItems.class);
        collector.addRegistryHolder(class_7924.field_41197, HygieneItems.class);
        collector.addRegistryHolder(class_7924.field_41208, SMobEffects.class);
        collector.addRegistryHolder(class_7924.field_41216, SRecipeSerializer.class);
        collector.addRegistryHolder(class_7924.field_49659, SDataComponents.class);
        collector.addRegistryHolder(class_7924.field_51838, SEnchantmentEffectComponents.class);
        collector.addRegistryHolder(class_7924.field_41215, SPotions.class);
        collector.addRegistryHolder(class_7924.field_41210, SParticleTypes.class);
        collector.addRegistryHolder(class_7924.field_41207, SMenuType.class);
        collector.addRegistry(SurviveRegistries.CONDITION, SurviveRegistries.Keys.CONDITION, true);
        collector.addRegistry(SurviveRegistries.SEASON, SurviveRegistries.Keys.SEASON, true);
        collector.addCustom(SurviveRegistries.Keys.CONDITION, TemperatureChangeConditions::registerAll);
        collector.addCustom(SurviveRegistries.Keys.SEASON, Seasons::registerAll);
        collector.addCustom(class_7924.field_41255, SBlockEntityType::registerAll);
        collector.addCustom(class_7924.field_41208, override -> ((class_1291)class_1294.field_5918.comp_349()).method_5566(SAttributes.HEAT_RESISTANCE.holder(), VersionHelper.toLoc((String)"fire_heat_res"), 5.0, class_1322.class_1323.field_6328));
        collector.addCustom(class_7924.field_41215, override -> {
            POTION_FLUID_MAP = new ImmutableMap.Builder().put((Object)class_1847.field_8991, (Object)Lists.newArrayList((Object[])new class_3611[]{class_3612.field_15909, class_3612.field_15910})).put((Object)SPotions.PURIFIED_WATER.holder(), (Object)Lists.newArrayList((Object[])new class_3611[]{SFluids.FLOWING_PURIFIED_WATER, SFluids.PURIFIED_WATER})).build();
        });
        new SLootItemConditions();
    }

    public void registerInserts(InsertCollector collector) {
        collector.addInsert((InsertHandler)Inserts.LIVING_TICK, insert -> SurviveEvents.sendToClient(insert.living()));
        collector.addInsert((InsertHandler)Inserts.LIVING_TICK, insert -> SurviveEvents.updateEnvTemperature(insert.living()));
        collector.addInsert((InsertHandler)Inserts.PLAYER_RESTORE, insert -> SurviveEvents.restoreStats(insert.thisPlayer(), insert.thatPlayer(), insert.keepEverything()));
        collector.addInsert((InsertHandler)Inserts.LOGGED_OUT, insert -> SurviveEvents.desyncClient(insert.player()));
        collector.addInsert((InsertHandler)ServerInserts.SERVER_STARTING, insert -> TempEvents.serverStart(insert.server()));
        collector.addInsert((InsertHandler)ServerInserts.SERVER_STOPPING, insert -> TempEvents.serverStop(insert.server()));
        collector.addInsert((InsertHandler)Inserts.LEVEL_LOAD, insert -> SurviveEvents.addReload(insert.level()));
        collector.addInsert((InsertHandler)Inserts.LOOT_TABLE_LOAD, insert -> {
            String ANIMAL_LOOT = "entities/animal_fat";
            ArrayList LOOT_MODIFIERS = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)VersionHelper.toLoc((String)"entities/sheep"), (Object)Lists.newArrayList((Object[])new String[]{ANIMAL_LOOT})), Pair.of((Object)VersionHelper.toLoc((String)"entities/chicken"), (Object)Lists.newArrayList((Object[])new String[]{ANIMAL_LOOT})), Pair.of((Object)VersionHelper.toLoc((String)"entities/cow"), (Object)Lists.newArrayList((Object[])new String[]{ANIMAL_LOOT})), Pair.of((Object)VersionHelper.toLoc((String)"entities/pig"), (Object)Lists.newArrayList((Object[])new String[]{ANIMAL_LOOT}))});
            BiFunction<String, Integer, class_79.class_80> getInjectEntry = (name, weight) -> {
                class_5321 table = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)Survive.getInstance().location("inject/" + name));
                return class_83.method_428((class_5321)table).method_437(weight.intValue());
            };
            LOOT_MODIFIERS.forEach(pair -> {
                if (insert.name().equals(pair.getKey())) {
                    ((List)pair.getValue()).forEach(file -> {
                        Survive.getInstance().debug("Injecting \"" + file + "\" in " + String.valueOf(pair.getKey()));
                        LoaderHelper.addPoolToLootTable((class_52)((class_52)insert.table().get()), (class_55)class_55.method_347().method_351((class_79.class_80)getInjectEntry.apply((String)file, 1)).method_35509((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f)).method_355());
                    });
                }
            });
        });
        collector.addInsert((InsertHandler)Inserts.MENU_OPEN, insert -> {
            if (insert.player() != null) {
                FoodUtils.giveLifespanToFood((class_2371<class_1799>)insert.menu().method_7602(), insert.player().method_37908().method_8510());
            }
        });
        collector.addInsert((InsertHandler)Inserts.PLAYER_CAN_SLEEP, insert -> SleepEvents.allowSleep(insert.player(), insert.pos(), insert.vanillaProblem(), (InsertSetter<class_1657.class_1658>)insert.problem()));
        collector.addInsert((InsertHandler)Inserts.PLAYER_CONTINUE_SLEEP, insert -> SleepEvents.allowSleep(insert.player(), insert.sleepingPos(), (InsertSetter<Boolean>)insert.mayContinueSleeping()));
        collector.addInsert((InsertHandler)Inserts.INTERACT_WITH_BLOCK, insert -> ThirstEvents.interactWithWaterSourceBlock(insert.player(), insert.level(), insert.hand(), insert.hitResult(), (InsertResultCanceller<class_1269>)insert.cancel()));
        collector.addInsert((InsertHandler)Inserts.INTERACT_WITH_ITEM, insert -> ThirstEvents.interactWithWaterSourceBlock(insert.player(), insert.level(), insert.hand(), (InsertResultCanceller<class_1271<class_1799>>)insert.cancel()));
        collector.addInsert((InsertHandler)Inserts.INTERACT_WITH_ITEM, insert -> StaminaData.clickItem(insert.player(), insert.level(), insert.hand(), (InsertResultCanceller<class_1271<class_1799>>)insert.cancel()));
        collector.addInsert((InsertHandler)Inserts.MENU_OPEN, insert -> {
            class_1707 chest;
            class_1263 patt1$temp;
            class_1703 patt0$temp = insert.menu();
            if (patt0$temp instanceof class_1707 && (patt1$temp = (chest = (class_1707)patt0$temp).method_7629()) instanceof class_2595) {
                class_2595 block = (class_2595)patt1$temp;
                class_1657 patt2$temp = insert.player();
                if (patt2$temp instanceof class_3222) {
                    class_3222 pl = (class_3222)patt2$temp;
                    ColdStorage coldStorage = (ColdStorage)block;
                }
            }
        });
        collector.addInsert((InsertHandler)Inserts.LEVEL_WAKE_UP, insert -> SleepEvents.replenishEnergy(insert.level()));
    }

    public void modifyDefaultEntityAttributes(DefaultAttributeModifier modifier) {
        super.modifyDefaultEntityAttributes(modifier);
        modifier.addToEntity(class_1299.field_6097, new class_6880[]{SAttributes.COLD_RESISTANCE.holder(), SAttributes.HEAT_RESISTANCE.holder(), SAttributes.MAX_STAMINA.holder()});
    }

    public void registerPackets(PacketCollector collector) {
        collector.registerServerboundPacket(ServerboundArmorStaminaPacket.id, ServerboundArmorStaminaPacket.class, ServerboundArmorStaminaPacket::new);
        collector.registerServerboundPacket(ServerboundThirstMovementPacket.id, ServerboundThirstMovementPacket.class, ServerboundThirstMovementPacket::new);
        collector.registerServerboundPacket(ServerboundInteractWithWaterPacket.id, ServerboundInteractWithWaterPacket.class, ServerboundInteractWithWaterPacket::new);
        collector.registerServerboundPacket(ServerboundStaminaExhaustionPacket.id, ServerboundStaminaExhaustionPacket.class, ServerboundStaminaExhaustionPacket::new);
        collector.registerServerboundPacket(ServerboundRelaxPacket.id, ServerboundRelaxPacket.class, ServerboundRelaxPacket::new);
        collector.registerServerboundPacket(ServerboundPlayerStatusBookPacket.id, ServerboundPlayerStatusBookPacket.class, ServerboundPlayerStatusBookPacket::new);
        collector.registerClientboundPacket(ClientboundSurvivalStatsPacket.id, ClientboundSurvivalStatsPacket.class, ClientboundSurvivalStatsPacket::new);
        collector.registerClientboundPacket(ClientboundDrinkSoundPacket.id, ClientboundDrinkSoundPacket.class, ClientboundDrinkSoundPacket::new);
        collector.registerClientboundPacket(ClientboundDataTransferPacket.id, ClientboundDataTransferPacket.class, ClientboundDataTransferPacket::new);
    }

    public static void registerDrinkDataForItem(class_2960 location, FoodJsonHolder drinkData) {
        DataMaps.Server.consummableItem.put(location, drinkData);
    }

    public static void registerDrinkDataForPotion(class_2960 location, PotionJsonHolder consummableData) {
        DataMaps.Server.potionDrink.put(location, consummableData);
    }

    public static void registerArmorTemperatures(class_2960 location, ArmorJsonHolder armorData) {
        DataMaps.Server.armor.put(location, armorData);
    }

    public static void registerBlockTemperatures(class_2960 location, BlockTemperatureJsonHolder drinkData) {
        DataMaps.Server.blockTemperature.put(location, drinkData);
    }

    public static void registerEntityTemperatures(class_2960 location, EntityTemperatureJsonHolder drinkData) {
        DataMaps.Server.entityTemperature.put(location, drinkData);
    }

    public static void registerBiomeTemperatures(class_2960 location, BiomeJsonHolder biomeData) {
        DataMaps.Server.biome.put(location, biomeData);
    }

    public void debug(Object message) {
        if (Survive.CONFIG.debugMode) {
            this.getLogger().debug(message);
        }
    }

    public static class_1799 convertToPlayerStatusBook(class_1799 stack) {
        class_1799 result = new class_1799((class_1935)class_1802.field_8360);
        result.method_57365(stack.method_57353());
        SDataComponents.STATUS_OWNER_D.setData(result, (Object)UUID.fromString("00000000-0000-0000-0000-000000000000"));
        class_9302 book = (class_9302)result.method_57824(class_9334.field_49606);
        if (book != null) {
            class_9302 b = new class_9302(book.comp_2419(), book.comp_2420(), 0, book.comp_2422(), book.comp_2423());
            result.method_57379(class_9334.field_49606, (Object)b);
        }
        return result;
    }

    public void registerServerRelaodableResources(ReloadListeners reloadListener) {
        reloadListener.listenTo((ReloadListener)consummableReloader);
        reloadListener.listenTo((ReloadListener)potionReloader);
        reloadListener.listenTo((ReloadListener)armorReloader);
        reloadListener.listenTo((ReloadListener)blockReloader);
        reloadListener.listenTo((ReloadListener)biomeReloader);
        reloadListener.listenTo((ReloadListener)entityReloader);
        reloadListener.listenTo((ReloadListener)fluidReloader);
    }

    public void registerCreativeTabs(CreativeTabBuilder builder) {
        builder.addTab("main_tab", SCreativeModeTab.TAB_MAIN);
    }

    public void populateCreativeTabs(CreativeTabPopulator populator) {
        if (populator.getTab().method_7737().equals((Object)SCreativeModeTab.TAB_MAIN.method_7737()) && Survive.HYGIENE_CONFIG.enabled) {
            populator.addItems(new class_1792[]{HygieneItems.BATH_SPONGE});
            populator.addItems(new class_1792[]{HygieneItems.WHITE_WASHCLOTH});
            populator.addItems(new class_1792[]{HygieneItems.ORANGE_WASHCLOTH});
            populator.addItems(new class_1792[]{HygieneItems.MAGENTA_WASHCLOTH});
            populator.addItems(new class_1792[]{HygieneItems.LIGHT_BLUE_WASHCLOTH});
            populator.addItems(new class_1792[]{HygieneItems.YELLOW_WASHCLOTH});
            populator.addItems(new class_1792[]{HygieneItems.LIME_WASHCLOTH});
            populator.addItems(new class_1792[]{HygieneItems.PINK_WASHCLOTH});
            populator.addItems(new class_1792[]{HygieneItems.GRAY_WASHCLOTH});
            populator.addItems(new class_1792[]{HygieneItems.LIGHT_GRAY_WASHCLOTH});
            populator.addItems(new class_1792[]{HygieneItems.CYAN_WASHCLOTH});
            populator.addItems(new class_1792[]{HygieneItems.PURPLE_WASHCLOTH});
            populator.addItems(new class_1792[]{HygieneItems.BLUE_WASHCLOTH});
            populator.addItems(new class_1792[]{HygieneItems.BROWN_WASHCLOTH});
            populator.addItems(new class_1792[]{HygieneItems.GREEN_WASHCLOTH});
            populator.addItems(new class_1792[]{HygieneItems.RED_WASHCLOTH});
            populator.addItems(new class_1792[]{HygieneItems.BLACK_WASHCLOTH});
            populator.addItems(new class_1792[]{HygieneItems.WOOD_ASH});
            populator.addItems(new class_1792[]{HygieneItems.POTASH_SOLUTION});
            populator.addItems(new class_1792[]{HygieneItems.POTASH});
            populator.addItems(new class_1792[]{HygieneItems.ANIMAL_FAT});
            populator.addItems(new class_1792[]{HygieneItems.SOAP_MIX});
            populator.addItems(new class_1792[]{HygieneItems.SOAP_BOTTLE});
        }
        if (populator.getTab().method_7737().equals((Object)SCreativeModeTab.TAB_MAIN.method_7737())) {
            populator.addItems(new class_1792[]{SItems.WOOL_HAT});
            populator.addItems(new class_1792[]{SItems.WOOL_JACKET});
            populator.addItems(new class_1792[]{SItems.WOOL_PANTS});
            populator.addItems(new class_1792[]{SItems.WOOL_BOOTS});
            populator.addItems(new class_1792[]{SItems.STIFFENED_HONEY_HELMET});
            populator.addItems(new class_1792[]{SItems.STIFFENED_HONEY_CHESTPLATE});
            populator.addItems(new class_1792[]{SItems.STIFFENED_HONEY_LEGGINGS});
            populator.addItems(new class_1792[]{SItems.STIFFENED_HONEY_BOOTS});
            populator.addItems(new class_1792[]{SItems.WATER_BOWL});
            populator.addItems(new class_1792[]{SItems.PURIFIED_WATER_BOWL});
            populator.addItems(new class_1792[]{SItems.ICE_CUBE});
            populator.addItems(new class_1792[]{SItems.THERMOMETER});
            populator.addItems(new class_1792[]{SItems.TEMPERATURE_REGULATOR});
            populator.addItems(new class_1792[]{SItems.LARGE_HEATING_PLATE});
            populator.addItems(new class_1792[]{SItems.LARGE_COOLING_PLATE});
            populator.addItems(new class_1792[]{SItems.MEDIUM_HEATING_PLATE});
            populator.addItems(new class_1792[]{SItems.MEDIUM_COOLING_PLATE});
            populator.addItems(new class_1792[]{SItems.SMALL_HEATING_PLATE});
            populator.addItems(new class_1792[]{SItems.SMALL_COOLING_PLATE});
            populator.addItems(new class_1792[]{SItems.CHARCOAL_FILTER});
            populator.addItems(new class_1792[]{SItems.USED_CHARCOAL_FILTER});
            populator.addItems(new class_1792[]{SItems.PURIFIED_WATER_BUCKET});
            populator.addItems(new class_1792[]{SItems.MAGMA_PASTE});
            populator.addItems(new class_1792[]{SItems.SEA_SALT});
            populator.addItems(new class_1792[]{SItems.SALT_BOX});
            populator.addItems(new class_1792[]{SItems.REALISTIC_CAMPFIRE});
            populator.addItems(new class_1792[]{SItems.CANTEEN});
            populator.getParams().comp_1253().method_46759(class_7924.field_41215).ifPresent(p_327138_ -> Survive.generatePotionEffectTypes(populator.getOutput(), (class_7225<class_1842>)p_327138_, SItems.FILLED_CANTEEN, Survive.THIRST_CONFIG.canteen_fill_amount, class_1761.class_7705.field_40191));
            populator.addItems(new class_1792[]{SItems.NETHERITE_CANTEEN});
            populator.getParams().comp_1253().method_46759(class_7924.field_41215).ifPresent(p_327138_ -> Survive.generatePotionEffectTypes(populator.getOutput(), (class_7225<class_1842>)p_327138_, SItems.FILLED_NETHERITE_CANTEEN, Survive.THIRST_CONFIG.nether_canteen_fill_amount, class_1761.class_7705.field_40191));
        }
    }

    private static void generatePotionEffectTypes(class_1761.class_7704 pOutput, class_7225<class_1842> pPotions, class_1792 pItem, int max, class_1761.class_7705 pTabVisibility) {
        pPotions.method_42017().map(potion -> CanteenItem.addToCanteen(new class_1799((class_1935)pItem), max, (class_6880<class_1842>)potion)).forEach(p_270000_ -> pOutput.method_45417(p_270000_, pTabVisibility));
    }

    public static List<String> defaultDimensionMods() {
        ArrayList<String> dims = new ArrayList<String>();
        dims.add("minecraft:overworld,0.0");
        dims.add("minecraft:the_nether,0.0");
        dims.add("minecraft:the_end,0.0");
        return dims;
    }

    public static Survive getInstance() {
        return instance;
    }

    static {
        CONFIG = new Config();
        FOOD_CONFIG = new FoodConfig();
        STAMINA_CONFIG = new StaminaConfig();
        HYGIENE_CONFIG = new HygieneConfig();
        TEMPERATURE_CONFIG = new TemperatureConfig();
        THIRST_CONFIG = new ThirstConfig();
        WELLBEING_CONFIG = new WellbeingConfig();
        NON_NEGATIVE_LONG = Codec.LONG.validate(p_274889_ -> p_274889_.compareTo(0L) >= 0 && p_274889_.compareTo(Long.MAX_VALUE) <= 0 ? DataResult.success((Object)p_274889_) : DataResult.error(() -> "Value must be non-negative: " + p_274889_));
        consummableReloader = new ItemConsummableDataManager();
        potionReloader = new PotionDrinkDataManager();
        armorReloader = new ArmorDataManager();
        blockReloader = new BlockDataManager();
        biomeReloader = new BiomeDataManager();
        entityReloader = new EntityTemperatureDataManager();
        fluidReloader = new FluidDataManager();
    }
}

