/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.json;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.json.JsonHolder;
import com.stereowalker.survive.core.registries.SurviveRegistries;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeCondition;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeInstance;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ArmorJsonHolder
implements JsonHolder {
    private static final Marker ARMOR_DATA = MarkerManager.getMarker((String)"ARMOR_DATA");
    private class_2960 itemID;
    private final List<Pair<String, TemperatureChangeInstance>> temperatureModifier;
    private final float weightModifier;
    String wo = "NOTHING";

    public ArmorJsonHolder(class_2487 nbt) {
        this.itemID = VersionHelper.toLoc((String)nbt.method_10558("id"));
        this.weightModifier = nbt.method_10583("weight_modifier");
        this.temperatureModifier = Lists.newArrayList();
        nbt.method_10554("temperature_modifiers", 10).forEach(comp -> {
            class_2487 nbt2 = (class_2487)comp;
            this.temperatureModifier.add((Pair<String, TemperatureChangeInstance>)Pair.of((Object)nbt2.method_10558("condition"), ((TemperatureChangeCondition)SurviveRegistries.CONDITION.get(VersionHelper.toLoc((String)nbt2.method_10558("condition")))).createInstance(nbt2.method_10562("contents"))));
        });
    }

    public ArmorJsonHolder(class_2960 itemID, JsonObject object) {
        ArrayList temperatureModifierIn = Lists.newArrayList();
        float weightModifierIn = 0.0f;
        this.itemID = itemID;
        if (object.entrySet().size() != 0) {
            try {
                if (this.hasMemberAndIsJsonArray("temperature_modifiers", object)) {
                    this.setWorkingOn("temperature_modifiers");
                    for (JsonElement elem : object.get("temperature_modifiers").getAsJsonArray()) {
                        if (elem.isJsonObject()) {
                            JsonObject object2 = elem.getAsJsonObject();
                            TemperatureChangeCondition condition = null;
                            if (object2 == null || object2.entrySet().size() == 0 || !object2.has("condition") || !object2.get("condition").isJsonPrimitive()) continue;
                            this.setWorkingOn("condition");
                            condition = (TemperatureChangeCondition)SurviveRegistries.CONDITION.get(VersionHelper.toLoc((String)object2.get("condition").getAsString()));
                            if (condition != null) {
                                temperatureModifierIn.add(Pair.of((Object)object2.get("condition").getAsString(), condition.createInstance(object2)));
                            } else {
                                Survive.getInstance().getLogger().error("Error loading armor data {} from JSON: The condition {} does not exist", (Object)itemID, (Object)VersionHelper.toLoc((String)object2.get("condition").getAsString()));
                            }
                            this.stopWorking();
                            continue;
                        }
                        Survive.getInstance().getLogger().error("Error loading armor data {} from JSON: The conditions for {} aren't a json object", (Object)itemID, (Object)elem);
                    }
                    this.stopWorking();
                }
                if (object.has("weight_modifier") && object.get("weight_modifier").isJsonPrimitive()) {
                    weightModifierIn = this.workOnFloat("weight_modifier", object);
                }
            }
            catch (ClassCastException e) {
                Survive.getInstance().getLogger().warn(ARMOR_DATA, "Error loading armor data {} from JSON: Parsing element {}: element was wrong type!", (Object)itemID, (Object)this.getworkingOn());
            }
            catch (NumberFormatException e) {
                Survive.getInstance().getLogger().warn(ARMOR_DATA, "Error loading armor data {} from JSON: Parsing element {}: element was an invalid number!", (Object)itemID, (Object)this.getworkingOn());
            }
        }
        if (weightModifierIn < 0.0f) {
            Survive.getInstance().getLogger().warn(ARMOR_DATA, "Error loading armor data {} from JSON: Parsing element {}: weight is less than zero, please fix this!", (Object)itemID, (Object)"weight_modifier");
            weightModifierIn = 0.0f;
        }
        this.temperatureModifier = temperatureModifierIn;
        this.weightModifier = weightModifierIn;
    }

    public class_2960 getItemID() {
        return this.itemID;
    }

    public List<Pair<String, TemperatureChangeInstance>> getTemperatureModifier() {
        return this.temperatureModifier;
    }

    public float getWeightModifier() {
        return this.weightModifier;
    }

    @Override
    public class_2487 serialize() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("id", this.itemID.toString());
        nbt.method_10548("weight_modifier", this.weightModifier);
        class_2499 list = new class_2499();
        this.temperatureModifier.forEach(mod -> {
            class_2487 entry = new class_2487();
            entry.method_10582("condition", (String)mod.getFirst());
            entry.method_10566("contents", (class_2520)((TemperatureChangeInstance)mod.getSecond()).serialize());
            list.add((Object)entry);
        });
        nbt.method_10566("temperature_modifiers", (class_2520)list);
        return nbt;
    }

    @Override
    public ArmorJsonHolder deserialize(class_2487 input) {
        return new ArmorJsonHolder(input);
    }

    @Override
    public String getworkingOn() {
        return this.wo;
    }

    @Override
    public void setWorkingOn(String member) {
        this.wo = member;
    }
}

