/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.json;

import com.google.gson.JsonObject;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.json.JsonHolder;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class EntityTemperatureJsonHolder
implements JsonHolder {
    private static final Marker ENTITY_TEMPERATURE_DATA = MarkerManager.getMarker((String)"ENTITY_TEMPERATURE_DATA");
    private class_2960 entityID;
    private final float temperatureModifier;
    private final float range;
    String wo = "NOTHING";

    public EntityTemperatureJsonHolder(class_2960 blockID, JsonObject object) {
        String TEMPERATURE_MODIFIER = "temperature_modifier";
        String RANGE = "range";
        float temperatureModifierIn = 0.0f;
        float rangeIn = 0.0f;
        this.entityID = blockID;
        if (object.entrySet().size() != 0) {
            this.stopWorking();
            try {
                if (object.has(TEMPERATURE_MODIFIER) && object.get(TEMPERATURE_MODIFIER).isJsonPrimitive()) {
                    this.setWorkingOn(TEMPERATURE_MODIFIER);
                    temperatureModifierIn = object.get(TEMPERATURE_MODIFIER).getAsFloat();
                    this.stopWorking();
                }
                if (object.has(RANGE) && object.get(RANGE).isJsonPrimitive()) {
                    this.setWorkingOn(RANGE);
                    rangeIn = object.get(RANGE).getAsFloat();
                    this.stopWorking();
                }
            }
            catch (ClassCastException e) {
                Survive.getInstance().getLogger().warn(ENTITY_TEMPERATURE_DATA, "Loading entity temperature data $s from JSON: Parsing element %s: element was wrong type!", (Object)e, (Object)blockID, (Object)this.getworkingOn());
            }
            catch (NumberFormatException e) {
                Survive.getInstance().getLogger().warn(ENTITY_TEMPERATURE_DATA, "Loading entity temperature data $s from JSON: Parsing element %s: element was an invalid number!", (Object)e, (Object)blockID, (Object)this.getworkingOn());
            }
        }
        if (rangeIn > 5.0f) {
            Survive.getInstance().getLogger().warn(ENTITY_TEMPERATURE_DATA, "Loading entity temperature data $s from JSON: Range should not be greater that 5", (Object)blockID);
            rangeIn = 5.0f;
        }
        if (rangeIn < 0.0f) {
            Survive.getInstance().getLogger().warn(ENTITY_TEMPERATURE_DATA, "Loading entity temperature data $s from JSON: Range should not be less than 0", (Object)blockID);
            rangeIn = 0.0f;
        }
        this.temperatureModifier = temperatureModifierIn;
        this.range = rangeIn;
    }

    public class_2960 getItemID() {
        return this.entityID;
    }

    public float getTemperatureModifier() {
        return this.temperatureModifier;
    }

    public float getRange() {
        return this.range;
    }

    @Override
    public class_2487 serialize() {
        return null;
    }

    @Override
    public String getworkingOn() {
        return this.wo;
    }

    @Override
    public void setWorkingOn(String member) {
        this.wo = member;
    }

    @Override
    public JsonHolder deserialize(class_2487 input) {
        return null;
    }
}

