/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.mixins;

import com.stereowalker.survive.FoodUtils;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.json.ConsummableJsonHolder;
import com.stereowalker.survive.needs.CustomFoodData;
import com.stereowalker.survive.needs.HygieneData;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.NutritionData;
import com.stereowalker.survive.needs.SleepData;
import com.stereowalker.survive.needs.StaminaData;
import com.stereowalker.survive.needs.TemperatureData;
import com.stereowalker.survive.needs.WaterData;
import com.stereowalker.survive.needs.WellbeingData;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import net.minecraft.class_1267;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4174;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
extends class_1309
implements IRealisticEntity {
    @Shadow
    protected class_1702 field_7493;
    @Shadow
    private int field_7487;
    private TemperatureData temperatureData = new TemperatureData();
    private WellbeingData wellbeingData = new WellbeingData();
    private NutritionData nutritionData = new NutritionData();
    private HygieneData hygieneData = new HygieneData();
    private StaminaData staminaData = new StaminaData(this.method_45325(SAttributes.MAX_STAMINA.holder()));
    private SleepData sleepData = new SleepData();
    private WaterData waterData = new WaterData();

    protected PlayerMixin(class_1299<? extends class_1309> type, class_1937 worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void initInject(CallbackInfo ci) {
        this.field_7493 = new CustomFoodData(this.field_7493);
    }

    @Inject(method={"eat"}, at={@At(value="HEAD")})
    public void eatInject(class_1937 pLevel, class_1799 pFood, class_4174 pFoodProperties, CallbackInfoReturnable<class_1799> cir) {
        class_1702 class_17022;
        if (VersionHelper.VanillaComponents.FOOD.hasData(pFood) && (class_17022 = this.field_7493) instanceof CustomFoodData) {
            CustomFoodData custom = (CustomFoodData)class_17022;
            class_4174 foodproperties = (class_4174)VersionHelper.VanillaComponents.FOOD.getData(pFood);
            for (class_4174.class_9423 effect : foodproperties.comp_2495()) {
                if (effect.comp_2496().method_5579() != class_1294.field_5903 && custom.IsSpoiled() != FoodUtils.State.Spoiled) continue;
                custom.consumeUnclean();
                break;
            }
        }
        this.staminaData().eat(pFood.method_7909(), pFood, this);
        this.waterData().drink(pFood.method_7909(), pFood, this);
        this.getRealFoodData().markAsSpoiled(pFood, this);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/entity/player/Player;updateIsUnderwater()Z")})
    public void tickInject(CallbackInfo ci) {
        SurviveEntityStats.addStatsOnSpawn((class_1657)this);
        if (!this.method_37908().field_9236 && (class_1657)this instanceof class_3222) {
            class_3222 player = (class_3222)this;
            if (Survive.THIRST_CONFIG.enabled && player.method_37908().method_8407() == class_1267.field_5801 && player.method_37908().method_8450().method_8355(class_1928.field_19395) && this.waterData().needWater() && player.field_6012 % 10 == 0) {
                this.waterData().setWaterLevel(this.waterData().getWaterLevel() + 1);
            }
        }
        if (!this.method_37908().field_9236) {
            this.staminaData().baseTick((class_1657)this);
            this.hygieneData().baseTick((class_1657)this);
            this.nutritionData.baseTick((class_1657)this);
            this.temperatureData().baseTick((class_1657)this);
            this.waterData().baseTick((class_1657)this);
            this.wellbeingData.baseTick((class_1657)this);
            this.sleepData().baseTick((class_1657)this);
        }
    }

    @Redirect(method={"canEat"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;needsFood()Z"))
    public boolean makeEdible(class_1702 foodData) {
        if (foodData instanceof CustomFoodData) {
            return ((CustomFoodData)foodData).canConsumeFood();
        }
        return foodData.method_7587();
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;causeFoodExhaustion(F)V"), method={"jumpFromGround"})
    public void morphExhaustionDuringJump(class_1657 player, float value) {
        this.bypassFoodExhaustion(value, value * 2.5f, class_3532.method_15386((float)(value * 2.5f)), "Jumped", this.method_5624());
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;causeFoodExhaustion(F)V"), method={"actuallyHurt"})
    public void morphExhaustion(class_1657 player, float value) {
        this.bypassFoodExhaustion(value, value * 2.5f, class_3532.method_15386((float)(value * 2.5f)), "Got hurt", false);
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;causeFoodExhaustion(F)V"), method={"attack"})
    public void morphStaminaDuringAttack(class_1657 player, float value) {
        this.bypassFoodExhaustion(value, 1.25f, class_3532.method_15386((float)(value * 2.5f)), "Player Attacked", true);
    }

    @Inject(method={"eat"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;eat(Lnet/minecraft/world/food/FoodProperties;)V")})
    public void addNutrients(class_1937 arg0, class_1799 p_213357_2_, class_4174 pFoodProperties, CallbackInfoReturnable<class_1799> cir) {
        if (Survive.CONFIG.nutrition_enabled) {
            float protein = 1.0f;
            float carbs = 1.0f;
            float fats = 1.0f;
            if (DataMaps.Server.consummableItem.containsKey(RegistryHelper.items().method_10221((Object)p_213357_2_.method_7909()))) {
                ConsummableJsonHolder data = DataMaps.Server.consummableItem.get(RegistryHelper.items().method_10221((Object)p_213357_2_.method_7909()));
                protein = data.getProteinRatio();
                carbs = data.getCarbohydrateRatio();
                fats = data.getFatRatio();
            }
            class_4174 food = (class_4174)VersionHelper.VanillaComponents.FOOD.getData(p_213357_2_);
            float total = protein + carbs + fats;
            this.nutritionData.carbs().add(food.comp_2491() * class_3532.method_15386((float)(carbs / total * 100.0f)));
            this.nutritionData.protein().add(food.comp_2491() * class_3532.method_15386((float)(protein / total * 100.0f)));
            this.nutritionData.fat().add(food.comp_2491() * class_3532.method_15386((float)(fats / total * 100.0f)));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData_inject(class_2487 pCompound, CallbackInfo ci) {
        if (pCompound.method_10573("surviveData", 10)) {
            class_2487 surviveData = pCompound.method_10562("surviveData");
            if (surviveData.method_10573("temperature", 10)) {
                this.temperatureData.read(surviveData.method_10562("temperature"));
            }
            if (surviveData.method_10573("wellbeing", 10)) {
                this.wellbeingData.read(surviveData.method_10562("wellbeing"));
            }
            if (surviveData.method_10573("nutrition", 10)) {
                this.nutritionData.read(surviveData.method_10562("nutrition"));
            }
            if (surviveData.method_10573("hygiene", 10)) {
                this.hygieneData.read(surviveData.method_10562("hygiene"));
            }
            if (surviveData.method_10573("stamina", 10)) {
                this.staminaData.read(surviveData.method_10562("stamina"));
            }
            if (surviveData.method_10573("sleep", 10)) {
                this.sleepData.read(surviveData.method_10562("sleep"));
            }
            if (surviveData.method_10573("water", 10)) {
                this.waterData.read(surviveData.method_10562("water"));
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData_inject(class_2487 pCompound, CallbackInfo ci) {
        class_2487 surviveData = new class_2487();
        surviveData.method_10566("temperature", (class_2520)this.temperatureData.write(false));
        surviveData.method_10566("wellbeing", (class_2520)this.wellbeingData.write(false));
        surviveData.method_10566("nutrition", (class_2520)this.nutritionData.write(false));
        surviveData.method_10566("hygiene", (class_2520)this.hygieneData.write(false));
        surviveData.method_10566("stamina", (class_2520)this.staminaData.write(false));
        surviveData.method_10566("sleep", (class_2520)this.sleepData.write(false));
        surviveData.method_10566("water", (class_2520)this.waterData.write(false));
        pCompound.method_10566("surviveData", (class_2520)surviveData);
    }

    @Override
    public StaminaData staminaData() {
        return this.staminaData;
    }

    @Override
    public void setStaminaData(StaminaData data) {
        this.staminaData = data;
    }

    @Override
    public HygieneData hygieneData() {
        return this.hygieneData;
    }

    @Override
    public void setHygieneData(HygieneData data) {
        this.hygieneData = data;
    }

    @Override
    public NutritionData nutritionData() {
        return this.nutritionData;
    }

    @Override
    public void setNutritionData(NutritionData data) {
        this.nutritionData = data;
    }

    @Override
    public TemperatureData temperatureData() {
        return this.temperatureData;
    }

    @Override
    public void setTemperatureData(TemperatureData data) {
        this.temperatureData = data;
    }

    @Override
    public WaterData waterData() {
        return this.waterData;
    }

    @Override
    public void setWaterData(WaterData data) {
        this.waterData = data;
    }

    @Override
    public WellbeingData wellbeingData() {
        return this.wellbeingData;
    }

    @Override
    public void setWellbeingData(WellbeingData data) {
        this.wellbeingData = data;
    }

    @Override
    public SleepData sleepData() {
        return this.sleepData;
    }

    @Override
    public void setSleepData(SleepData data) {
        this.sleepData = data;
    }

    @Override
    public CustomFoodData getRealFoodData() {
        if (this.field_7493 instanceof CustomFoodData) {
            return (CustomFoodData)this.field_7493;
        }
        return null;
    }
}

