/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.google.common.collect.Maps;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.needs.Temperature;
import com.stereowalker.survive.hooks.SurviveHooks;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.SurviveData;
import com.stereowalker.survive.needs.TemperatureUtil;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import com.stereowalker.survive.world.temperature.TemperatureModifier;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class TemperatureData
extends SurviveData
implements Temperature {
    private double temperatureLevel = 0.0;
    private double displayTemperature = 0.0;
    private int temperatureTimer;
    private double targetTemperature = 0.0;
    private int hypTimer = 0;
    private Map<class_2960, TemperatureModifier> temperatureModifiers = Maps.newHashMap();
    private Map<TemperatureModifier.ContributingFactor, Double> factors = Maps.newHashMap();

    public TemperatureData() {
        this.hypTimer = Survive.TEMPERATURE_CONFIG.tempGrace;
        this.temperatureLevel = 37.0;
    }

    public void addHeat(float heatLevel, double max) {
        this.temperatureLevel = Math.min(this.temperatureLevel + (double)heatLevel, max);
    }

    public void addCold(float coldLevel, double max) {
        this.temperatureLevel = Math.max(this.temperatureLevel - (double)coldLevel, max);
    }

    private boolean addTemperature(class_3222 player, double temperature) {
        if (Survive.TEMPERATURE_CONFIG.enabled) {
            if (player.field_13974.method_14267()) {
                double defaultT = 37.0;
                double maxHeat1 = TemperatureUtil.firstHeat((class_1657)player);
                double maxHeat2 = TemperatureUtil.secondHeat((class_1657)player);
                double maxHeat3 = TemperatureUtil.maxHeat((class_1657)player);
                double maxCold1 = TemperatureUtil.firstCold((class_1657)player);
                double maxCold2 = TemperatureUtil.secondCold((class_1657)player);
                double maxCold3 = TemperatureUtil.maxCold((class_1657)player);
                this.temperatureLevel = this.temperatureLevel > defaultT && this.temperatureLevel <= maxHeat1 ? (temperature < 0.0 ? (this.temperatureLevel += temperature * 1.5) : (this.temperatureLevel += temperature)) : (this.temperatureLevel > maxHeat1 && this.temperatureLevel <= maxHeat2 ? (temperature < 0.0 ? (this.temperatureLevel += temperature) : (this.temperatureLevel += temperature / 10.0)) : (this.temperatureLevel > maxHeat2 && this.temperatureLevel <= maxHeat3 ? (temperature < 0.0 ? (this.temperatureLevel += temperature / 10.0) : (this.temperatureLevel += temperature / 100.0)) : (this.temperatureLevel > maxHeat3 ? (temperature < 0.0 ? (this.temperatureLevel += temperature / 100.0) : maxHeat3) : (this.temperatureLevel < defaultT && this.temperatureLevel >= maxCold1 ? (temperature > 0.0 ? (this.temperatureLevel += temperature * 1.5) : (this.temperatureLevel += temperature)) : (this.temperatureLevel < maxCold1 && this.temperatureLevel >= maxCold2 ? (temperature > 0.0 ? (this.temperatureLevel += temperature) : (this.temperatureLevel += temperature / 10.0)) : (this.temperatureLevel < maxCold2 && this.temperatureLevel >= maxCold3 ? (temperature > 0.0 ? (this.temperatureLevel += temperature / 10.0) : (this.temperatureLevel += temperature / 100.0)) : (this.temperatureLevel < maxCold3 ? (temperature < 0.0 ? (this.temperatureLevel += temperature / 100.0) : maxCold3) : (this.temperatureLevel += temperature))))))));
                return true;
            }
        } else {
            this.temperatureLevel = 37.0;
        }
        return false;
    }

    public void addModifier(TemperatureModifier modifier) {
        if (!this.temperatureModifiers.containsKey(modifier.getId())) {
            this.temperatureModifiers.put(modifier.getId(), modifier);
        }
    }

    public TemperatureModifier getOrCreateModifier(class_2960 location) {
        if (!this.temperatureModifiers.containsKey(location)) {
            this.addModifier(new TemperatureModifier(location, 0.0));
        }
        return this.temperatureModifiers.get(location);
    }

    public static void setTemperatureModifier(class_1309 entity, String id, double value, TemperatureModifier.ContributingFactor factor) {
        TemperatureData.setTemperatureModifier(entity, VersionHelper.toLoc((String)id), value, factor);
    }

    public static void setTemperatureModifier(class_1309 entity, class_2960 id, double value, TemperatureModifier.ContributingFactor factor) {
        TemperatureData temp = ((IRealisticEntity)entity).temperatureData();
        TemperatureModifier mod = SurviveHooks.getTemperatureModifer(entity, new TemperatureModifier(id, value, factor));
        temp.getOrCreateModifier(id).setMod(mod.getMod()).setFactor(mod.getFactor());
    }

    @Override
    public void tick(class_1657 player) {
        double div;
        double maxTemp;
        double tempLocation;
        double calculatedTarget = 37.0;
        Arrays.asList(TemperatureModifier.ContributingFactor.values()).forEach(f -> this.factors.put((TemperatureModifier.ContributingFactor)((Object)f), 0.0));
        for (TemperatureModifier modifier : this.temperatureModifiers.values()) {
            calculatedTarget += modifier.getMod();
            this.factors.put(modifier.getFactor(), this.factors.get((Object)modifier.getFactor()) + modifier.getMod());
        }
        this.targetTemperature = calculatedTarget;
        double mod = (this.targetTemperature - this.temperatureLevel) * Survive.TEMPERATURE_CONFIG.tempChangeSpeed;
        if (player instanceof class_3222) {
            this.addTemperature((class_3222)player, mod);
        }
        if ((tempLocation = this.temperatureLevel - 37.0) > 0.0) {
            maxTemp = 0.0;
            if (player.method_5996(SAttributes.HEAT_RESISTANCE.holder()) != null) {
                maxTemp = player.method_45325(SAttributes.HEAT_RESISTANCE.holder());
            }
            div = tempLocation / maxTemp;
            this.displayTemperature = class_3532.method_15350((double)div, (double)0.0, (double)1.4444444444444444);
        }
        if (tempLocation < 0.0) {
            maxTemp = 0.0;
            if (player.method_5996(SAttributes.COLD_RESISTANCE.holder()) != null) {
                maxTemp = player.method_45325(SAttributes.COLD_RESISTANCE.holder());
            }
            div = tempLocation / maxTemp;
            this.displayTemperature = class_3532.method_15350((double)div, (double)-1.4444444444444444, (double)0.0);
        }
        if (!player.method_7337() && !player.method_7325() && Survive.TEMPERATURE_CONFIG.useLegacyTemperatureSystem) {
            double maxHeat1 = TemperatureUtil.firstHeat(player);
            double maxHeat2 = TemperatureUtil.secondHeat(player);
            double maxHeat3 = TemperatureUtil.maxHeat(player);
            double maxCold1 = TemperatureUtil.firstCold(player);
            double maxCold2 = TemperatureUtil.secondCold(player);
            double maxCold3 = TemperatureUtil.maxCold(player);
            if (this.temperatureLevel > maxHeat1 || this.temperatureLevel < maxCold1) {
                if (this.hypTimer > 0) {
                    --this.hypTimer;
                } else if (this.hypTimer == 0) {
                    // empty if block
                }
            } else if (this.hypTimer < Survive.TEMPERATURE_CONFIG.tempGrace) {
                ++this.hypTimer;
            }
        }
    }

    @Override
    public void read(class_2487 compound) {
        if (compound.method_10573("temperatureLevel", 99)) {
            this.temperatureLevel = compound.method_10574("temperatureLevel");
            this.targetTemperature = compound.method_10574("targetTemperature");
            this.temperatureTimer = compound.method_10550("temperatureTickTimer");
            this.displayTemperature = compound.method_10574("displayTemperature");
            this.hypTimer = compound.method_10550("hypTimer");
            class_2499 modifiers = compound.method_10554("modifiers", 10);
            HashMap temperatureModifiers = Maps.newHashMap();
            for (int i = 0; i < modifiers.size(); ++i) {
                class_2487 nbt = modifiers.method_10602(i);
                TemperatureModifier modifier = new TemperatureModifier();
                modifier.read(nbt);
                temperatureModifiers.put(modifier.getId(), modifier);
            }
            this.temperatureModifiers = temperatureModifiers;
        }
    }

    @Override
    public void write(class_2487 compound, boolean reducedData) {
        compound.method_10549("temperatureLevel", this.temperatureLevel);
        compound.method_10549("targetTemperature", this.targetTemperature);
        compound.method_10569("temperatureTickTimer", this.temperatureTimer);
        compound.method_10549("displayTemperature", this.displayTemperature);
        compound.method_10569("hypTimer", this.hypTimer);
        class_2499 modifiers = new class_2499();
        for (TemperatureModifier modifier : this.temperatureModifiers.values()) {
            modifiers.add((Object)modifier.write(new class_2487()));
        }
        compound.method_10566("modifiers", (class_2520)modifiers);
    }

    public double getTemperatureLevel() {
        return this.temperatureLevel;
    }

    public float getCelcius() {
        int temp = (int)(this.temperatureLevel * 100.0);
        return (float)temp / 100.0f;
    }

    public float getFahrenheit() {
        float rawFTemp = this.getCelcius() * 1.8f + 32.0f;
        int fTemp = (int)(rawFTemp * 100.0f);
        return (float)fTemp / 100.0f;
    }

    @Override
    public double getDisplayTemperature() {
        return this.displayTemperature;
    }

    public double getTargetTemperature() {
        return this.targetTemperature;
    }

    public void setTemperatureLevel(int temperatureLevelIn) {
        this.temperatureLevel = temperatureLevelIn;
    }

    @Override
    public void save(class_1309 player) {
    }

    @Override
    public boolean shouldTick() {
        return Survive.TEMPERATURE_CONFIG.enabled;
    }
}

