/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.network.protocol.game;

import com.google.common.collect.ImmutableMap;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.api.json.JsonHolder;
import com.stereowalker.survive.json.ArmorJsonHolder;
import com.stereowalker.survive.json.BiomeJsonHolder;
import com.stereowalker.survive.json.FluidJsonHolder;
import com.stereowalker.survive.json.FoodJsonHolder;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.unionlib.network.protocol.game.ClientboundUnionPacket;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9129;

public class ClientboundDataTransferPacket
extends ClientboundUnionPacket {
    private class_2960 stat;
    private JsonHolder settings;
    private boolean clear;
    public static class_2960 id = VersionHelper.toLoc((String)"survive", (String)"clientbound_data_transfer");

    public ClientboundDataTransferPacket(class_2960 statIn, JsonHolder settingsIn, boolean clear) {
        super(null);
        this.stat = statIn;
        this.settings = settingsIn;
        this.clear = clear;
    }

    public ClientboundDataTransferPacket(class_9129 byteBuf) {
        super(byteBuf);
        this.stat = byteBuf.method_10810();
        String cl = byteBuf.method_19772();
        this.settings = JsonHolder.deserialize(byteBuf.method_10798(), (Class)JsonHolder.HOLD.get((Object)cl));
        this.clear = byteBuf.readBoolean();
    }

    public void encode(class_2540 byteBuf) {
        byteBuf.method_10812(this.stat);
        byteBuf.method_10814(this.settings.getClass().descriptorString());
        byteBuf.method_10794((class_2520)this.settings.serialize());
        byteBuf.method_52964(this.clear);
    }

    public boolean runOnClient(class_1657 sender) {
        HashMap<class_2960, ArmorJsonHolder> statMap;
        JsonHolder jsonHolder = this.settings;
        if (jsonHolder instanceof ArmorJsonHolder) {
            ArmorJsonHolder armor = (ArmorJsonHolder)jsonHolder;
            if (this.clear) {
                Survive.getInstance().getLogger().info("Clearing Client Side Armor Data");
                DataMaps.Client.armor = ImmutableMap.of();
            }
            statMap = new HashMap();
            statMap.putAll((Map<class_2960, ArmorJsonHolder>)DataMaps.Client.armor);
            statMap.put(this.stat, armor);
            DataMaps.Client.armor = ImmutableMap.copyOf(statMap);
        }
        if ((statMap = this.settings) instanceof FluidJsonHolder) {
            FluidJsonHolder fluid = (FluidJsonHolder)((Object)statMap);
            if (this.clear) {
                Survive.getInstance().getLogger().info("Clearing Client Side Fluid Data");
                DataMaps.Client.fluid = ImmutableMap.of();
            }
            statMap = new HashMap<class_2960, ArmorJsonHolder>();
            statMap.putAll((Map<class_2960, ArmorJsonHolder>)DataMaps.Client.fluid);
            statMap.put(this.stat, (ArmorJsonHolder)((Object)fluid));
            DataMaps.Client.fluid = ImmutableMap.copyOf(statMap);
        }
        if ((statMap = this.settings) instanceof BiomeJsonHolder) {
            BiomeJsonHolder biome = (BiomeJsonHolder)((Object)statMap);
            if (this.clear) {
                Survive.getInstance().getLogger().info("Clearing Client Side Biome Data");
                DataMaps.Client.biome = ImmutableMap.of();
            }
            statMap = new HashMap();
            statMap.putAll((Map<class_2960, ArmorJsonHolder>)DataMaps.Client.biome);
            statMap.put(this.stat, (ArmorJsonHolder)((Object)biome));
            DataMaps.Client.biome = ImmutableMap.copyOf(statMap);
        }
        if ((statMap = this.settings) instanceof FoodJsonHolder) {
            FoodJsonHolder consummable = (FoodJsonHolder)((Object)statMap);
            if (this.clear) {
                Survive.getInstance().getLogger().info("Clearing Client Side Consummable Data");
                DataMaps.Client.consummableItem = ImmutableMap.of();
            }
            statMap = new HashMap();
            statMap.putAll((Map<class_2960, ArmorJsonHolder>)DataMaps.Client.consummableItem);
            statMap.put(this.stat, (ArmorJsonHolder)((Object)consummable));
            DataMaps.Client.consummableItem = ImmutableMap.copyOf(statMap);
        }
        return true;
    }

    public class_2960 id() {
        return id;
    }
}

