/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.resource;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.json.BiomeJsonHolder;
import com.stereowalker.unionlib.resource.IResourceReloadListener;
import com.stereowalker.unionlib.util.VersionHelper;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

public class BiomeDataManager
implements IResourceReloadListener<Map<class_2960, BiomeJsonHolder>> {
    public CompletableFuture<Map<class_2960, BiomeJsonHolder>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<class_2960, BiomeJsonHolder> drinkMap = new HashMap<class_2960, BiomeJsonHolder>();
            for (Map.Entry resource : manager.method_14488("survive_modifiers/biomes", s -> s.toString().endsWith(".json")).entrySet()) {
                class_2960 blockId = VersionHelper.toLoc((String)((class_2960)resource.getKey()).method_12836(), (String)((class_2960)resource.getKey()).method_12832().replace("survive_modifiers/biomes/", "").replace(".json", ""));
                try {
                    InputStream stream = ((class_3298)resource.getValue()).method_14482();
                    try (InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        BiomeJsonHolder biomeData = new BiomeJsonHolder(blockId, object);
                        drinkMap.put(blockId, biomeData);
                        Survive.getInstance().getLogger().info("Registered modifier for the biome \"" + String.valueOf(blockId) + "\"");
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    Survive.getInstance().getLogger().warn("Error reading the biomes temperature modifier for the biome " + String.valueOf(blockId) + "!", (Throwable)e);
                }
            }
            return drinkMap;
        });
    }

    public CompletableFuture<Void> apply(Map<class_2960, BiomeJsonHolder> data, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (class_2960 drinkId : data.keySet()) {
                Survive.registerBiomeTemperatures(drinkId, (BiomeJsonHolder)data.get(drinkId));
            }
        });
    }

    public class_2960 id() {
        return VersionHelper.toLoc((String)"survive:biome_data");
    }
}

