/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.resource;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.json.FluidJsonHolder;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.unionlib.resource.IResourceReloadListener;
import com.stereowalker.unionlib.util.VersionHelper;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_7923;

public class FluidDataManager
implements IResourceReloadListener<Map<class_2960, FluidJsonHolder>> {
    public CompletableFuture<Map<class_2960, FluidJsonHolder>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<class_2960, FluidJsonHolder> drinkMap = new HashMap<class_2960, FluidJsonHolder>();
            for (Map.Entry resource : manager.method_14488("survive_modifiers/fluids", s -> s.toString().endsWith(".json")).entrySet()) {
                class_2960 drinkId = VersionHelper.toLoc((String)((class_2960)resource.getKey()).method_12836(), (String)((class_2960)resource.getKey()).method_12832().replace("survive_modifiers/fluids/", "").replace(".json", ""));
                if (class_7923.field_41173.method_10250(drinkId)) {
                    try (InputStream stream = ((class_3298)resource.getValue()).method_14482();
                         InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        FluidJsonHolder drinkData = new FluidJsonHolder(drinkId, object);
                        Survive.getInstance().getLogger().info("Found fluid data for " + String.valueOf(drinkId));
                        drinkMap.put(drinkId, drinkData);
                    }
                    catch (Exception e) {
                        Survive.getInstance().getLogger().warn("Error reading fluid data " + String.valueOf(drinkId) + "!", (Throwable)e);
                    }
                    continue;
                }
                Survive.getInstance().getLogger().warn("No such fluid exists with the id " + String.valueOf(drinkId) + "!");
            }
            return drinkMap;
        });
    }

    public CompletableFuture<Void> apply(Map<class_2960, FluidJsonHolder> data, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (class_2960 drinkId : data.keySet()) {
                DataMaps.Server.fluid.put(drinkId, (FluidJsonHolder)data.get(drinkId));
            }
        });
    }

    public class_2960 id() {
        return VersionHelper.toLoc((String)"survive:fluid_data");
    }
}

