/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.level.block.entity;

import com.stereowalker.survive.world.inventory.SaltBoxMenu;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.component.SDataComponents;
import com.stereowalker.survive.world.level.block.SaltBoxBlock;
import com.stereowalker.survive.world.level.block.entity.SBlockEntityType;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_5561;
import net.minecraft.class_7225;

public class SaltBoxBlockEntity
extends class_2621 {
    private class_2371<class_1799> items = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    private final class_5561 openersCounter = new class_5561(){

        protected void method_31681(class_1937 p_155062_, class_2338 p_155063_, class_2680 p_155064_) {
            SaltBoxBlockEntity.this.playSound(p_155064_, class_3417.field_17604);
            SaltBoxBlockEntity.this.updateBlockState(p_155064_, true);
        }

        protected void method_31683(class_1937 p_155072_, class_2338 p_155073_, class_2680 p_155074_) {
            SaltBoxBlockEntity.this.playSound(p_155074_, class_3417.field_17603);
            SaltBoxBlockEntity.this.updateBlockState(p_155074_, false);
        }

        protected void method_31682(class_1937 p_155066_, class_2338 p_155067_, class_2680 p_155068_, int p_155069_, int p_155070_) {
        }

        protected boolean method_31679(class_1657 p_155060_) {
            if (p_155060_.field_7512 instanceof SaltBoxMenu) {
                class_1263 container = ((SaltBoxMenu)p_155060_.field_7512).getContainer();
                return container == SaltBoxBlockEntity.this;
            }
            return false;
        }
    };
    long lastGameTickUpdated;
    int[] saltSludge = new int[27];
    private static final int COLS = 9;
    private static final int ROWS = 3;
    private static final int[][] OFFSETS = new int[][]{{-1, -1}, {0, -1}, {1, -1}, {-1, 0}, {1, 0}, {-1, 1}, {0, 1}, {1, 1}};

    public SaltBoxBlockEntity(class_2338 pos, class_2680 blockState) {
        super(SBlockEntityType.SALT_BOX, pos, blockState);
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        if (!this.method_54872(tag)) {
            class_1262.method_5426((class_2487)tag, this.items, (class_7225.class_7874)registries);
        }
        tag.method_10544("lastGameTickUpdated", this.lastGameTickUpdated);
        for (int i = 0; i < 27; ++i) {
            tag.method_10544("sludge" + i, (long)this.saltSludge[i]);
        }
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_54871(tag)) {
            class_1262.method_5429((class_2487)tag, this.items, (class_7225.class_7874)registries);
        }
        this.lastGameTickUpdated = tag.method_10537("lastGameTickUpdated");
        for (int i = 0; i < 27; ++i) {
            this.saltSludge[i] = tag.method_10550("sludge" + i);
        }
    }

    public int method_5439() {
        return 27;
    }

    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> items) {
        this.items = items;
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.barrel");
    }

    protected class_1703 method_5465(int id, class_1661 player) {
        return new SaltBoxMenu(id, player, (class_1263)this, this.data());
    }

    public void method_5435(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.openersCounter.method_31684(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void method_5432(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.openersCounter.method_31685(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void recheckOpen() {
        if (!this.field_11865) {
            this.openersCounter.method_31686(this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    void updateBlockState(class_2680 state, boolean open) {
        this.field_11863.method_8652(this.method_11016(), (class_2680)state.method_11657((class_2769)SaltBoxBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    void playSound(class_2680 state, class_3414 sound) {
        class_2382 vec3i = ((class_2350)state.method_11654((class_2769)SaltBoxBlock.FACING)).method_10163();
        double d0 = (double)this.field_11867.method_10263() + 0.5 + (double)vec3i.method_10263() / 2.0;
        double d1 = (double)this.field_11867.method_10264() + 0.5 + (double)vec3i.method_10264() / 2.0;
        double d2 = (double)this.field_11867.method_10260() + 0.5 + (double)vec3i.method_10260() / 2.0;
        this.field_11863.method_43128(null, d0, d1, d2, sound, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
    }

    public class_3913 data() {
        return new class_3913(){

            public void method_17391(int pIndex, int pValue) {
                SaltBoxBlockEntity.this.saltSludge[pIndex] = pValue;
            }

            public int method_17389() {
                return SaltBoxBlockEntity.this.saltSludge.length;
            }

            public int method_17390(int pIndex) {
                return SaltBoxBlockEntity.this.saltSludge[pIndex];
            }
        };
    }

    public void massivelyExtendLifespan() {
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 stack = (class_1799)this.items.get(i);
            if (stack.method_7909() != SItems.SEA_SALT || this.saltSludge[i] > 0) continue;
            this.saltSludge[i] = 1000;
            stack.method_7934(1);
        }
        long gameTime = this.field_11863.method_8510();
        if (this.lastGameTickUpdated == 0L) {
            this.lastGameTickUpdated = gameTime;
        }
        long timeSinceLastOpened = gameTime - this.lastGameTickUpdated;
        this.lastGameTickUpdated = gameTime;
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 stack = (class_1799)this.items.get(i);
            if (!SDataComponents.FOOD_STATUS_D.hasData(stack)) continue;
            int sidesCovered = 0;
            for (int n : SaltBoxBlockEntity.get8Neighbors(i)) {
                if (n < 0 || SDataComponents.FOOD_STATUS_D.hasData((class_1799)this.items.get(n)) || this.saltSludge[n] <= 0) continue;
                ++sidesCovered;
                int n2 = n;
                this.saltSludge[n2] = this.saltSludge[n2] - 1;
            }
            if (sidesCovered <= 0) continue;
            float perc = 1.0E-4f * (float)sidesCovered + 0.9991f;
            float efficiency = (float)timeSinceLastOpened * perc;
            if (timeSinceLastOpened <= 2L) {
                efficiency = 1.0f;
            }
            float eff = efficiency;
            float salt = (float)timeSinceLastOpened * ((float)sidesCovered / 8.0f / 96.0f);
            SDataComponents.FOOD_STATUS_D.editData(stack, food_status -> food_status.extendTime(eff).increaseSalt(salt / 8.0f));
        }
    }

    public void method_5447(int pIndex, class_1799 pStack) {
        System.out.println("Index " + pIndex);
        int[] saltSlots = new int[]{0, 8};
        super.method_5447(pIndex, pStack);
    }

    public static int[] get8Neighbors(int index) {
        int[] neighbors = new int[8];
        if (index >= 0 && index < 27) {
            int row = index / 9;
            int col = index % 9;
            for (int i = 0; i < OFFSETS.length; ++i) {
                int dx = OFFSETS[i][0];
                int dy = OFFSETS[i][1];
                int nr = row + dy;
                int nc = col + dx;
                neighbors[i] = nr < 0 || nr >= 3 || nc < 0 || nc >= 9 ? -1 : nr * 9 + nc;
            }
        }
        return neighbors;
    }
}

