/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.temperature.conditions;

import com.google.gson.JsonObject;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeCondition;
import com.stereowalker.survive.world.temperature.conditions.TemperatureChangeInstance;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3486;

public class UnderwaterCondition
extends TemperatureChangeCondition<Instance> {
    @Override
    public Instance createInstance(JsonObject object) {
        float temperatureIn = 0.0f;
        int depthIn = 0;
        String operationIn = "";
        if (object.has("temperature") && object.get("temperature").isJsonPrimitive()) {
            temperatureIn = object.get("temperature").getAsFloat();
        }
        if (object.has("depth") && object.get("depth").isJsonPrimitive()) {
            depthIn = object.get("depth").getAsInt();
        }
        if (object.has("operation") && object.get("operation").isJsonPrimitive()) {
            operationIn = object.get("operation").getAsString();
        }
        return new Instance(temperatureIn, depthIn, operationIn);
    }

    @Override
    public Instance createInstance(class_2487 nbt) {
        float temperatureIn = nbt.method_10583("temperature");
        int depthIn = nbt.method_10550("depth");
        String operationIn = nbt.method_10558("operation");
        return new Instance(temperatureIn, depthIn, operationIn);
    }

    static class Instance
    extends TemperatureChangeInstance {
        private int depth;
        private String operation;

        public Instance(float temperatureIn, int depthIn, String operationIn) {
            super(temperatureIn);
            this.depth = depthIn;
            this.operation = operationIn;
        }

        @Override
        public boolean shouldChangeTemperature(class_1657 player) {
            boolean flag = true;
            int i = 0;
            while (flag) {
                if (player.method_37908().method_8316(player.method_24515().method_10086(i)).method_15767(class_3486.field_15517)) {
                    ++i;
                    continue;
                }
                flag = false;
            }
            if (player.method_5799()) {
                if (this.depth > 0) {
                    if (this.operation.equals("y_=")) {
                        return player.method_23318() == (double)this.depth;
                    }
                    if (this.operation.equals("y_>=")) {
                        return player.method_23318() >= (double)this.depth;
                    }
                    if (this.operation.equals("y_<=")) {
                        return player.method_23318() <= (double)this.depth;
                    }
                    if (this.operation.equals("y_>")) {
                        return player.method_23318() > (double)this.depth;
                    }
                    if (this.operation.equals("y_<")) {
                        return player.method_23318() < (double)this.depth;
                    }
                    if (this.operation.equals("water_=")) {
                        return i == this.depth;
                    }
                    if (this.operation.equals("water_>=")) {
                        return i >= this.depth;
                    }
                    if (this.operation.equals("water_<=")) {
                        return i <= this.depth;
                    }
                    if (this.operation.equals("water_>")) {
                        return i > this.depth;
                    }
                    if (this.operation.equals("water_<")) {
                        return i < this.depth;
                    }
                    return i <= this.depth;
                }
                return true;
            }
            return false;
        }

        @Override
        public class_2487 serialize() {
            class_2487 nbt = new class_2487();
            nbt.method_10548("temperature", this.getTemperature());
            nbt.method_10569("depth", this.depth);
            nbt.method_10582("operation", this.operation);
            return nbt;
        }

        @Override
        public class_2561 getAdditionalContext() {
            return class_2561.method_43471((String)"temperature_context.underwater");
        }
    }
}

