/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.core;

import com.stereowalker.survive.Survive;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SurviveEntityStats {
    public static int getWetTime(LivingEntity entity) {
        if (SurviveEntityStats.getModNBT((Entity)entity) != null && SurviveEntityStats.getModNBT((Entity)entity).contains(SurviveEntityStats.append("WetTime"))) {
            return SurviveEntityStats.getModNBT((Entity)entity).getInt(SurviveEntityStats.append("WetTime"));
        }
        return 0;
    }

    public static void setWetTime(LivingEntity entity, int wetTime) {
        SurviveEntityStats.getModNBT((Entity)entity).putInt(SurviveEntityStats.append("WetTime"), wetTime);
    }

    public static boolean addWetTime(LivingEntity entity, int wetTime) {
        CompoundTag compound = entity.getPersistentData();
        if (compound != null) {
            SurviveEntityStats.setWetTime(entity, SurviveEntityStats.getWetTime(entity) + wetTime);
            if (SurviveEntityStats.getWetTime(entity) < 0) {
                SurviveEntityStats.setWetTime(entity, 0);
            }
            if (SurviveEntityStats.getWetTime(entity) > 3600) {
                SurviveEntityStats.setWetTime(entity, 3600);
            }
            return true;
        }
        return false;
    }

    public static void addStatsOnSpawn(Player player) {
        if (player != null) {
            CompoundTag compound = SurviveEntityStats.getOrCreateModNBT((Entity)player);
            String name = player.getScoreboardName();
            if (player.isAlive() && !compound.contains(SurviveEntityStats.append("WetTime"))) {
                SurviveEntityStats.setWetTime((LivingEntity)player, 0);
                Survive.getInstance().debug("Set " + name + "'s wet time to " + SurviveEntityStats.getWetTime((LivingEntity)player));
            }
        }
    }

    private static String append(String string) {
        return "survive:" + string;
    }

    public static String getModDataString() {
        return "survive:PlayerData";
    }

    public static CompoundTag getModNBT(Entity entity) {
        return entity.getPersistentData().getCompound(SurviveEntityStats.getModDataString());
    }

    public static CompoundTag getOrCreateModNBT(Entity entity) {
        if (!entity.getPersistentData().contains(SurviveEntityStats.getModDataString(), 10)) {
            entity.getPersistentData().put(SurviveEntityStats.getModDataString(), (Tag)new CompoundTag());
        }
        return entity.getPersistentData().getCompound(SurviveEntityStats.getModDataString());
    }

    public static void setModNBT(CompoundTag nbt, Entity entity) {
        entity.getPersistentData().put(SurviveEntityStats.getModDataString(), (Tag)nbt);
    }
}

