/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.needs.SurviveData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class NutritionData
extends SurviveData {
    private Nutrient carb = new Nutrient(this, 0, 0.0f);
    private Nutrient protein = new Nutrient(this, 0, 0.0f);
    private Nutrient fat = new Nutrient(this, 0, 0.0f);
    private int maintenanceTicks;

    public NutritionData() {
        this.carb = new Nutrient(this, 1000, 1000.0f);
        this.protein = new Nutrient(this, 1000, 1000.0f);
        this.fat = new Nutrient(this, 1000, 1000.0f);
    }

    public Nutrient carbs() {
        return this.carb;
    }

    public Nutrient protein() {
        return this.protein;
    }

    public Nutrient fat() {
        return this.fat;
    }

    @Override
    public void tick(Player player) {
        this.carb.tick(player);
        this.protein.tick(player);
        this.fat.tick(player);
        float proteinMod = 1.0f;
        if (this.protein.level() > 2000) {
            proteinMod = Survive.CONFIG.idle_protein_tick_rate_high;
        } else if (this.protein.level() < 1000) {
            proteinMod = Survive.CONFIG.idle_protein_tick_rate_low;
        }
        ++this.maintenanceTicks;
        if ((float)this.maintenanceTicks > (float)Survive.CONFIG.idle_protein_tick_rate * proteinMod) {
            this.protein.remove(1);
            this.maintenanceTicks = 0;
        }
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.contains("carbLevel", 99)) {
            this.carb.level = new MutableInt(compound.getInt("carbLevel"));
            this.carb.timer = new MutableInt(compound.getInt("carbTimer"));
            this.carb.stack = new MutableFloat(compound.getFloat("carbStack"));
            this.protein.level = new MutableInt(compound.getInt("proteinLevel"));
            this.protein.timer = new MutableInt(compound.getInt("proteinTimer"));
            this.protein.stack = new MutableFloat(compound.getFloat("proteinStack"));
            this.fat.level = new MutableInt(compound.getInt("fatLevel"));
            this.fat.timer = new MutableInt(compound.getInt("fatTimer"));
            this.fat.stack = new MutableFloat(compound.getFloat("fatStack"));
            this.maintenanceTicks = compound.getInt("maintenanceTicks");
        }
    }

    @Override
    public void write(CompoundTag compound, boolean reducedData) {
        compound.putInt("carbLevel", this.carb.level.getValue().intValue());
        if (!reducedData) {
            compound.putInt("carbTimer", this.carb.timer.getValue().intValue());
            compound.putFloat("carbStack", this.carb.stack.getValue().floatValue());
        }
        compound.putInt("proteinLevel", this.protein.level());
        if (!reducedData) {
            compound.putInt("proteinTimer", this.protein.timer.getValue().intValue());
            compound.putFloat("proteinStack", this.protein.stack.getValue().floatValue());
        }
        compound.putInt("fatLevel", this.fat.level());
        if (!reducedData) {
            compound.putInt("fatTimer", this.fat.timer.getValue().intValue());
            compound.putFloat("fatStack", this.fat.stack.getValue().floatValue());
        }
        if (!reducedData) {
            compound.putInt("maintenanceTicks", this.maintenanceTicks);
        }
    }

    @Override
    public void save(LivingEntity player) {
    }

    @Override
    public boolean shouldTick() {
        return Survive.CONFIG.nutrition_enabled;
    }

    public class Nutrient {
        private MutableInt level = new MutableInt(0);
        private MutableInt timer = new MutableInt(0);
        private MutableFloat stack = new MutableFloat(0.0f);

        public Nutrient(NutritionData this$0, int initialLevel, float initialStacks) {
            this.level = new MutableInt(initialLevel);
            this.stack = new MutableFloat(initialStacks);
        }

        public void add(float nut) {
            this.stack.add(Mth.clamp((float)nut, (float)-1000.0f, (float)3000.0f));
            if (this.stack.floatValue() > 3000.0f) {
                this.stack.setValue(3000.0f);
            }
        }

        public void remove(int nut) {
            this.level.subtract(nut);
        }

        public int level() {
            return this.level.intValue();
        }

        public void tick(Player player) {
            if (this.stack.getValue().floatValue() >= 300.0f && this.level.getValue() < 3000) {
                this.timer.increment();
                if (this.timer.getValue() > 200 && player.getFoodData().getFoodLevel() > 3) {
                    this.stack.subtract(300.0f);
                    this.level.add(300);
                    player.getFoodData().setFoodLevel(player.getFoodData().getFoodLevel() - 1);
                    this.timer.setValue(0);
                }
            } else {
                this.timer.setValue(0);
            }
        }
    }
}

