/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.needs;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.needs.SurviveData;
import com.stereowalker.survive.world.effect.SMobEffects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SleepData
extends SurviveData {
    private int awakeTimer = 0;

    public void addAwakeTime(ServerPlayer player, int awakeTime) {
        if (player.gameMode.isSurvival()) {
            this.awakeTimer = Math.max(0, this.awakeTimer + awakeTime);
        }
    }

    @Override
    public void tick(Player player) {
        ServerPlayer serverplayer = (ServerPlayer)player;
        Difficulty difficulty = player.level().getDifficulty();
        if (difficulty == Difficulty.PEACEFUL) {
            this.addAwakeTime(serverplayer, -1);
        } else if (player.isSleeping()) {
            this.addAwakeTime(serverplayer, -player.getSleepTimer());
        } else if (serverplayer.level().dimensionType().bedWorks()) {
            this.addAwakeTime(serverplayer, 1);
        }
        if (player.tickCount % 20 == 0) {
            this.addTiredEffect(serverplayer);
        }
    }

    public void addTiredEffect(ServerPlayer player) {
        if (this.tirednessAmplifier() >= 0 && !player.hasEffect(SMobEffects.ENERGIZED.holder())) {
            player.addEffect(new MobEffectInstance(SMobEffects.TIREDNESS.holder(), 200, Math.min(this.tirednessAmplifier(), Survive.CONFIG.tiredTimeStacks), false, false, true));
        }
    }

    public int tirednessAmplifier() {
        float extraTime = this.getAwakeTimer() - Survive.CONFIG.initialTiredTime;
        return Mth.floor((float)(extraTime / (float)Survive.CONFIG.tiredTimeStep));
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.contains("awakeTimer", 99)) {
            this.awakeTimer = compound.getInt("awakeTimer");
        }
    }

    @Override
    public void write(CompoundTag compound, boolean reducedData) {
        compound.putInt("awakeTimer", this.awakeTimer);
    }

    @Override
    public void save(LivingEntity player) {
    }

    @Override
    public boolean shouldTick() {
        return Survive.CONFIG.enable_sleep;
    }

    public int getAwakeTimer() {
        return this.awakeTimer;
    }

    public float getDaysAwake() {
        return (float)Mth.floor((float)((float)this.awakeTimer / 12000.0f)) * 0.5f;
    }

    public void setAwakeTimer(int awakeTimer) {
        this.awakeTimer = awakeTimer;
    }
}

