/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.network.protocol.game;

import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.unionlib.network.protocol.game.ClientboundUnionPacket;
import com.stereowalker.unionlib.util.VersionHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ClientboundSurvivalStatsPacket
extends ClientboundUnionPacket {
    private CompoundTag stats;
    private boolean legacyStats;
    public static ResourceLocation id = VersionHelper.toLoc((String)"survive", (String)"clientbound_survival_stats");

    public ClientboundSurvivalStatsPacket(CompoundTag statsIn, boolean legacyStats) {
        super(null);
        this.stats = statsIn;
        this.legacyStats = legacyStats;
    }

    public ClientboundSurvivalStatsPacket(ServerPlayer player, boolean legacyStats) {
        this(legacyStats ? SurviveEntityStats.getModNBT((Entity)player) : ClientboundSurvivalStatsPacket.tag((IRealisticEntity)player), legacyStats);
    }

    public static CompoundTag tag(IRealisticEntity player) {
        CompoundTag surviveData = new CompoundTag();
        surviveData.put("temperature", (Tag)player.temperatureData().write(true));
        surviveData.put("wellbeing", (Tag)player.wellbeingData().write(true));
        surviveData.put("nutrition", (Tag)player.nutritionData().write(true));
        surviveData.put("hygiene", (Tag)player.hygieneData().write(true));
        surviveData.put("stamina", (Tag)player.staminaData().write(true));
        surviveData.put("sleep", (Tag)player.sleepData().write(true));
        surviveData.put("water", (Tag)player.waterData().write(true));
        return surviveData;
    }

    public ClientboundSurvivalStatsPacket(RegistryFriendlyByteBuf byteBuf) {
        super(byteBuf);
        this.stats = byteBuf.readNbt();
        this.legacyStats = byteBuf.readBoolean();
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.writeNbt((Tag)this.stats);
        byteBuf.writeBoolean(this.legacyStats);
    }

    public boolean runOnClient(Player sender) {
        if (this.legacyStats) {
            SurviveEntityStats.setModNBT(this.stats, (Entity)sender);
        } else {
            IRealisticEntity player = (IRealisticEntity)sender;
            if (this.stats.contains("temperature", 10)) {
                player.temperatureData().read(this.stats.getCompound("temperature"));
            }
            if (this.stats.contains("wellbeing", 10)) {
                player.wellbeingData().read(this.stats.getCompound("wellbeing"));
            }
            if (this.stats.contains("nutrition", 10)) {
                player.nutritionData().read(this.stats.getCompound("nutrition"));
            }
            if (this.stats.contains("hygiene", 10)) {
                player.hygieneData().read(this.stats.getCompound("hygiene"));
            }
            if (this.stats.contains("stamina", 10)) {
                player.staminaData().read(this.stats.getCompound("stamina"));
            }
            if (this.stats.contains("sleep", 10)) {
                player.sleepData().read(this.stats.getCompound("sleep"));
            }
            if (this.stats.contains("water", 10)) {
                player.waterData().read(this.stats.getCompound("water"));
            }
        }
        return true;
    }

    public ResourceLocation id() {
        return id;
    }
}

