/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.network.protocol.game;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.json.BiomeJsonHolder;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.WaterData;
import com.stereowalker.survive.network.protocol.game.ClientboundDrinkSoundPacket;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.unionlib.network.protocol.game.ServerboundUnionPacket;
import com.stereowalker.unionlib.util.VersionHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.WaterFluid;

public class ServerboundInteractWithWaterPacket
extends ServerboundUnionPacket {
    private BlockPos pos;
    private float addThirst;
    private double waterAmount;
    private double hydrationAmount;
    private InteractionHand hand;
    public static ResourceLocation id = VersionHelper.toLoc((String)"survive", (String)"serverbound_interact_with_water");

    public ServerboundInteractWithWaterPacket(BlockPos pos, float addThirst, double waterAmount, double hydrationAmount, InteractionHand hand) {
        super(null);
        this.pos = pos;
        this.addThirst = addThirst;
        this.waterAmount = waterAmount;
        this.hydrationAmount = hydrationAmount;
        this.hand = hand;
    }

    public ServerboundInteractWithWaterPacket(BlockPos pos, float addThirst, double waterAmount, InteractionHand hand) {
        this(pos, addThirst, waterAmount, 0.0, hand);
    }

    public ServerboundInteractWithWaterPacket(RegistryFriendlyByteBuf packetBuffer) {
        super(packetBuffer);
        this.pos = packetBuffer.readBlockPos();
        this.addThirst = packetBuffer.readFloat();
        this.hand = (InteractionHand)packetBuffer.readEnum(InteractionHand.class);
        this.waterAmount = packetBuffer.readDouble();
        this.hydrationAmount = packetBuffer.readDouble();
    }

    public void encode(FriendlyByteBuf byteBuf) {
        byteBuf.writeBlockPos(this.pos);
        byteBuf.writeFloat(this.addThirst);
        byteBuf.writeEnum((Enum)this.hand);
        byteBuf.writeDouble(this.waterAmount);
        byteBuf.writeDouble(this.hydrationAmount);
    }

    public static boolean canDrinkThis(FluidState fluid, boolean canDrinkFlowingIfInfinite) {
        if (fluid.isSource()) {
            return true;
        }
        return fluid.getType() instanceof WaterFluid && canDrinkFlowingIfInfinite;
    }

    public static boolean shouldRemoveSource(FluidState fluid) {
        return (!(fluid.getType() instanceof WaterFluid) || Survive.THIRST_CONFIG.shouldRemoveSourceWaterBlock) && fluid.isSource();
    }

    public boolean handleOnServer(ServerPlayer sender) {
        if (Survive.THIRST_CONFIG.enabled) {
            ItemStack heldItem = sender.getItemInHand(this.hand);
            BlockState block = sender.level().getBlockState(this.pos);
            FluidState fluid = sender.level().getFluidState(this.pos);
            if (heldItem.isEmpty()) {
                WaterData waterStats;
                if (sender.isCrouching() && (waterStats = ((IRealisticEntity)sender).waterData()).needWater()) {
                    boolean flag = false;
                    if (block.getBlock() == Blocks.WATER_CAULDRON) {
                        LayeredCauldronBlock.lowerFillLevel((BlockState)block, (Level)sender.level(), (BlockPos)this.pos);
                        flag = true;
                    } else if (ServerboundInteractWithWaterPacket.canDrinkThis(fluid, Survive.THIRST_CONFIG.drinkFromFlowingWater)) {
                        if (ServerboundInteractWithWaterPacket.shouldRemoveSource(fluid)) {
                            sender.level().setBlockAndUpdate(this.pos, Blocks.AIR.defaultBlockState());
                        }
                        flag = true;
                    } else if (sender.level().isRainingAt(this.pos)) {
                        flag = true;
                    }
                    if (flag) {
                        int stacks = 0;
                        if (DataMaps.Server.biome.containsKey(((ResourceKey)sender.level().getBiome(this.pos).unwrapKey().get()).location())) {
                            BiomeJsonHolder biomeData = DataMaps.Server.biome.get(((ResourceKey)sender.level().getBiome(this.pos).unwrapKey().get()).location());
                            stacks = biomeData.getUnwellIntensity();
                        }
                        waterStats.drink((int)this.waterAmount, (float)this.hydrationAmount, stacks, WaterData.applyThirst((LivingEntity)sender, this.addThirst));
                    }
                    sender.level().playSound((Player)sender, this.pos, new ItemStack((ItemLike)Items.POTION).getDrinkingSound(), SoundSource.PLAYERS, 0.5f, sender.level().random.nextFloat() * 0.1f + 0.9f);
                    sender.swing(InteractionHand.MAIN_HAND);
                    new ClientboundDrinkSoundPacket(this.pos).send(sender);
                }
            } else if (heldItem.getItem() == Items.BOWL && ServerboundInteractWithWaterPacket.isValidContainerSource(this.waterAmount)) {
                heldItem.shrink(1);
                if (this.addThirst > 0.0f) {
                    sender.addItem(new ItemStack((ItemLike)SItems.WATER_BOWL));
                } else {
                    sender.addItem(new ItemStack((ItemLike)SItems.PURIFIED_WATER_BOWL));
                }
            }
        }
        return true;
    }

    public static boolean isValidContainerSource(double waterAmount) {
        return waterAmount >= 3.0;
    }

    public static boolean isValidStack(ItemStack stack) {
        return stack.getItem() == Items.BOWL || stack.isEmpty();
    }

    public ResourceLocation id() {
        return id;
    }
}

