/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.item;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.component.SDataComponents;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class CanteenItem
extends PotionItem {
    boolean isNetherite;

    public CanteenItem(Item.Properties properties, boolean isNetherite) {
        super(properties);
        this.isNetherite = isNetherite;
    }

    public static ItemStack addToCanteen(ItemStack stack, int drinks, PotionContents potion) {
        SDataComponents.DRINKS_LEFT_D.setData(stack, (Object)drinks);
        stack.set(DataComponents.POTION_CONTENTS, (Object)potion);
        return stack;
    }

    public static ItemStack addToCanteen(ItemStack stack, int drinks, Holder<Potion> potion) {
        return CanteenItem.addToCanteen(stack, drinks, new PotionContents(potion));
    }

    public ItemStack getDefaultInstance() {
        return CanteenItem.addToCanteen(super.getDefaultInstance(), Survive.THIRST_CONFIG.canteenFillAmount(this.isNetherite), (Holder<Potion>)Potions.WATER);
    }

    public void setDrinksLeft(ItemStack stack, int drinks) {
        SDataComponents.DRINKS_LEFT_D.setData(stack, (Object)Mth.clamp((int)drinks, (int)0, (int)Survive.THIRST_CONFIG.canteenFillAmount(this.isNetherite)));
    }

    public void decrementDrinks(ItemStack stack) {
        this.setDrinksLeft(stack, (Integer)SDataComponents.DRINKS_LEFT_D.getData(stack) - 1);
    }

    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving) {
        Player player;
        Player player2 = player = pEntityLiving instanceof Player ? (Player)pEntityLiving : null;
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, pStack);
        }
        if (!pLevel.isClientSide) {
            PotionContents potioncontents = (PotionContents)pStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            potioncontents.forEachEffect(mobeffectinstance -> {
                if (((MobEffect)mobeffectinstance.getEffect().value()).isInstantenous()) {
                    ((MobEffect)mobeffectinstance.getEffect().value()).applyInstantenousEffect((Entity)player, (Entity)player, pEntityLiving, mobeffectinstance.getAmplifier(), 1.0);
                } else {
                    pEntityLiving.addEffect(mobeffectinstance);
                }
            });
        }
        if (player != null) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if ((Integer)SDataComponents.DRINKS_LEFT_D.getData(pStack) <= 1) {
            if (player == null || !player.getAbilities().instabuild) {
                pStack.shrink(1);
            }
            if (player == null || !player.getAbilities().instabuild) {
                if (pStack.isEmpty()) {
                    return new ItemStack((ItemLike)SItems.CANTEEN);
                }
                if (player != null) {
                    player.getInventory().add(new ItemStack((ItemLike)SItems.CANTEEN));
                }
            }
        } else if (!((Integer)SDataComponents.DRINKS_LEFT_D.getData(pStack) <= 1 || player != null && player.getAbilities().instabuild)) {
            this.decrementDrinks(pStack);
        }
        pEntityLiving.gameEvent((Holder)GameEvent.DRINK);
        return pStack;
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        Player player = pContext.getPlayer();
        ItemStack itemstack = pContext.getItemInHand();
        PotionContents potioncontents = (PotionContents)itemstack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        BlockState blockstate = level.getBlockState(blockpos);
        if (pContext.getClickedFace() != Direction.DOWN && blockstate.is(BlockTags.CONVERTABLE_TO_MUD) && potioncontents.is(Potions.WATER)) {
            level.playSound(null, blockpos, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 1.0f, 1.0f);
            if ((Integer)SDataComponents.DRINKS_LEFT_D.getData(itemstack) <= 1) {
                player.setItemInHand(pContext.getHand(), ItemUtils.createFilledResult((ItemStack)itemstack, (Player)player, (ItemStack)new ItemStack((ItemLike)SItems.CANTEEN)));
            } else if ((Integer)SDataComponents.DRINKS_LEFT_D.getData(itemstack) > 1) {
                this.decrementDrinks(itemstack);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)itemstack.getItem()));
            if (!level.isClientSide) {
                ServerLevel serverlevel = (ServerLevel)level;
                for (int i = 0; i < 5; ++i) {
                    serverlevel.sendParticles((ParticleOptions)ParticleTypes.SPLASH, (double)blockpos.getX() + level.random.nextDouble(), (double)(blockpos.getY() + 1), (double)blockpos.getZ() + level.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                }
            }
            level.playSound(null, blockpos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, blockpos);
            level.setBlockAndUpdate(blockpos, Blocks.MUD.defaultBlockState());
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public String getDescriptionId(ItemStack pStack) {
        return this.getDescriptionId();
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack stack = pPlayer.getItemInHand(pHand);
        PotionContents potioncontents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (Survive.POTION_FLUID_MAP.containsKey(potioncontents.potion().get())) {
            BlockHitResult raytraceresult;
            BlockPos blockpos;
            if ((Integer)SDataComponents.DRINKS_LEFT_D.getData(stack) < Survive.THIRST_CONFIG.canteenFillAmount(this.isNetherite) && pLevel.getFluidState(blockpos = (raytraceresult = CanteenItem.getPlayerPOVHitResult((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY)).getBlockPos()).is(FluidTags.WATER) && Survive.POTION_FLUID_MAP.get(potioncontents.potion().get()).contains(pLevel.getFluidState(blockpos).getType())) {
                this.setDrinksLeft(stack, Survive.THIRST_CONFIG.canteenFillAmount(this.isNetherite));
            }
            pPlayer.startUsingItem(pHand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)pPlayer.getItemInHand(pHand));
        }
        return ItemUtils.startUsingInstantly((Level)pLevel, (Player)pPlayer, (InteractionHand)pHand);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.drinks_left").append(": " + String.valueOf(SDataComponents.DRINKS_LEFT_D.getData(pStack))).withStyle(ChatFormatting.AQUA));
        PotionContents potioncontents = (PotionContents)pStack.get(DataComponents.POTION_CONTENTS);
        if (potioncontents.potion().isPresent()) {
            if (Survive.POTION_FLUID_MAP.containsKey(potioncontents.potion().get())) {
                pTooltipComponents.add((Component)Component.translatable((String)Potion.getName((Optional)potioncontents.potion(), (String)(this.getDescriptionId() + ".effect."))).withStyle(ChatFormatting.YELLOW));
            } else {
                pTooltipComponents.add((Component)Component.translatable((String)Potion.getName((Optional)potioncontents.potion(), (String)"item.minecraft.potion.effect.")).withStyle(ChatFormatting.GOLD));
            }
        }
        if (potioncontents != null) {
            potioncontents.addPotionTooltip(pTooltipComponents::add, 1.0f, pContext.tickRate());
        }
    }
}

