/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.item;

import com.stereowalker.survive.world.item.component.SDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;

public class SoapItem
extends Item {
    public int soapEfficacy;
    public int soapMaxAmount;

    public SoapItem(Item.Properties properties, int soapEfficacy, int soapMaxAmount) {
        super(properties);
        this.soapEfficacy = soapEfficacy;
        this.soapMaxAmount = soapMaxAmount;
    }

    public static ItemStack addPropertiesToSoap(ItemStack stack, int drinks) {
        SDataComponents.SOAP_LEFT_D.setData(stack, (Object)drinks);
        return stack;
    }

    public ItemStack getDefaultInstance() {
        return SoapItem.addPropertiesToSoap(new ItemStack((ItemLike)this), this.soapMaxAmount);
    }

    public boolean isBottle() {
        return true;
    }

    public static int getSoapLeft(ItemStack stack) {
        return (Integer)SDataComponents.SOAP_LEFT_D.getData(stack);
    }

    public static void setSoapLeft(ItemStack stack, int drinks) {
        if (stack.getItem() instanceof SoapItem) {
            SDataComponents.SOAP_LEFT_D.setData(stack, (Object)Mth.clamp((int)drinks, (int)0, (int)((SoapItem)stack.getItem()).soapMaxAmount));
        }
    }

    public static void decrementSoap(ItemStack stack) {
        SoapItem.setSoapLeft(stack, (Integer)SDataComponents.SOAP_LEFT_D.getData(stack) - 1);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.soap_left", (Object[])new Object[]{SDataComponents.SOAP_LEFT_D.getData(pStack)}).withStyle(ChatFormatting.AQUA));
    }
}

