/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class WaterBottleItem
extends Item {
    public WaterBottleItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        Player entityplayer;
        Player player = entityplayer = entityLiving instanceof Player ? (Player)entityLiving : null;
        if (entityplayer == null || !entityplayer.getAbilities().instabuild) {
            stack.shrink(1);
        }
        if (entityplayer instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)entityplayer, stack);
        }
        if (entityplayer != null) {
            entityplayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (entityplayer == null || !entityplayer.getAbilities().instabuild) {
            if (stack.isEmpty()) {
                return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            }
            if (entityplayer != null) {
                entityplayer.getInventory().add(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            }
        }
        return stack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity pEntity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        playerIn.startUsingItem(handIn);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.getItemInHand(handIn));
    }
}

