/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stereowalker.survive.world.item.alchemy.SPotions;
import com.stereowalker.survive.world.item.crafting.PurifiedWaterCraftingRecipe;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class PurifiedWaterCraftingSerializer
implements RecipeSerializer<PurifiedWaterCraftingRecipe> {
    private static final MapCodec<PurifiedWaterCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(p_327212_ -> p_327212_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_299460_ -> p_299460_.getGroup()), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_297437_ -> p_297437_.category()), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_300770_ -> p_300770_.getResultItem(null)), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(p_297969_ -> {
        Object[] aingredient = (Ingredient[])p_297969_.stream().filter(p_298915_ -> !p_298915_.isEmpty()).toArray(Ingredient[]::new);
        if (aingredient.length == 0) {
            return DataResult.error(() -> "No ingredients for shapeless recipe");
        }
        return aingredient.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success(PurifiedWaterCraftingSerializer.add((NonNullList<Ingredient>)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient)));
    }, DataResult::success).forGetter(p_298509_ -> PurifiedWaterCraftingSerializer.add((NonNullList<Ingredient>)p_298509_.getIngredients()))).apply((Applicative)p_327212_, PurifiedWaterCraftingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PurifiedWaterCraftingRecipe> STREAM_CODEC = StreamCodec.of(PurifiedWaterCraftingSerializer::toNetwork, PurifiedWaterCraftingSerializer::fromNetwork);

    private static PurifiedWaterCraftingRecipe fromNetwork(RegistryFriendlyByteBuf p_335962_) {
        String s = p_335962_.readUtf();
        CraftingBookCategory craftingbookcategory = (CraftingBookCategory)p_335962_.readEnum(CraftingBookCategory.class);
        int i = p_335962_.readVarInt();
        NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
        nonnulllist.replaceAll(p_327214_ -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)p_335962_));
        ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)p_335962_);
        return new PurifiedWaterCraftingRecipe(s, craftingbookcategory, itemstack, PurifiedWaterCraftingSerializer.add((NonNullList<Ingredient>)nonnulllist));
    }

    private static void toNetwork(RegistryFriendlyByteBuf p_329239_, PurifiedWaterCraftingRecipe p_44282_) {
        p_329239_.writeUtf(p_44282_.getGroup());
        p_329239_.writeEnum((Enum)p_44282_.category());
        NonNullList<Ingredient> nonnulllist = PurifiedWaterCraftingSerializer.add((NonNullList<Ingredient>)p_44282_.getIngredients());
        p_329239_.writeVarInt(nonnulllist.size());
        for (Ingredient ingredient : nonnulllist) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)p_329239_, (Object)ingredient);
        }
        ItemStack.STREAM_CODEC.encode((Object)p_329239_, (Object)p_44282_.getResultItem(null));
    }

    protected static NonNullList<Ingredient> add(NonNullList<Ingredient> ing) {
        ItemStack potion = PotionContents.createItemStack((Item)Items.POTION, (Holder)SPotions.PURIFIED_WATER.holder());
        if (((Ingredient)ing.get(ing.size() - 1)).test(potion)) {
            return ing;
        }
        NonNullList nonnulllist = NonNullList.withSize((int)(ing.size() + 1), (Object)Ingredient.EMPTY);
        for (int j = 0; j < ing.size(); ++j) {
            nonnulllist.set(j, (Object)((Ingredient)ing.get(j)));
        }
        nonnulllist.set(ing.size(), (Object)Ingredient.of((ItemStack[])new ItemStack[]{potion}));
        return nonnulllist;
    }

    public MapCodec<PurifiedWaterCraftingRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, PurifiedWaterCraftingRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

