/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.world.level.block;

import com.stereowalker.survive.core.cauldron.SCauldronInteraction;
import com.stereowalker.survive.world.item.HygieneItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PotashCauldronBlock
extends LayeredCauldronBlock {
    public PotashCauldronBlock(BlockBehaviour.Properties properties) {
        super(Biome.Precipitation.NONE, SCauldronInteraction.DRYING, properties);
    }

    public void handlePrecipitation(BlockState pState, Level pLevel, BlockPos pPos, Biome.Precipitation pPrecipitation) {
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)LEVEL) > 0;
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (this.isUnderSun(state, worldIn, pos) && random.nextInt(2) == 0) {
            worldIn.addFreshEntity((Entity)new ItemEntity((Level)worldIn, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)HygieneItems.POTASH), 0.0, 0.0, 0.0));
            PotashCauldronBlock.lowerFillLevel((BlockState)state, (Level)worldIn, (BlockPos)pos);
        } else if (!worldIn.isClientSide && worldIn.getMaxLocalRawBrightness(pos.above()) >= 12 && random.nextInt(10) == 0) {
            worldIn.addFreshEntity((Entity)new ItemEntity((Level)worldIn, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)HygieneItems.POTASH), 0.0, 0.0, 0.0));
            PotashCauldronBlock.lowerFillLevel((BlockState)state, (Level)worldIn, (BlockPos)pos);
        }
    }

    protected boolean isUnderSun(BlockState state, ServerLevel level, BlockPos pos) {
        if (level.isDay() && !level.isClientSide) {
            float f = this.getBrightness(level, pos);
            boolean flag = level.isRainingAt(pos);
            if (f > 0.5f && !flag && level.canSeeSky(pos)) {
                return true;
            }
        }
        return false;
    }

    public float getBrightness(ServerLevel level, BlockPos pos) {
        return level.hasChunkAt(pos) ? (float)level.getBrightness(LightLayer.SKY, pos) : 0.0f;
    }
}

