/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.mixins;

import com.stereowalker.survive.Survive;
import com.stereowalker.survive.damagesource.SDamageSources;
import com.stereowalker.survive.damagesource.SDamageTypes;
import com.stereowalker.survive.mixins.EntityMixin;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.survive.needs.TemperatureData;
import com.stereowalker.survive.needs.TemperatureUtil;
import com.stereowalker.unionlib.util.VersionHelper;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends EntityMixin {
    @Shadow
    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    @Shadow
    public boolean hurt(DamageSource pSource, float pAmount) {
        return false;
    }

    @Shadow
    public ItemStack getUseItem() {
        return null;
    }

    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    public boolean aiStep_hurt_redirect(LivingEntity living, DamageSource pSource, float pAmount) {
        float amount = pAmount;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!Survive.TEMPERATURE_CONFIG.useLegacyTemperatureSystem && Survive.TEMPERATURE_CONFIG.enabled) {
                double maxCold1 = TemperatureUtil.firstCold((Player)this);
                double maxCold2 = TemperatureUtil.secondCold((Player)this);
                double maxCold3 = TemperatureUtil.maxCold((Player)this);
                TemperatureData data = ((IRealisticEntity)player).temperatureData();
                if (data.getTemperatureLevel() < maxCold1 && data.getTemperatureLevel() >= maxCold2) {
                    amount *= 1.0f;
                } else if (data.getTemperatureLevel() < maxCold2 && data.getTemperatureLevel() >= maxCold3) {
                    amount *= 10.0f;
                } else if (data.getTemperatureLevel() < maxCold3) {
                    amount *= 100.0f;
                }
            }
        }
        return living.hurt(this.damageSources().freeze(), amount);
    }

    @Redirect(method={"aiStep"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;isInPowderSnow:Z"))
    public boolean aiStep_isInPowderSnow_redirect(LivingEntity living) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!Survive.TEMPERATURE_CONFIG.useLegacyTemperatureSystem && Survive.TEMPERATURE_CONFIG.enabled) {
                TemperatureData data = ((IRealisticEntity)player).temperatureData();
                return data.getTemperatureLevel() < TemperatureUtil.firstCold((Player)this) || this.isInPowderSnow;
            }
        }
        return this.isInPowderSnow;
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getTicksFrozen()I")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void aiStep_inject_1(CallbackInfo ci) {
        int i = this.getTicksRoasted();
        if (this.canRoast() && (LivingEntity)this instanceof Player && !Survive.TEMPERATURE_CONFIG.useLegacyTemperatureSystem && Survive.TEMPERATURE_CONFIG.enabled) {
            this.setTicksRoasted(Math.min(this.getTicksRequiredToRoast(), i + 1));
        } else {
            this.setTicksRoasted(Math.max(0, i - 2));
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;tryAddFrost()V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void aiStep_inject_2(CallbackInfo ci) {
        if (!this.level().isClientSide && this.tickCount % 40 == 0 && this.isFullyRoasted() && this.canRoast()) {
            int j = this.getType().is(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES) ? 5 : 1;
            float amount = j;
            LivingEntity livingEntity = (LivingEntity)this;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (!Survive.TEMPERATURE_CONFIG.useLegacyTemperatureSystem && Survive.TEMPERATURE_CONFIG.enabled) {
                    double maxHeat1 = TemperatureUtil.firstHeat((Player)this);
                    double maxHeat2 = TemperatureUtil.secondHeat((Player)this);
                    double maxHeat3 = TemperatureUtil.maxHeat((Player)this);
                    TemperatureData data = ((IRealisticEntity)player).temperatureData();
                    if (data.getTemperatureLevel() > maxHeat1 && data.getTemperatureLevel() <= maxHeat2) {
                        amount *= 1.0f;
                    } else if (data.getTemperatureLevel() > maxHeat2 && data.getTemperatureLevel() <= maxHeat3) {
                        amount *= 10.0f;
                    } else if (data.getTemperatureLevel() > maxHeat3) {
                        amount *= 100.0f;
                    }
                }
            }
            this.hurt(SDamageSources.source(this.level().registryAccess(), SDamageTypes.ROAST), amount);
        }
    }

    @Inject(method={"completeUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;triggerItemUseEffects(Lnet/minecraft/world/item/ItemStack;I)V")})
    public void completeUsingItem_inject(CallbackInfo ci) {
        if (!VersionHelper.VanillaComponents.FOOD.hasData(this.getUseItem()) && this instanceof IRealisticEntity) {
            ((IRealisticEntity)((Object)this)).drink(this.level(), this.getUseItem());
        }
    }

    @Override
    @Overwrite
    public boolean canFreeze() {
        if (this.isSpectator()) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!Survive.TEMPERATURE_CONFIG.useLegacyTemperatureSystem && Survive.TEMPERATURE_CONFIG.enabled) {
                TemperatureData data = ((IRealisticEntity)player).temperatureData();
                return data.getTemperatureLevel() < TemperatureUtil.firstCold((Player)this) && super.canFreeze();
            }
        }
        boolean flag = !this.getItemBySlot(EquipmentSlot.HEAD).is(ItemTags.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EquipmentSlot.CHEST).is(ItemTags.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EquipmentSlot.LEGS).is(ItemTags.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EquipmentSlot.FEET).is(ItemTags.FREEZE_IMMUNE_WEARABLES);
        return flag && super.canFreeze();
    }

    @Override
    public boolean canRoast() {
        if (this.isSpectator()) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!Survive.TEMPERATURE_CONFIG.useLegacyTemperatureSystem && Survive.TEMPERATURE_CONFIG.enabled) {
                TemperatureData data = ((IRealisticEntity)player).temperatureData();
                return data.getTemperatureLevel() > TemperatureUtil.firstHeat((Player)this) && super.canRoast();
            }
        }
        boolean flag = !this.getItemBySlot(EquipmentSlot.HEAD).is(ItemTags.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EquipmentSlot.CHEST).is(ItemTags.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EquipmentSlot.LEGS).is(ItemTags.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EquipmentSlot.FEET).is(ItemTags.FREEZE_IMMUNE_WEARABLES);
        return flag && super.canRoast();
    }
}

