/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.network.protocol.game;

import com.google.common.collect.Lists;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.needs.IRealisticEntity;
import com.stereowalker.unionlib.network.protocol.game.ServerboundUnionPacket;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.Filterable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WrittenBookContent;

public class ServerboundPlayerStatusBookPacket
extends ServerboundUnionPacket {
    private WrittenBookContent book;
    private boolean celcius;
    private String sleepPage;
    private String tempPage;
    public static ResourceLocation id = VersionHelper.toLoc((String)"survive", (String)"serverbound_player_status_book");

    public ServerboundPlayerStatusBookPacket(WrittenBookContent book, boolean celcius, String sleepPage, String tempPage) {
        super(Survive.getInstance().channel);
        this.book = book;
        this.celcius = celcius;
        this.sleepPage = sleepPage;
        this.tempPage = tempPage;
    }

    public ServerboundPlayerStatusBookPacket(RegistryFriendlyByteBuf byteBuf) {
        super(byteBuf, Survive.getInstance().channel);
        this.book = (WrittenBookContent)WrittenBookContent.STREAM_CODEC.decode((Object)byteBuf);
        this.celcius = byteBuf.readBoolean();
        this.sleepPage = byteBuf.readUtf();
        this.tempPage = byteBuf.readUtf();
    }

    public void encode(FriendlyByteBuf byteBuf) {
        WrittenBookContent.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)byteBuf), (Object)this.book);
        byteBuf.writeBoolean(this.celcius);
        byteBuf.writeUtf(this.sleepPage);
        byteBuf.writeUtf(this.tempPage);
    }

    public boolean handleOnServer(ServerPlayer sender) {
        if (sender.getItemInHand(InteractionHand.MAIN_HAND).getItem().equals(Items.WRITTEN_BOOK) && sender instanceof IRealisticEntity) {
            IRealisticEntity real = (IRealisticEntity)sender;
            ArrayList contents = Lists.newArrayList();
            int pages = 6;
            if (contents.size() < pages) {
                while (contents.size() < pages) {
                    contents.add(contents.size(), Filterable.passThrough((Object)Component.literal((String)"")));
                }
            }
            String status0 = "\u00a72\u00a7nGeneral:\u00a7r\nWater Level = " + real.waterData().getWaterLevel() + "\nHydration = " + real.waterData().getHydrationLevel() + "\nFood Level = " + sender.getFoodData().getFoodLevel() + "\nSaturation Level = " + sender.getFoodData().getSaturationLevel() + "\nEnergy Level = " + real.staminaData().getLTS();
            Object status1 = "\u00a72\u00a7nWellness:\u00a7r\n";
            status1 = real.wellbeingData().isWell() ? (String)status1 + "No ilnesses dectected" : (String)status1 + "Intensity = " + (real.wellbeingData().getIntensity() + 1) + "\nReason = " + real.wellbeingData().getReason() + "\n";
            Object status3 = "\u00a72\u00a7nHygiene:\u00a7r\n";
            status3 = (String)status3 + "Cleanliness level = " + (100 - real.hygieneData().getUncleanLevel());
            Object status4 = "\u00a72\u00a7nNutrition:\u00a7r\n";
            status4 = (String)status4 + "Carbohydrates = " + real.nutritionData().carbs().level() + "\nProteins = " + real.nutritionData().protein().level() + "\nFats = " + real.nutritionData().fat().level() + "\n";
            Function<String, Filterable> ft = s -> Filterable.passThrough((Object)Component.literal((String)s));
            contents.set(0, ft.apply(status0));
            contents.set(1, ft.apply((String)status1));
            contents.set(2, ft.apply(String.format(this.sleepPage, Float.valueOf(real.sleepData().getDaysAwake()))));
            contents.set(3, ft.apply((String)status3));
            contents.set(4, ft.apply((String)status4));
            contents.set(5, ft.apply(String.format(this.tempPage, !this.celcius ? real.temperatureData().getFahrenheit() + " \u00b0F" : real.temperatureData().getCelcius() + " \u00b0C")));
            sender.getItemInHand(InteractionHand.MAIN_HAND).set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)this.book.withReplacedPages((List)contents));
        }
        return true;
    }

    public ResourceLocation id() {
        return id;
    }
}

