/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.resource;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.json.ArmorJsonHolder;
import com.stereowalker.survive.world.DataMaps;
import com.stereowalker.unionlib.resource.IResourceReloadListener;
import com.stereowalker.unionlib.util.VersionHelper;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.registries.ForgeRegistries;

public class ArmorDataManager
implements IResourceReloadListener<Map<ResourceLocation, ArmorJsonHolder>> {
    public CompletableFuture<Map<ResourceLocation, ArmorJsonHolder>> load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, ArmorJsonHolder> drinkMap = new HashMap<ResourceLocation, ArmorJsonHolder>();
            for (Map.Entry resource : manager.listResources("survive_modifiers/armors", s -> s.toString().endsWith(".json")).entrySet()) {
                ResourceLocation drinkId = VersionHelper.toLoc((String)((ResourceLocation)resource.getKey()).getNamespace(), (String)((ResourceLocation)resource.getKey()).getPath().replace("survive_modifiers/armors/", "").replace(".json", ""));
                if (ForgeRegistries.ITEMS.containsKey(drinkId)) {
                    try (InputStream stream = ((Resource)resource.getValue()).open();
                         InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        ArmorJsonHolder drinkData = new ArmorJsonHolder(drinkId, object);
                        Survive.getInstance().getLogger().info("Found armor modifier for the item {}", (Object)drinkId);
                        drinkMap.put(drinkId, drinkData);
                    }
                    catch (Exception e) {
                        Survive.getInstance().getLogger().warn("Error reading the armor modifier for the item {}!", (Object)drinkId, (Object)e);
                    }
                    continue;
                }
                Survive.getInstance().getLogger().warn("No such armor exists with the item id {}!", (Object)drinkId);
            }
            return drinkMap;
        });
    }

    public CompletableFuture<Void> apply(Map<ResourceLocation, ArmorJsonHolder> data, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            DataMaps.Server.syncedClients.clear();
            for (ResourceLocation drinkId : data.keySet()) {
                Survive.registerArmorTemperatures(drinkId, (ArmorJsonHolder)data.get(drinkId));
            }
        });
    }

    public ResourceLocation id() {
        return VersionHelper.toLoc((String)"survive:armor_data");
    }
}

