/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.survive.hooks;

import com.google.common.collect.ImmutableMap;
import com.stereowalker.survive.FoodUtils;
import com.stereowalker.survive.Survive;
import com.stereowalker.survive.world.item.SItems;
import com.stereowalker.survive.world.item.component.SDataComponents;
import com.stereowalker.unionlib.util.VersionHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public interface ColdStorage {
    public float coldness();

    public float maxColdness();

    public void setColdness(float var1);

    public long lastAccessed();

    public void setLastAccessed(long var1);

    public float lossFactor();

    public int slotCount();

    public ItemStack get(int var1);

    public void set(int var1, ItemStack var2);

    default public ContainerData data() {
        return new ContainerData(){

            public void set(int pIndex, int pValue) {
                if (pIndex == 0) {
                    ColdStorage.this.setColdness(pValue);
                }
            }

            public int getCount() {
                return 2;
            }

            public int get(int pIndex) {
                if (pIndex == 0) {
                    return Mth.ceil((float)ColdStorage.this.coldness());
                }
                if (pIndex == 1) {
                    return Mth.ceil((float)ColdStorage.this.maxColdness());
                }
                return 0;
            }
        };
    }

    default public void decrementColdness(long by) {
        this.setColdness(this.coldness() - this.lossFactor() * (float)by);
        if (this.coldness() < 0.0f) {
            this.setColdness(0.0f);
        }
    }

    default public float preservatonEfficiency() {
        return 1.0f - this.lossFactor();
    }

    default public void load(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.setColdness(pTag.getFloat("coldness"));
        this.setLastAccessed(pTag.getLong("lastAccessed"));
    }

    default public void save(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.putFloat("coldness", this.coldness());
        pTag.putLong("lastAccessed", this.lastAccessed());
    }

    default public void coldTick(Level pLevel) {
        if (Survive.FOOD_CONFIG.enabled) {
            ItemStack stack;
            ImmutableMap COOLNESS = new ImmutableMap.Builder().put((Object)SItems.ICE_CUBE, (Object)Float.valueOf(38.0f)).put((Object)Items.ICE, (Object)Float.valueOf(342.0f)).build();
            long gameTime = pLevel.getGameTime();
            if (this.lastAccessed() == 0L) {
                this.setLastAccessed(gameTime);
            }
            long timeSinceLastOpened = gameTime - this.lastAccessed();
            int foodAmount = 0;
            for (int i = 0; i < this.slotCount(); ++i) {
                ItemStack stack2 = this.get(i);
                if (!VersionHelper.VanillaComponents.FOOD.hasData(stack2)) continue;
                FoodUtils.giveLifespanToFood(stack2, gameTime);
                foodAmount += stack2.getCount();
            }
            float coldnessValue = this.coldness();
            if (foodAmount > 0) {
                for (int i = 0; i < this.slotCount() && !(coldnessValue >= this.maxColdness()); ++i) {
                    int take;
                    float remainingColdness = this.maxColdness() - coldnessValue;
                    stack = this.get(i);
                    if (COOLNESS.containsKey(stack.getItem())) {
                        take = Math.min(Mth.floor((float)(remainingColdness / ((Float)COOLNESS.get(stack.getItem())).floatValue())), stack.getCount());
                        coldnessValue += ((Float)COOLNESS.get(stack.getItem())).floatValue() * (float)take;
                        stack.shrink(take);
                    }
                    if (stack.getItem() == Items.PACKED_ICE) {
                        take = Math.min(Mth.floor((float)(remainingColdness / 3078.0f)), stack.getCount());
                        coldnessValue += 3078.0f * (float)take;
                        stack.shrink(take);
                    }
                    if (stack.getItem() != Items.BLUE_ICE) continue;
                    take = Math.min(Mth.floor((float)(remainingColdness / 27702.0f)), stack.getCount());
                    coldnessValue += 27702.0f * (float)take;
                    stack.shrink(take);
                }
                this.setColdness(coldnessValue);
            }
            this.setLastAccessed(gameTime);
            if (this.coldness() > 0.0f) {
                float efficiency = (float)timeSinceLastOpened * this.preservatonEfficiency();
                if (timeSinceLastOpened <= 2L) {
                    efficiency = 1.0f;
                }
                for (int i = 0; i < this.slotCount(); ++i) {
                    stack = this.get(i);
                    if (!SDataComponents.FOOD_STATUS_D.hasData(stack)) continue;
                    float eff = efficiency;
                    SDataComponents.FOOD_STATUS_D.editData(stack, food_status -> food_status.extendTime(eff));
                }
                this.decrementColdness(timeSinceLastOpened * (long)foodAmount);
            }
        }
    }
}

